/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.MemoryResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CGroupsMemoryResourceHandlerImpl
implements MemoryResourceHandler {
    static final Logger LOG = LoggerFactory.getLogger(CGroupsMemoryResourceHandlerImpl.class);
    private static final CGroupsHandler.CGroupController MEMORY = CGroupsHandler.CGroupController.MEMORY;
    private static final int OPPORTUNISTIC_SWAPPINESS = 100;
    private static final int OPPORTUNISTIC_SOFT_LIMIT = 0;
    private CGroupsHandler cGroupsHandler;
    private boolean enforce = true;
    private int swappiness = 0;
    private float softLimit = 0.0f;

    CGroupsMemoryResourceHandlerImpl(CGroupsHandler cGroupsHandler) {
        this.cGroupsHandler = cGroupsHandler;
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration conf) throws ResourceHandlerException {
        boolean pmemEnabled = conf.getBoolean("yarn.nodemanager.pmem-check-enabled", true);
        boolean vmemEnabled = conf.getBoolean("yarn.nodemanager.vmem-check-enabled", true);
        if (pmemEnabled || vmemEnabled) {
            String msg = "The default YARN physical and/or virtual memory health checkers as well as the CGroups memory controller are enabled. If you wish to use the Cgroups memory controller, please turn off the default physical/virtual memory checkers by setting yarn.nodemanager.pmem-check-enabled and yarn.nodemanager.vmem-check-enabled to false.";
            throw new ResourceHandlerException(msg);
        }
        this.cGroupsHandler.initializeCGroupController(MEMORY);
        this.enforce = conf.getBoolean("yarn.nodemanager.resource.memory.enforced", true);
        this.swappiness = conf.getInt("yarn.nodemanager.resource.memory.cgroups.swappiness", 0);
        if (this.swappiness < 0 || this.swappiness > 100) {
            throw new ResourceHandlerException("Illegal value '" + this.swappiness + "' for " + "yarn.nodemanager.resource.memory.cgroups.swappiness" + ". Value must be between 0 and 100.");
        }
        float softLimitPerc = conf.getFloat("yarn.nodemanager.resource.memory.cgroups.soft-limit-percentage", 90.0f);
        this.softLimit = softLimitPerc / 100.0f;
        if (softLimitPerc < 0.0f || softLimitPerc > 100.0f) {
            throw new ResourceHandlerException("Illegal value '" + softLimitPerc + "' " + "yarn.nodemanager.resource.memory.cgroups.soft-limit-percentage" + ". Value must be between 0 and 100.");
        }
        return null;
    }

    @VisibleForTesting
    int getSwappiness() {
        return this.swappiness;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        return null;
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        String cgroupId = container.getContainerId().toString();
        long containerSoftLimit = (long)((float)container.getResource().getMemorySize() * this.softLimit);
        long containerHardLimit = container.getResource().getMemorySize();
        this.cGroupsHandler.createCGroup(MEMORY, cgroupId);
        if (this.enforce) {
            try {
                this.cGroupsHandler.updateCGroupParam(MEMORY, cgroupId, "limit_in_bytes", String.valueOf(containerHardLimit) + "M");
                ContainerTokenIdentifier id = container.getContainerTokenIdentifier();
                if (id != null && id.getExecutionType() == ExecutionType.OPPORTUNISTIC) {
                    this.cGroupsHandler.updateCGroupParam(MEMORY, cgroupId, "soft_limit_in_bytes", String.valueOf(0) + "M");
                    this.cGroupsHandler.updateCGroupParam(MEMORY, cgroupId, "swappiness", String.valueOf(100));
                } else {
                    this.cGroupsHandler.updateCGroupParam(MEMORY, cgroupId, "soft_limit_in_bytes", String.valueOf(containerSoftLimit) + "M");
                    this.cGroupsHandler.updateCGroupParam(MEMORY, cgroupId, "swappiness", String.valueOf(this.swappiness));
                }
            }
            catch (ResourceHandlerException re) {
                this.cGroupsHandler.deleteCGroup(MEMORY, cgroupId);
                LOG.warn("Could not update cgroup for container", (Throwable)((Object)re));
                throw re;
            }
        }
        ArrayList<PrivilegedOperation> ret = new ArrayList<PrivilegedOperation>();
        ret.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, "cgroups=" + this.cGroupsHandler.getPathForCGroupTasks(MEMORY, cgroupId)));
        return ret;
    }

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        this.cGroupsHandler.deleteCGroup(MEMORY, containerId.toString());
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        return null;
    }

    public String toString() {
        return CGroupsMemoryResourceHandlerImpl.class.getName();
    }
}

