/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DefaultLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLinuxContainerRuntime.class);
    private final PrivilegedOperationExecutor privilegedOperationExecutor;
    private Configuration conf;

    public DefaultLinuxContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor) {
        this.privilegedOperationExecutor = privilegedOperationExecutor;
    }

    @Override
    public boolean isRuntimeRequested(Map<String, String> env) {
        String type = env.get("YARN_CONTAINER_RUNTIME_TYPE");
        return type == null || type.equals("default");
    }

    @Override
    public void initialize(Configuration conf, Context nmContext) throws ContainerExecutionException {
        this.conf = conf;
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        PrivilegedOperation launchOp = new PrivilegedOperation(PrivilegedOperation.OperationType.LAUNCH_CONTAINER);
        launchOp.appendArgs(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.LAUNCH_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.APPID), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_ID_STR), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR).toString(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH).toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TOKENS_PATH).toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID_FILE_PATH).toString(), StringUtils.join((char)'%', (Iterable)ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCAL_DIRS)), StringUtils.join((char)'%', (Iterable)ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOG_DIRS)), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RESOURCES_OPTIONS));
        String tcCommandFile = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.TC_COMMAND_FILE);
        if (tcCommandFile != null) {
            launchOp.appendArgs(tcCommandFile);
        }
        launchOp.disableFailureLogging();
        List prefixCommands = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LAUNCH_PREFIX_COMMANDS);
        try {
            this.privilegedOperationExecutor.executePrivilegedOperation(prefixCommands, launchOp, null, null, false, false);
        }
        catch (PrivilegedOperationException e) {
            throw new ContainerExecutionException("Launch container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void relaunchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        this.launchContainer(ctx);
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        PrivilegedOperation signalOp = new PrivilegedOperation(PrivilegedOperation.OperationType.SIGNAL_CONTAINER);
        signalOp.appendArgs(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.SIGNAL_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID), Integer.toString(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL).getValue()));
        signalOp.disableFailureLogging();
        try {
            PrivilegedOperationExecutor executor = PrivilegedOperationExecutor.getInstance(this.conf);
            executor.executePrivilegedOperation(null, signalOp, null, null, false, false);
        }
        catch (PrivilegedOperationException e) {
            throw new ContainerExecutionException("Signal container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }

    @Override
    public String[] getIpAndHost(Container container) {
        return ContainerExecutor.getLocalIpAndHost(container);
    }
}

