/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Charsets;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.GeneratedMessage;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.namenode.BlockResolver;
import org.apache.hadoop.hdfs.server.namenode.FSImageCompression;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FixedBlockResolver;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NullBlockAliasMap;
import org.apache.hadoop.hdfs.server.namenode.SingleUGIResolver;
import org.apache.hadoop.hdfs.server.namenode.TreePath;
import org.apache.hadoop.hdfs.server.namenode.UGIResolver;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ImageWriter
implements Closeable {
    private static final int ONDISK_VERSION = 1;
    private static final int LAYOUT_VERSION = -64;
    private final Path outdir;
    private final FileSystem outfs;
    private final File dirsTmp;
    private final OutputStream dirs;
    private final File inodesTmp;
    private final OutputStream inodes;
    private final MessageDigest digest;
    private final FSImageCompression compress;
    private final long startBlock;
    private final long startInode;
    private final UGIResolver ugis;
    private final BlockAliasMap.Writer<FileRegion> blocks;
    private final BlockResolver blockIds;
    private final Map<Long, FsImageProto.INodeDirectorySection.DirEntry.Builder> dircache;
    private final TrackedOutputStream<DigestOutputStream> raw;
    private boolean closed = false;
    private long curSec;
    private long curBlock;
    private final AtomicLong curInode;
    private final FsImageProto.FileSummary.Builder summary = FsImageProto.FileSummary.newBuilder().setOndiskVersion(1).setLayoutVersion(-64);
    private final String blockPoolID;

    public static Options defaults() {
        return new Options();
    }

    public ImageWriter(Options opts) throws IOException {
        OutputStream out;
        if (null == opts.outStream) {
            FileSystem fs = opts.outdir.getFileSystem(opts.getConf());
            this.outfs = fs instanceof LocalFileSystem ? ((LocalFileSystem)fs).getRaw() : fs;
            Path tmp = opts.outdir;
            if (!this.outfs.mkdirs(tmp)) {
                throw new IOException("Failed to create output dir: " + tmp);
            }
            try (NNStorage stor = new NNStorage(opts.getConf(), Arrays.asList(tmp.toUri()), Arrays.asList(tmp.toUri()));){
                NamespaceInfo info = NNStorage.newNamespaceInfo();
                if (info.getLayoutVersion() != -64) {
                    throw new IllegalStateException("Incompatible layout " + info.getLayoutVersion() + " (expected " + -64);
                }
                if (opts.clusterID.length() > 0) {
                    info.setClusterID(opts.clusterID);
                }
                if (opts.blockPoolID.length() > 0) {
                    info.setBlockPoolID(opts.blockPoolID);
                }
                stor.format(info);
                this.blockPoolID = info.getBlockPoolID();
            }
            this.outdir = new Path(tmp, "current");
            out = this.outfs.create(new Path(this.outdir, "fsimage_0000000000000000000"));
        } else {
            this.outdir = null;
            this.outfs = null;
            out = opts.outStream;
            this.blockPoolID = "";
        }
        this.digest = MD5Hash.getDigester();
        this.raw = new TrackedOutputStream<DigestOutputStream>(new DigestOutputStream(new BufferedOutputStream(out), this.digest));
        this.compress = opts.compress;
        CompressionCodec codec = this.compress.getImageCodec();
        if (codec != null) {
            this.summary.setCodec(codec.getClass().getCanonicalName());
        }
        this.curBlock = this.startBlock = opts.startBlock;
        this.startInode = opts.startInode;
        this.curInode = new AtomicLong(this.startInode);
        this.dircache = Collections.synchronizedMap(new DirEntryCache(opts.maxdircache));
        this.ugis = null == opts.ugis ? (UGIResolver)ReflectionUtils.newInstance((Class)opts.ugisClass, (Configuration)opts.getConf()) : opts.ugis;
        BlockAliasMap fmt = null == opts.blocks ? (BlockAliasMap)ReflectionUtils.newInstance((Class)opts.aliasMap, (Configuration)opts.getConf()) : opts.blocks;
        this.blocks = fmt.getWriter(null, this.blockPoolID);
        this.blockIds = null == opts.blockIds ? (BlockResolver)ReflectionUtils.newInstance((Class)opts.blockIdsClass, (Configuration)opts.getConf()) : opts.blockIds;
        FileOutputStream dirsTmpStream = null;
        try {
            this.dirsTmp = File.createTempFile("fsimg_dir", null);
            this.dirsTmp.deleteOnExit();
            dirsTmpStream = new FileOutputStream(this.dirsTmp);
            this.dirs = this.beginSection(dirsTmpStream);
        }
        catch (IOException e) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.raw, dirsTmpStream});
            throw e;
        }
        try {
            this.inodesTmp = File.createTempFile("fsimg_inode", null);
            this.inodesTmp.deleteOnExit();
            this.inodes = new FileOutputStream(this.inodesTmp);
        }
        catch (IOException e) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.raw, dirsTmpStream, this.dirs});
            throw e;
        }
        this.raw.write(FSImageUtil.MAGIC_HEADER);
        this.curSec = ((TrackedOutputStream)this.raw).pos;
        assert (((TrackedOutputStream)this.raw).pos == (long)FSImageUtil.MAGIC_HEADER.length);
    }

    public void accept(TreePath e) throws IOException {
        assert (e.getParentId() < this.curInode.get());
        long id = this.curInode.getAndIncrement();
        e.accept(id);
        assert (e.getId() < this.curInode.get());
        FsImageProto.INodeSection.INode n = e.toINode(this.ugis, this.blockIds, this.blocks);
        this.writeInode(n);
        if (e.getParentId() > 0L) {
            FsImageProto.INodeDirectorySection.DirEntry.Builder de = FsImageProto.INodeDirectorySection.DirEntry.newBuilder().setParent(e.getParentId()).addChildren(e.getId());
            this.dircache.put(e.getParentId(), de);
        }
    }

    synchronized void writeInode(FsImageProto.INodeSection.INode n) throws IOException {
        n.writeDelimitedTo(this.inodes);
    }

    synchronized void writeDirEntry(FsImageProto.INodeDirectorySection.DirEntry e) throws IOException {
        e.writeDelimitedTo(this.dirs);
    }

    private static int getOndiskSize(GeneratedMessage s) {
        return CodedOutputStream.computeRawVarint32Size((int)s.getSerializedSize()) + s.getSerializedSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        for (FsImageProto.INodeDirectorySection.DirEntry.Builder b : this.dircache.values()) {
            FsImageProto.INodeDirectorySection.DirEntry e = b.build();
            this.writeDirEntry(e);
        }
        this.dircache.clear();
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.dirs, this.inodes, this.blocks});
        if (null == this.dirs || null == this.inodes) {
            if (this.raw != null) {
                this.raw.close();
            }
            return;
        }
        try {
            this.writeNameSystemSection();
            this.writeINodeSection();
            this.writeDirSection();
            this.writeStringTableSection();
            FsImageProto.FileSummary s = this.summary.build();
            s.writeDelimitedTo(this.raw);
            int length = ImageWriter.getOndiskSize((GeneratedMessage)s);
            byte[] lengthBytes = new byte[4];
            ByteBuffer.wrap(lengthBytes).asIntBuffer().put(length);
            this.raw.write(lengthBytes);
        }
        finally {
            this.raw.close();
        }
        this.writeMD5("fsimage_0000000000000000000");
        this.closed = true;
    }

    void writeMD5(String imagename) throws IOException {
        if (null == this.outdir) {
            return;
        }
        MD5Hash md5 = new MD5Hash(this.digest.digest());
        String digestString = StringUtils.byteToHexString((byte[])md5.getDigest());
        Path chk = new Path(this.outdir, imagename + ".md5");
        try (FSDataOutputStream out = this.outfs.create(chk);){
            String md5Line = digestString + " *" + imagename + "\n";
            out.write(md5Line.getBytes(Charsets.UTF_8));
        }
    }

    OutputStream beginSection(OutputStream out) throws IOException {
        CompressionCodec codec = this.compress.getImageCodec();
        if (null == codec) {
            return out;
        }
        return codec.createOutputStream(out);
    }

    void endSection(OutputStream out, FSImageFormatProtobuf.SectionName name) throws IOException {
        CompressionCodec codec = this.compress.getImageCodec();
        if (codec != null) {
            ((CompressorStream)out).finish();
        }
        out.flush();
        long length = ((TrackedOutputStream)this.raw).pos - this.curSec;
        this.summary.addSections(FsImageProto.FileSummary.Section.newBuilder().setName(name.toString()).setOffset(this.curSec).setLength(length));
        this.curSec += length;
    }

    void writeNameSystemSection() throws IOException {
        FsImageProto.NameSystemSection.Builder b = FsImageProto.NameSystemSection.newBuilder().setGenstampV1(1000L).setGenstampV1Limit(0L).setGenstampV2(1001L).setLastAllocatedBlockId(this.blockIds.lastId()).setTransactionId(0L);
        FsImageProto.NameSystemSection s = b.build();
        OutputStream sec = this.beginSection(this.raw);
        s.writeDelimitedTo(sec);
        this.endSection(sec, FSImageFormatProtobuf.SectionName.NS_INFO);
    }

    void writeINodeSection() throws IOException {
        FsImageProto.INodeSection.Builder b = FsImageProto.INodeSection.newBuilder().setNumInodes(this.curInode.get() - this.startInode).setLastInodeId(this.curInode.get());
        FsImageProto.INodeSection s = b.build();
        OutputStream sec = this.beginSection(this.raw);
        s.writeDelimitedTo(sec);
        try (FileInputStream in = new FileInputStream(this.inodesTmp);){
            IOUtils.copyBytes((InputStream)in, (OutputStream)sec, (int)4096, (boolean)false);
        }
        this.endSection(sec, FSImageFormatProtobuf.SectionName.INODE);
    }

    void writeDirSection() throws IOException {
        TrackedOutputStream<DigestOutputStream> sec = this.raw;
        try (FileInputStream in = new FileInputStream(this.dirsTmp);){
            IOUtils.copyBytes((InputStream)in, sec, (int)4096, (boolean)false);
        }
        this.endSection(sec, FSImageFormatProtobuf.SectionName.INODE_DIR);
    }

    void writeFilesUCSection() throws IOException {
        FsImageProto.FilesUnderConstructionSection.Builder b = FsImageProto.FilesUnderConstructionSection.newBuilder();
        FsImageProto.FilesUnderConstructionSection s = b.build();
        OutputStream sec = this.beginSection(this.raw);
        s.writeDelimitedTo(sec);
        this.endSection(sec, FSImageFormatProtobuf.SectionName.FILES_UNDERCONSTRUCTION);
    }

    void writeSnapshotDiffSection() throws IOException {
        FsImageProto.SnapshotDiffSection.Builder b = FsImageProto.SnapshotDiffSection.newBuilder();
        FsImageProto.SnapshotDiffSection s = b.build();
        OutputStream sec = this.beginSection(this.raw);
        s.writeDelimitedTo(sec);
        this.endSection(sec, FSImageFormatProtobuf.SectionName.SNAPSHOT_DIFF);
    }

    void writeSecretManagerSection() throws IOException {
        FsImageProto.SecretManagerSection.Builder b = FsImageProto.SecretManagerSection.newBuilder().setCurrentId(0).setTokenSequenceNumber(0);
        FsImageProto.SecretManagerSection s = b.build();
        OutputStream sec = this.beginSection(this.raw);
        s.writeDelimitedTo(sec);
        this.endSection(sec, FSImageFormatProtobuf.SectionName.SECRET_MANAGER);
    }

    void writeCacheManagerSection() throws IOException {
        FsImageProto.CacheManagerSection.Builder b = FsImageProto.CacheManagerSection.newBuilder().setNumPools(0).setNumDirectives(0).setNextDirectiveId(1L);
        FsImageProto.CacheManagerSection s = b.build();
        OutputStream sec = this.beginSection(this.raw);
        s.writeDelimitedTo(sec);
        this.endSection(sec, FSImageFormatProtobuf.SectionName.CACHE_MANAGER);
    }

    void writeStringTableSection() throws IOException {
        FsImageProto.StringTableSection.Builder b = FsImageProto.StringTableSection.newBuilder();
        Map<Integer, String> u = this.ugis.ugiMap();
        b.setNumEntry(u.size());
        FsImageProto.StringTableSection s = b.build();
        OutputStream sec = this.beginSection(this.raw);
        s.writeDelimitedTo(sec);
        for (Map.Entry<Integer, String> e : u.entrySet()) {
            FsImageProto.StringTableSection.Entry.Builder x = FsImageProto.StringTableSection.Entry.newBuilder().setId(e.getKey().intValue()).setStr(e.getValue());
            x.build().writeDelimitedTo(sec);
        }
        this.endSection(sec, FSImageFormatProtobuf.SectionName.STRING_TABLE);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ codec=\"").append(this.compress.getImageCodec());
        sb.append("\", startBlock=").append(this.startBlock);
        sb.append(", curBlock=").append(this.curBlock);
        sb.append(", startInode=").append(this.startInode);
        sb.append(", curInode=").append(this.curInode);
        sb.append(", ugi=").append(this.ugis);
        sb.append(", blockIds=").append(this.blockIds);
        sb.append(", offset=").append(((TrackedOutputStream)this.raw).pos);
        sb.append(" }");
        return sb.toString();
    }

    public static class Options
    implements Configurable {
        public static final String START_INODE = "hdfs.image.writer.start.inode";
        public static final String CACHE_ENTRY = "hdfs.image.writer.cache.entries";
        public static final String UGI_CLASS = "hdfs.image.writer.ugi.class";
        public static final String BLOCK_RESOLVER_CLASS = "hdfs.image.writer.blockresolver.class";
        private Path outdir;
        private Configuration conf;
        private OutputStream outStream;
        private int maxdircache;
        private long startBlock;
        private long startInode;
        private UGIResolver ugis;
        private Class<? extends UGIResolver> ugisClass;
        private BlockAliasMap<FileRegion> blocks;
        private String clusterID;
        private String blockPoolID;
        private Class<? extends BlockAliasMap> aliasMap;
        private BlockResolver blockIds;
        private Class<? extends BlockResolver> blockIdsClass;
        private FSImageCompression compress = FSImageCompression.createNoopCompression();

        protected Options() {
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
            String def = new File("hdfs/name").toURI().toString();
            this.outdir = new Path(conf.get("dfs.namenode.name.dir", def));
            this.startBlock = conf.getLong("hdfs.image.writer.resolver.fixed.block.start", 0x40000001L);
            this.startInode = conf.getLong(START_INODE, 16385L);
            this.maxdircache = conf.getInt(CACHE_ENTRY, 100);
            this.ugisClass = conf.getClass(UGI_CLASS, SingleUGIResolver.class, UGIResolver.class);
            this.aliasMap = conf.getClass("dfs.provided.aliasmap.class", NullBlockAliasMap.class, BlockAliasMap.class);
            this.blockIdsClass = conf.getClass(BLOCK_RESOLVER_CLASS, FixedBlockResolver.class, BlockResolver.class);
            this.clusterID = "";
            this.blockPoolID = "";
        }

        public Configuration getConf() {
            return this.conf;
        }

        public Options output(String out) {
            this.outdir = new Path(out);
            return this;
        }

        public Options outStream(OutputStream outStream) {
            this.outStream = outStream;
            return this;
        }

        public Options codec(String codec) throws IOException {
            this.compress = FSImageCompression.createCompression((Configuration)this.getConf(), (String)codec);
            return this;
        }

        public Options cache(int nDirEntries) {
            this.maxdircache = nDirEntries;
            return this;
        }

        public Options ugi(UGIResolver ugis) {
            this.ugis = ugis;
            return this;
        }

        public Options ugi(Class<? extends UGIResolver> ugisClass) {
            this.ugisClass = ugisClass;
            return this;
        }

        public Options blockIds(BlockResolver blockIds) {
            this.blockIds = blockIds;
            return this;
        }

        public Options blockIds(Class<? extends BlockResolver> blockIdsClass) {
            this.blockIdsClass = blockIdsClass;
            return this;
        }

        public Options blocks(BlockAliasMap<FileRegion> blocks) {
            this.blocks = blocks;
            return this;
        }

        public Options blocks(Class<? extends BlockAliasMap> blocksClass) {
            this.aliasMap = blocksClass;
            return this;
        }

        public Options clusterID(String clusterID) {
            this.clusterID = clusterID;
            return this;
        }

        public Options blockPoolID(String blockPoolID) {
            this.blockPoolID = blockPoolID;
            return this;
        }
    }

    static class TrackedOutputStream<T extends OutputStream>
    extends FilterOutputStream {
        private long pos = 0L;

        TrackedOutputStream(T out) {
            super((OutputStream)out);
        }

        public T getInner() {
            return (T)this.out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.pos;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.pos += (long)len;
        }

        @Override
        public void flush() throws IOException {
            super.flush();
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }

    class DirEntryCache
    extends LinkedHashMap<Long, FsImageProto.INodeDirectorySection.DirEntry.Builder> {
        private final int nEntries;

        DirEntryCache(int nEntries) {
            this.nEntries = nEntries;
        }

        @Override
        public FsImageProto.INodeDirectorySection.DirEntry.Builder put(Long p, FsImageProto.INodeDirectorySection.DirEntry.Builder b) {
            FsImageProto.INodeDirectorySection.DirEntry.Builder e = (FsImageProto.INodeDirectorySection.DirEntry.Builder)this.get(p);
            if (null == e) {
                return super.put(p, b);
            }
            e.addAllChildren((Iterable)b.getChildrenList());
            return e;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, FsImageProto.INodeDirectorySection.DirEntry.Builder> be) {
            if (this.size() > this.nEntries) {
                FsImageProto.INodeDirectorySection.DirEntry d = be.getValue().build();
                try {
                    ImageWriter.this.writeDirEntry(d);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
            return false;
        }
    }
}

