/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.shaded.org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.hadoop.shaded.org.apache.commons.lang.builder.HashCodeBuilder;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CachePoolInfo {
    public static final long RELATIVE_EXPIRY_NEVER = 0x1FFFFFFFFFFFFFFFL;
    public static final long DEFAULT_MAX_RELATIVE_EXPIRY = 0x1FFFFFFFFFFFFFFFL;
    public static final long LIMIT_UNLIMITED = Long.MAX_VALUE;
    public static final long DEFAULT_LIMIT = Long.MAX_VALUE;
    public static final short DEFAULT_REPLICATION_NUM = 1;
    final String poolName;
    @Nullable
    String ownerName;
    @Nullable
    String groupName;
    @Nullable
    FsPermission mode;
    @Nullable
    Long limit;
    @Nullable
    private Short defaultReplication;
    @Nullable
    Long maxRelativeExpiryMs;

    public CachePoolInfo(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public CachePoolInfo setOwnerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public CachePoolInfo setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public FsPermission getMode() {
        return this.mode;
    }

    public CachePoolInfo setMode(FsPermission mode) {
        this.mode = mode;
        return this;
    }

    public Long getLimit() {
        return this.limit;
    }

    public CachePoolInfo setLimit(Long bytes) {
        this.limit = bytes;
        return this;
    }

    public Short getDefaultReplication() {
        return this.defaultReplication;
    }

    public CachePoolInfo setDefaultReplication(Short repl) {
        this.defaultReplication = repl;
        return this;
    }

    public Long getMaxRelativeExpiryMs() {
        return this.maxRelativeExpiryMs;
    }

    public CachePoolInfo setMaxRelativeExpiryMs(Long ms) {
        this.maxRelativeExpiryMs = ms;
        return this;
    }

    public String toString() {
        return "{poolName:" + this.poolName + ", ownerName:" + this.ownerName + ", groupName:" + this.groupName + ", mode:" + (this.mode == null ? "null" : String.format("0%03o", this.mode.toShort())) + ", limit:" + this.limit + ", defaultReplication:" + this.defaultReplication + ", maxRelativeExpiryMs:" + this.maxRelativeExpiryMs + "}";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        CachePoolInfo other = (CachePoolInfo)o;
        return new EqualsBuilder().append((Object)this.poolName, (Object)other.poolName).append((Object)this.ownerName, (Object)other.ownerName).append((Object)this.groupName, (Object)other.groupName).append((Object)this.mode, (Object)other.mode).append((Object)this.limit, (Object)other.limit).append((Object)this.defaultReplication, (Object)other.defaultReplication).append((Object)this.maxRelativeExpiryMs, (Object)other.maxRelativeExpiryMs).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.poolName).append((Object)this.ownerName).append((Object)this.groupName).append((Object)this.mode).append((Object)this.limit).append((Object)this.defaultReplication).append((Object)this.maxRelativeExpiryMs).hashCode();
    }

    public static void validate(CachePoolInfo info) throws IOException {
        if (info == null) {
            throw new InvalidRequestException("CachePoolInfo is null");
        }
        if (info.getLimit() != null && info.getLimit() < 0L) {
            throw new InvalidRequestException("Limit is negative.");
        }
        if (info.getDefaultReplication() != null && info.getDefaultReplication() < 0) {
            throw new InvalidRequestException("Default Replication is negative");
        }
        if (info.getMaxRelativeExpiryMs() != null) {
            long maxRelativeExpiryMs = info.getMaxRelativeExpiryMs();
            if (maxRelativeExpiryMs < 0L) {
                throw new InvalidRequestException("Max relative expiry is negative.");
            }
            if (maxRelativeExpiryMs > 0x1FFFFFFFFFFFFFFFL) {
                throw new InvalidRequestException("Max relative expiry is too big.");
            }
        }
        CachePoolInfo.validateName(info.poolName);
    }

    public static void validateName(String poolName) throws IOException {
        if (poolName == null || poolName.isEmpty()) {
            throw new IOException("invalid empty cache pool name");
        }
    }
}

