/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecordBuilderImpl;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.shaded.org.apache.commons.lang.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableRollingAverages
extends MutableMetric
implements Closeable {
    private MutableRatesWithAggregation innerMetrics = new MutableRatesWithAggregation();
    @VisibleForTesting
    static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MutableRollingAverages-%d").build());
    private ScheduledFuture<?> scheduledTask = null;
    @Nullable
    private Map<String, MutableRate> currentSnapshot;
    private final String avgInfoNameTemplate;
    private final String avgInfoDescTemplate;
    private int numWindows;
    private Map<String, LinkedBlockingDeque<SumAndCount>> averages = new ConcurrentHashMap<String, LinkedBlockingDeque<SumAndCount>>();
    private static final long WINDOW_SIZE_MS_DEFAULT = 300000L;
    private static final int NUM_WINDOWS_DEFAULT = 36;

    public MutableRollingAverages(String metricValueName) {
        if (metricValueName == null) {
            metricValueName = "";
        }
        this.avgInfoNameTemplate = "[%s]RollingAvg" + StringUtils.capitalize((String)metricValueName);
        this.avgInfoDescTemplate = "Rolling average " + StringUtils.uncapitalize((String)metricValueName) + " for %s";
        this.numWindows = 36;
        this.scheduledTask = SCHEDULER.scheduleAtFixedRate(new RatesRoller(this), 300000L, 300000L, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    synchronized void replaceScheduledTask(int windows, long interval, TimeUnit timeUnit) {
        this.numWindows = windows;
        this.scheduledTask.cancel(true);
        this.scheduledTask = SCHEDULER.scheduleAtFixedRate(new RatesRoller(this), interval, interval, timeUnit);
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            for (Map.Entry<String, LinkedBlockingDeque<SumAndCount>> entry : this.averages.entrySet()) {
                String name = entry.getKey();
                MetricsInfo avgInfo = Interns.info(String.format(this.avgInfoNameTemplate, StringUtils.capitalize((String)name)), String.format(this.avgInfoDescTemplate, StringUtils.uncapitalize((String)name)));
                double totalSum = 0.0;
                long totalCount = 0L;
                for (SumAndCount sumAndCount : entry.getValue()) {
                    totalCount += sumAndCount.getCount();
                    totalSum += sumAndCount.getSum();
                }
                if (totalCount == 0L) continue;
                builder.addGauge(avgInfo, totalSum / (double)totalCount);
            }
            if (this.changed()) {
                this.clearChanged();
            }
        }
    }

    public void collectThreadLocalStates() {
        this.innerMetrics.collectThreadLocalStates();
    }

    public void add(String name, long value) {
        this.innerMetrics.add(name, value);
    }

    private synchronized void rollOverAvgs() {
        if (this.currentSnapshot == null) {
            return;
        }
        for (Map.Entry<String, MutableRate> entry : this.currentSnapshot.entrySet()) {
            SumAndCount sumAndCount;
            MutableRate rate = entry.getValue();
            LinkedBlockingDeque<SumAndCount> deque = this.averages.computeIfAbsent(entry.getKey(), new Function<String, LinkedBlockingDeque<SumAndCount>>(){

                @Override
                public LinkedBlockingDeque<SumAndCount> apply(String k) {
                    return new LinkedBlockingDeque<SumAndCount>(MutableRollingAverages.this.numWindows);
                }
            });
            if (deque.offerLast(sumAndCount = new SumAndCount(rate.lastStat().total(), rate.lastStat().numSamples()))) continue;
            deque.pollFirst();
            deque.offerLast(sumAndCount);
        }
        this.setChanged();
    }

    @Override
    public void close() throws IOException {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
        }
        this.scheduledTask = null;
    }

    public synchronized Map<String, Double> getStats(long minSamples) {
        HashMap<String, Double> stats = new HashMap<String, Double>();
        for (Map.Entry<String, LinkedBlockingDeque<SumAndCount>> entry : this.averages.entrySet()) {
            String name = entry.getKey();
            double totalSum = 0.0;
            long totalCount = 0L;
            for (SumAndCount sumAndCount : entry.getValue()) {
                totalCount += sumAndCount.getCount();
                totalSum += sumAndCount.getSum();
            }
            if (totalCount <= minSamples) continue;
            stats.put(name, totalSum / (double)totalCount);
        }
        return stats;
    }

    private static class RatesRoller
    implements Runnable {
        private final MutableRollingAverages parent;

        RatesRoller(MutableRollingAverages parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MutableRollingAverages mutableRollingAverages = this.parent;
            synchronized (mutableRollingAverages) {
                MetricsCollectorImpl mc = new MetricsCollectorImpl();
                MetricsRecordBuilderImpl rb = mc.addRecord("RatesRoller");
                this.parent.innerMetrics.snapshot(rb, true);
                Preconditions.checkState((mc.getRecords().size() == 1 ? 1 : 0) != 0, (Object)"There must be only one record and it's named with 'RatesRoller'");
                this.parent.currentSnapshot = this.parent.innerMetrics.getGlobalMetrics();
                this.parent.rollOverAvgs();
            }
            this.parent.setChanged();
        }
    }

    private static class SumAndCount {
        private final double sum;
        private final long count;

        SumAndCount(double sum, long count) {
            this.sum = sum;
            this.count = count;
        }

        public double getSum() {
            return this.sum;
        }

        public long getCount() {
            return this.count;
        }
    }
}

