/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.conf.HAUtil;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class YarnConfiguration
extends Configuration {
    @InterfaceAudience.Private
    public static final String DR_CONFIGURATION_FILE = "dynamic-resources.xml";
    @InterfaceAudience.Private
    public static final String CS_CONFIGURATION_FILE = "capacity-scheduler.xml";
    @InterfaceAudience.Private
    public static final String HADOOP_POLICY_CONFIGURATION_FILE = "hadoop-policy.xml";
    @InterfaceAudience.Private
    public static final String YARN_SITE_CONFIGURATION_FILE = "yarn-site.xml";
    private static final String YARN_DEFAULT_CONFIGURATION_FILE = "yarn-default.xml";
    @InterfaceAudience.Private
    public static final String CORE_SITE_CONFIGURATION_FILE = "core-site.xml";
    @InterfaceAudience.Private
    public static final String RESOURCE_TYPES_CONFIGURATION_FILE = "resource-types.xml";
    @InterfaceAudience.Private
    public static final String NODE_RESOURCES_CONFIGURATION_FILE = "node-resources.xml";
    @InterfaceAudience.Private
    public static final List<String> RM_CONFIGURATION_FILES = Collections.unmodifiableList(Arrays.asList("resource-types.xml", "dynamic-resources.xml", "capacity-scheduler.xml", "hadoop-policy.xml", "yarn-site.xml", "core-site.xml"));
    @InterfaceAudience.Private
    public static final List<String> NM_CONFIGURATION_FILES = Collections.unmodifiableList(Arrays.asList("node-resources.xml", "dynamic-resources.xml", "capacity-scheduler.xml", "hadoop-policy.xml", "yarn-site.xml", "core-site.xml"));
    @InterfaceStability.Evolving
    public static final int APPLICATION_MAX_TAGS = 10;
    @InterfaceStability.Evolving
    public static final int APPLICATION_MAX_TAG_LENGTH = 100;
    public static final String YARN_PREFIX = "yarn.";
    public static final String RESOURCE_TYPES = "yarn.resource-types";
    public static final String NM_RESOURCES_PREFIX = "yarn.nodemanager.resource-type.";
    public static final String DEBUG_NM_DELETE_DELAY_SEC = "yarn.nodemanager.delete.debug-delay-sec";
    public static final String NM_LOG_CONTAINER_DEBUG_INFO = "yarn.nodemanager.log-container-debug-info.enabled";
    public static final boolean DEFAULT_NM_LOG_CONTAINER_DEBUG_INFO = true;
    public static final String IPC_PREFIX = "yarn.ipc.";
    public static final String IPC_CLIENT_FACTORY_CLASS = "yarn.ipc.client.factory.class";
    public static final String DEFAULT_IPC_CLIENT_FACTORY_CLASS = "org.apache.hadoop.yarn.factories.impl.pb.RpcClientFactoryPBImpl";
    public static final String IPC_SERVER_FACTORY_CLASS = "yarn.ipc.server.factory.class";
    public static final String DEFAULT_IPC_SERVER_FACTORY_CLASS = "org.apache.hadoop.yarn.factories.impl.pb.RpcServerFactoryPBImpl";
    public static final String IPC_RECORD_FACTORY_CLASS = "yarn.ipc.record.factory.class";
    public static final String DEFAULT_IPC_RECORD_FACTORY_CLASS = "org.apache.hadoop.yarn.factories.impl.pb.RecordFactoryPBImpl";
    public static final String IPC_RPC_IMPL = "yarn.ipc.rpc.class";
    public static final String DEFAULT_IPC_RPC_IMPL = "org.apache.hadoop.yarn.ipc.HadoopYarnProtoRPC";
    public static final String RM_PREFIX = "yarn.resourcemanager.";
    public static final String RM_CLUSTER_ID = "yarn.resourcemanager.cluster-id";
    public static final String DEFAULT_RM_CLUSTER_ID = "yarn_cluster";
    public static final String RM_HOSTNAME = "yarn.resourcemanager.hostname";
    public static final String RM_EPOCH = "yarn.resourcemanager.epoch";
    public static final long DEFAULT_RM_EPOCH = 0L;
    public static final String RM_ADDRESS = "yarn.resourcemanager.address";
    public static final int DEFAULT_RM_PORT = 8032;
    public static final String DEFAULT_RM_ADDRESS = "0.0.0.0:8032";
    public static final String RM_APPLICATION_MASTER_SERVICE_PROCESSORS = "yarn.resourcemanager.application-master-service.processors";
    public static final String RM_AUTO_UPDATE_CONTAINERS = "yarn.resourcemanager.auto-update.containers";
    public static final boolean DEFAULT_RM_AUTO_UPDATE_CONTAINERS = false;
    public static final String RM_BIND_HOST = "yarn.resourcemanager.bind-host";
    public static final String RM_CLIENT_THREAD_COUNT = "yarn.resourcemanager.client.thread-count";
    public static final int DEFAULT_RM_CLIENT_THREAD_COUNT = 50;
    public static final String RM_AMLAUNCHER_THREAD_COUNT = "yarn.resourcemanager.amlauncher.thread-count";
    public static final int DEFAULT_RM_AMLAUNCHER_THREAD_COUNT = 50;
    public static final String RM_NODEMANAGER_CONNECT_RETRIES = "yarn.resourcemanager.nodemanager-connect-retries";
    public static final int DEFAULT_RM_NODEMANAGER_CONNECT_RETRIES = 10;
    public static final String RM_PRINCIPAL = "yarn.resourcemanager.principal";
    public static final String RM_SCHEDULER_ADDRESS = "yarn.resourcemanager.scheduler.address";
    public static final int DEFAULT_RM_SCHEDULER_PORT = 8030;
    public static final String DEFAULT_RM_SCHEDULER_ADDRESS = "0.0.0.0:8030";
    public static final String RM_SCHEDULER_MINIMUM_ALLOCATION_MB = "yarn.scheduler.minimum-allocation-mb";
    public static final int DEFAULT_RM_SCHEDULER_MINIMUM_ALLOCATION_MB = 1024;
    public static final String RM_SCHEDULER_MINIMUM_ALLOCATION_VCORES = "yarn.scheduler.minimum-allocation-vcores";
    public static final int DEFAULT_RM_SCHEDULER_MINIMUM_ALLOCATION_VCORES = 1;
    public static final String RM_SCHEDULER_MAXIMUM_ALLOCATION_MB = "yarn.scheduler.maximum-allocation-mb";
    public static final int DEFAULT_RM_SCHEDULER_MAXIMUM_ALLOCATION_MB = 8192;
    public static final String RM_SCHEDULER_MAXIMUM_ALLOCATION_VCORES = "yarn.scheduler.maximum-allocation-vcores";
    public static final int DEFAULT_RM_SCHEDULER_MAXIMUM_ALLOCATION_VCORES = 4;
    public static final String RM_SCHEDULER_CLIENT_THREAD_COUNT = "yarn.resourcemanager.scheduler.client.thread-count";
    public static final int DEFAULT_RM_SCHEDULER_CLIENT_THREAD_COUNT = 50;
    public static final String RM_SCHEDULER_INCLUDE_PORT_IN_NODE_NAME = "yarn.scheduler.include-port-in-node-name";
    public static final boolean DEFAULT_RM_SCHEDULER_USE_PORT_FOR_NODE_NAME = false;
    public static final String QUEUE_PLACEMENT_RULES = "yarn.scheduler.queue-placement-rules";
    public static final String USER_GROUP_PLACEMENT_RULE = "user-group";
    public static final String RM_WEBAPP_UI_ACTIONS_ENABLED = "yarn.resourcemanager.webapp.ui-actions.enabled";
    public static final boolean DEFAULT_RM_WEBAPP_UI_ACTIONS_ENABLED = true;
    public static final String RM_RESERVATION_SYSTEM_ENABLE = "yarn.resourcemanager.reservation-system.enable";
    public static final boolean DEFAULT_RM_RESERVATION_SYSTEM_ENABLE = false;
    public static final String RM_RESERVATION_SYSTEM_CLASS = "yarn.resourcemanager.reservation-system.class";
    public static final String RM_RESERVATION_SYSTEM_PLAN_FOLLOWER = "yarn.resourcemanager.reservation-system.plan.follower";
    public static final String RM_RESERVATION_SYSTEM_PLAN_FOLLOWER_TIME_STEP = "yarn.resourcemanager.reservation-system.planfollower.time-step";
    public static final long DEFAULT_RM_RESERVATION_SYSTEM_PLAN_FOLLOWER_TIME_STEP = 1000L;
    public static final String RM_RESERVATION_SYSTEM_MAX_PERIODICITY = "yarn.resourcemanager.reservation-system.max-periodicity";
    public static final long DEFAULT_RM_RESERVATION_SYSTEM_MAX_PERIODICITY = 86400000L;
    public static final String RM_SCHEDULER_ENABLE_MONITORS = "yarn.resourcemanager.scheduler.monitor.enable";
    public static final boolean DEFAULT_RM_SCHEDULER_ENABLE_MONITORS = false;
    public static final String RM_SCHEDULER_MONITOR_POLICIES = "yarn.resourcemanager.scheduler.monitor.policies";
    public static final String RM_WEBAPP_ADDRESS = "yarn.resourcemanager.webapp.address";
    public static final int DEFAULT_RM_WEBAPP_PORT = 8088;
    public static final String DEFAULT_RM_WEBAPP_ADDRESS = "0.0.0.0:8088";
    public static final String RM_WEBAPP_HTTPS_ADDRESS = "yarn.resourcemanager.webapp.https.address";
    public static final boolean YARN_SSL_CLIENT_HTTPS_NEED_AUTH_DEFAULT = false;
    public static final String YARN_SSL_SERVER_RESOURCE_DEFAULT = "ssl-server.xml";
    public static final int DEFAULT_RM_WEBAPP_HTTPS_PORT = 8090;
    public static final String DEFAULT_RM_WEBAPP_HTTPS_ADDRESS = "0.0.0.0:8090";
    public static final String YARN_WEBAPP_UI2_ENABLE = "yarn.webapp.ui2.enable";
    public static final boolean DEFAULT_YARN_WEBAPP_UI2_ENABLE = false;
    public static final String YARN_WEBAPP_UI2_WARFILE_PATH = "yarn.webapp.ui2.war-file-path";
    public static final String YARN_API_SERVICES_ENABLE = "yarn.webapp.api-service.enable";
    @InterfaceAudience.Private
    public static final String DEFAULT_YARN_API_SYSTEM_SERVICES_CLASS = "org.apache.hadoop.yarn.service.client.SystemServiceManagerImpl";
    public static final String RM_RESOURCE_TRACKER_ADDRESS = "yarn.resourcemanager.resource-tracker.address";
    public static final int DEFAULT_RM_RESOURCE_TRACKER_PORT = 8031;
    public static final String DEFAULT_RM_RESOURCE_TRACKER_ADDRESS = "0.0.0.0:8031";
    public static final String RM_AM_EXPIRY_INTERVAL_MS = "yarn.am.liveness-monitor.expiry-interval-ms";
    public static final int DEFAULT_RM_AM_EXPIRY_INTERVAL_MS = 600000;
    public static final String RM_NM_EXPIRY_INTERVAL_MS = "yarn.nm.liveness-monitor.expiry-interval-ms";
    public static final int DEFAULT_RM_NM_EXPIRY_INTERVAL_MS = 600000;
    public static final String YARN_ACL_ENABLE = "yarn.acl.enable";
    public static final boolean DEFAULT_YARN_ACL_ENABLE = false;
    public static final String YARN_RESERVATION_ACL_ENABLE = "yarn.acl.reservation-enable";
    public static final boolean DEFAULT_YARN_RESERVATION_ACL_ENABLE = false;
    public static final String YARN_ADMIN_ACL = "yarn.admin.acl";
    public static final String DEFAULT_YARN_ADMIN_ACL = "*";
    public static final String DEFAULT_YARN_APP_ACL = " ";
    @InterfaceStability.Unstable
    public static final String OPPORTUNISTIC_CONTAINER_ALLOCATION_ENABLED = "yarn.resourcemanager.opportunistic-container-allocation.enabled";
    public static final boolean DEFAULT_OPPORTUNISTIC_CONTAINER_ALLOCATION_ENABLED = false;
    @InterfaceStability.Unstable
    public static final String OPP_CONTAINER_ALLOCATION_NODES_NUMBER_USED = "yarn.resourcemanager.opportunistic-container-allocation.nodes-used";
    public static final int DEFAULT_OPP_CONTAINER_ALLOCATION_NODES_NUMBER_USED = 10;
    @InterfaceStability.Unstable
    public static final String NM_CONTAINER_QUEUING_SORTING_NODES_INTERVAL_MS = "yarn.resourcemanager.nm-container-queuing.sorting-nodes-interval-ms";
    public static final long DEFAULT_NM_CONTAINER_QUEUING_SORTING_NODES_INTERVAL_MS = 1000L;
    @InterfaceStability.Unstable
    public static final String NM_CONTAINER_QUEUING_LOAD_COMPARATOR = "yarn.resourcemanager.nm-container-queuing.load-comparator";
    public static final String DEFAULT_NM_CONTAINER_QUEUING_LOAD_COMPARATOR = "QUEUE_LENGTH";
    @InterfaceStability.Unstable
    public static final String NM_CONTAINER_QUEUING_LIMIT_STDEV = "yarn.resourcemanager.nm-container-queuing.queue-limit-stdev";
    public static final float DEFAULT_NM_CONTAINER_QUEUING_LIMIT_STDEV = 1.0f;
    @InterfaceStability.Unstable
    public static final String NM_CONTAINER_QUEUING_MIN_QUEUE_LENGTH = "yarn.resourcemanager.nm-container-queuing.min-queue-length";
    public static final int DEFAULT_NM_CONTAINER_QUEUING_MIN_QUEUE_LENGTH = 5;
    @InterfaceStability.Unstable
    public static final String NM_CONTAINER_QUEUING_MAX_QUEUE_LENGTH = "yarn.resourcemanager.nm-container-queuing.max-queue-length";
    public static final int DEFAULT_NM_CONTAINER_QUEUING_MAX_QUEUE_LENGTH = 15;
    @InterfaceStability.Unstable
    public static final String NM_CONTAINER_QUEUING_MIN_QUEUE_WAIT_TIME_MS = "yarn.resourcemanager.nm-container-queuing.min-queue-wait-time-ms";
    public static final int DEFAULT_NM_CONTAINER_QUEUING_MIN_QUEUE_WAIT_TIME_MS = 10;
    @InterfaceStability.Unstable
    public static final String NM_CONTAINER_QUEUING_MAX_QUEUE_WAIT_TIME_MS = "yarn.resourcemanager.nm-container-queuing.max-queue-wait-time-ms";
    public static final int DEFAULT_NM_CONTAINER_QUEUING_MAX_QUEUE_WAIT_TIME_MS = 100;
    @InterfaceAudience.Private
    public static final String YARN_INTERMEDIATE_DATA_ENCRYPTION = "yarn.intermediate-data-encryption.enable";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_YARN_INTERMEDIATE_DATA_ENCRYPTION = false;
    public static final String RM_ADMIN_ADDRESS = "yarn.resourcemanager.admin.address";
    public static final int DEFAULT_RM_ADMIN_PORT = 8033;
    public static final String DEFAULT_RM_ADMIN_ADDRESS = "0.0.0.0:8033";
    public static final String RM_ADMIN_CLIENT_THREAD_COUNT = "yarn.resourcemanager.admin.client.thread-count";
    public static final int DEFAULT_RM_ADMIN_CLIENT_THREAD_COUNT = 1;
    public static final String RM_AM_MAX_ATTEMPTS = "yarn.resourcemanager.am.max-attempts";
    public static final int DEFAULT_RM_AM_MAX_ATTEMPTS = 2;
    public static final String RM_KEYTAB = "yarn.resourcemanager.keytab";
    public static final String RM_WEBAPP_SPNEGO_USER_NAME_KEY = "yarn.resourcemanager.webapp.spnego-principal";
    public static final String RM_WEBAPP_SPNEGO_KEYTAB_FILE_KEY = "yarn.resourcemanager.webapp.spnego-keytab-file";
    public static final String RM_WEBAPP_DELEGATION_TOKEN_AUTH_FILTER = "yarn.resourcemanager.webapp.delegation-token-auth-filter.enabled";
    public static final boolean DEFAULT_RM_WEBAPP_DELEGATION_TOKEN_AUTH_FILTER = true;
    public static final String RM_WEBAPP_ENABLE_CORS_FILTER = "yarn.resourcemanager.webapp.cross-origin.enabled";
    public static final boolean DEFAULT_RM_WEBAPP_ENABLE_CORS_FILTER = false;
    public static final String RM_CONTAINER_ALLOC_EXPIRY_INTERVAL_MS = "yarn.resourcemanager.rm.container-allocation.expiry-interval-ms";
    public static final int DEFAULT_RM_CONTAINER_ALLOC_EXPIRY_INTERVAL_MS = 600000;
    public static final String RM_NODES_INCLUDE_FILE_PATH = "yarn.resourcemanager.nodes.include-path";
    public static final String DEFAULT_RM_NODES_INCLUDE_FILE_PATH = "";
    public static final String RM_NODES_EXCLUDE_FILE_PATH = "yarn.resourcemanager.nodes.exclude-path";
    public static final String DEFAULT_RM_NODES_EXCLUDE_FILE_PATH = "";
    public static final String RM_RESOURCE_TRACKER_CLIENT_THREAD_COUNT = "yarn.resourcemanager.resource-tracker.client.thread-count";
    public static final int DEFAULT_RM_RESOURCE_TRACKER_CLIENT_THREAD_COUNT = 50;
    public static final String RM_SCHEDULER = "yarn.resourcemanager.scheduler.class";
    @InterfaceAudience.Private
    public static final String RM_PLACEMENT_CONSTRAINTS_HANDLER = "yarn.resourcemanager.placement-constraints.handler";
    @InterfaceAudience.Private
    public static final String DISABLED_RM_PLACEMENT_CONSTRAINTS_HANDLER = "disabled";
    @InterfaceAudience.Private
    public static final String PROCESSOR_RM_PLACEMENT_CONSTRAINTS_HANDLER = "placement-processor";
    @InterfaceAudience.Private
    public static final String SCHEDULER_RM_PLACEMENT_CONSTRAINTS_HANDLER = "scheduler";
    public static final String RM_PLACEMENT_CONSTRAINTS_ALGORITHM_CLASS = "yarn.resourcemanager.placement-constraints.algorithm.class";
    public static final String RM_PLACEMENT_CONSTRAINTS_ALGORITHM_ITERATOR = "yarn.resourcemanager.placement-constraints.algorithm.iterator";
    public static final String RM_PLACEMENT_CONSTRAINTS_RETRY_ATTEMPTS = "yarn.resourcemanager.placement-constraints.retry-attempts";
    public static final int DEFAULT_RM_PLACEMENT_CONSTRAINTS_RETRY_ATTEMPTS = 3;
    public static final String RM_PLACEMENT_CONSTRAINTS_ALGORITHM_POOL_SIZE = "yarn.resourcemanager.placement-constraints.algorithm.pool-size";
    public static final int DEFAULT_RM_PLACEMENT_CONSTRAINTS_ALGORITHM_POOL_SIZE = 1;
    public static final String RM_PLACEMENT_CONSTRAINTS_SCHEDULER_POOL_SIZE = "yarn.resourcemanager.placement-constraints.scheduler.pool-size";
    public static final int DEFAULT_RM_PLACEMENT_CONSTRAINTS_SCHEDULER_POOL_SIZE = 1;
    public static final String DEFAULT_RM_SCHEDULER = "org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler";
    public static final String RM_NM_HEARTBEAT_INTERVAL_MS = "yarn.resourcemanager.nodemanagers.heartbeat-interval-ms";
    public static final long DEFAULT_RM_NM_HEARTBEAT_INTERVAL_MS = 1000L;
    public static final String RM_HISTORY_WRITER_MULTI_THREADED_DISPATCHER_POOL_SIZE = "yarn.resourcemanager.history-writer.multi-threaded-dispatcher.pool-size";
    public static final int DEFAULT_RM_HISTORY_WRITER_MULTI_THREADED_DISPATCHER_POOL_SIZE = 10;
    public static final String RM_SYSTEM_METRICS_PUBLISHER_ENABLED = "yarn.resourcemanager.system-metrics-publisher.enabled";
    public static final boolean DEFAULT_RM_SYSTEM_METRICS_PUBLISHER_ENABLED = false;
    public static final String SYSTEM_METRICS_PUBLISHER_ENABLED = "yarn.system-metrics-publisher.enabled";
    public static final boolean DEFAULT_SYSTEM_METRICS_PUBLISHER_ENABLED = false;
    public static final String RM_PUBLISH_CONTAINER_EVENTS_ENABLED = "yarn.rm.system-metrics-publisher.emit-container-events";
    public static final boolean DEFAULT_RM_PUBLISH_CONTAINER_EVENTS_ENABLED = false;
    public static final String RM_SYSTEM_METRICS_PUBLISHER_DISPATCHER_POOL_SIZE = "yarn.resourcemanager.system-metrics-publisher.dispatcher.pool-size";
    public static final int DEFAULT_RM_SYSTEM_METRICS_PUBLISHER_DISPATCHER_POOL_SIZE = 10;
    public static final String RM_DELEGATION_KEY_UPDATE_INTERVAL_KEY = "yarn.resourcemanager.delegation.key.update-interval";
    public static final long RM_DELEGATION_KEY_UPDATE_INTERVAL_DEFAULT = 86400000L;
    public static final String RM_DELEGATION_TOKEN_RENEW_INTERVAL_KEY = "yarn.resourcemanager.delegation.token.renew-interval";
    public static final long RM_DELEGATION_TOKEN_RENEW_INTERVAL_DEFAULT = 86400000L;
    public static final String RM_DELEGATION_TOKEN_MAX_LIFETIME_KEY = "yarn.resourcemanager.delegation.token.max-lifetime";
    public static final long RM_DELEGATION_TOKEN_MAX_LIFETIME_DEFAULT = 604800000L;
    public static final String RM_DELEGATION_TOKEN_MAX_CONF_SIZE = "yarn.resourcemanager.delegation-token.max-conf-size-bytes";
    public static final int DEFAULT_RM_DELEGATION_TOKEN_MAX_CONF_SIZE_BYTES = 12800;
    public static final String RECOVERY_ENABLED = "yarn.resourcemanager.recovery.enabled";
    public static final boolean DEFAULT_RM_RECOVERY_ENABLED = false;
    public static final String YARN_FAIL_FAST = "yarn.fail-fast";
    public static final boolean DEFAULT_YARN_FAIL_FAST = false;
    public static final String RM_FAIL_FAST = "yarn.resourcemanager.fail-fast";
    @InterfaceAudience.Private
    public static final String RM_WORK_PRESERVING_RECOVERY_ENABLED = "yarn.resourcemanager.work-preserving-recovery.enabled";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_RM_WORK_PRESERVING_RECOVERY_ENABLED = true;
    public static final String RM_WORK_PRESERVING_RECOVERY_SCHEDULING_WAIT_MS = "yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms";
    public static final long DEFAULT_RM_WORK_PRESERVING_RECOVERY_SCHEDULING_WAIT_MS = 10000L;
    public static final String RM_ZK_PREFIX = "yarn.resourcemanager.zk-";
    public static final String RM_ZK_ADDRESS = "yarn.resourcemanager.zk-address";
    public static final String RM_ZK_NUM_RETRIES = "yarn.resourcemanager.zk-num-retries";
    public static final int DEFAULT_ZK_RM_NUM_RETRIES = 1000;
    public static final String RM_ZK_ZNODE_SIZE_LIMIT_BYTES = "yarn.resourcemanager.zk-max-znode-size.bytes";
    public static final int DEFAULT_RM_ZK_ZNODE_SIZE_LIMIT_BYTES = 0x100000;
    public static final String RM_ZK_RETRY_INTERVAL_MS = "yarn.resourcemanager.zk-retry-interval-ms";
    public static final int DEFAULT_RM_ZK_RETRY_INTERVAL_MS = 1000;
    public static final String RM_ZK_TIMEOUT_MS = "yarn.resourcemanager.zk-timeout-ms";
    public static final int DEFAULT_RM_ZK_TIMEOUT_MS = 10000;
    public static final String ZK_APPID_NODE_SPLIT_INDEX = "yarn.resourcemanager.zk-appid-node.split-index";
    public static final int DEFAULT_ZK_APPID_NODE_SPLIT_INDEX = 0;
    public static final String ZK_DELEGATION_TOKEN_NODE_SPLIT_INDEX = "yarn.resourcemanager.zk-delegation-token-node.split-index";
    public static final int DEFAULT_ZK_DELEGATION_TOKEN_NODE_SPLIT_INDEX = 0;
    public static final String RM_ZK_ACL = "yarn.resourcemanager.zk-acl";
    public static final String DEFAULT_RM_ZK_ACL = "world:anyone:rwcda";
    public static final String RM_ZK_AUTH = "yarn.resourcemanager.zk-auth";
    public static final String ZK_STATE_STORE_PREFIX = "yarn.resourcemanager.zk-state-store.";
    public static final String ZK_RM_STATE_STORE_PARENT_PATH = "yarn.resourcemanager.zk-state-store.parent-path";
    public static final String DEFAULT_ZK_RM_STATE_STORE_PARENT_PATH = "/rmstore";
    public static final String ZK_RM_STATE_STORE_ROOT_NODE_ACL = "yarn.resourcemanager.zk-state-store.root-node.acl";
    public static final String RM_HA_PREFIX = "yarn.resourcemanager.ha.";
    public static final String RM_HA_ENABLED = "yarn.resourcemanager.ha.enabled";
    public static final boolean DEFAULT_RM_HA_ENABLED = false;
    public static final String RM_HA_IDS = "yarn.resourcemanager.ha.rm-ids";
    public static final String RM_HA_ID = "yarn.resourcemanager.ha.id";
    public static final String FS_BASED_RM_CONF_STORE = "yarn.resourcemanager.configuration.file-system-based-store";
    public static final String DEFAULT_FS_BASED_RM_CONF_STORE = "/yarn/conf";
    public static final String RM_CONFIGURATION_PROVIDER_CLASS = "yarn.resourcemanager.configuration.provider-class";
    public static final String DEFAULT_RM_CONFIGURATION_PROVIDER_CLASS = "org.apache.hadoop.yarn.LocalConfigurationProvider";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String SCHEDULER_CONFIGURATION_STORE_CLASS = "yarn.scheduler.configuration.store.class";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String FILE_CONFIGURATION_STORE = "file";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String MEMORY_CONFIGURATION_STORE = "memory";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String LEVELDB_CONFIGURATION_STORE = "leveldb";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String ZK_CONFIGURATION_STORE = "zk";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String DEFAULT_CONFIGURATION_STORE = "file";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String RM_SCHEDCONF_STORE_PATH = "yarn.scheduler.configuration.leveldb-store.path";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String RM_SCHEDCONF_LEVELDB_COMPACTION_INTERVAL_SECS = "yarn.scheduler.configuration.leveldb-store.compaction-interval-secs";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final long DEFAULT_RM_SCHEDCONF_LEVELDB_COMPACTION_INTERVAL_SECS = 86400L;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String RM_SCHEDCONF_MAX_LOGS = "yarn.scheduler.configuration.store.max-logs";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final long DEFAULT_RM_SCHEDCONF_LEVELDB_MAX_LOGS = 1000L;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final long DEFAULT_RM_SCHEDCONF_ZK_MAX_LOGS = 1000L;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String RM_SCHEDCONF_STORE_ZK_PARENT_PATH = "yarn.scheduler.configuration.zk-store.parent-path";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String DEFAULT_RM_SCHEDCONF_STORE_ZK_PARENT_PATH = "/confstore";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String RM_SCHEDULER_MUTATION_ACL_POLICY_CLASS = "yarn.scheduler.configuration.mutation.acl-policy.class";
    public static final String YARN_AUTHORIZATION_PROVIDER = "yarn.authorization-provider";
    private static final List<String> RM_SERVICES_ADDRESS_CONF_KEYS_HTTP;
    private static final List<String> RM_SERVICES_ADDRESS_CONF_KEYS_HTTPS;
    public static final String AUTO_FAILOVER_PREFIX = "yarn.resourcemanager.ha.automatic-failover.";
    public static final String AUTO_FAILOVER_ENABLED = "yarn.resourcemanager.ha.automatic-failover.enabled";
    public static final boolean DEFAULT_AUTO_FAILOVER_ENABLED = true;
    @Deprecated
    public static final String AUTO_FAILOVER_EMBEDDED = "yarn.resourcemanager.ha.automatic-failover.embedded";
    @Deprecated
    public static final boolean DEFAULT_AUTO_FAILOVER_EMBEDDED = true;
    public static final String AUTO_FAILOVER_ZK_BASE_PATH = "yarn.resourcemanager.ha.automatic-failover.zk-base-path";
    public static final String DEFAULT_AUTO_FAILOVER_ZK_BASE_PATH = "/yarn-leader-election";
    public static final String CLIENT_FAILOVER_PREFIX = "yarn.client.failover-";
    public static final String CLIENT_FAILOVER_PROXY_PROVIDER = "yarn.client.failover-proxy-provider";
    public static final String DEFAULT_CLIENT_FAILOVER_PROXY_PROVIDER = "org.apache.hadoop.yarn.client.ConfiguredRMFailoverProxyProvider";
    public static final String CLIENT_FAILOVER_MAX_ATTEMPTS = "yarn.client.failover-max-attempts";
    public static final String CLIENT_FAILOVER_SLEEPTIME_BASE_MS = "yarn.client.failover-sleep-base-ms";
    public static final String CLIENT_FAILOVER_SLEEPTIME_MAX_MS = "yarn.client.failover-sleep-max-ms";
    public static final String CLIENT_FAILOVER_RETRIES = "yarn.client.failover-retries";
    public static final int DEFAULT_CLIENT_FAILOVER_RETRIES = 0;
    public static final String CLIENT_FAILOVER_RETRIES_ON_SOCKET_TIMEOUTS = "yarn.client.failover-retries-on-socket-timeouts";
    public static final int DEFAULT_CLIENT_FAILOVER_RETRIES_ON_SOCKET_TIMEOUTS = 0;
    public static final String RM_HA_FC_ELECTOR_ZK_RETRIES_KEY = "yarn.resourcemanager.ha.failover-controller.active-standby-elector.zk.retries";
    @InterfaceStability.Unstable
    @Deprecated
    public static final String CURATOR_LEADER_ELECTOR = "yarn.resourcemanager.ha.curator-leader-elector.enabled";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final boolean DEFAULT_CURATOR_LEADER_ELECTOR_ENABLED = false;
    public static final String RM_STORE = "yarn.resourcemanager.store.class";
    public static final String FS_RM_STATE_STORE_URI = "yarn.resourcemanager.fs.state-store.uri";
    public static final String FS_RM_STATE_STORE_NUM_RETRIES = "yarn.resourcemanager.fs.state-store.num-retries";
    public static final int DEFAULT_FS_RM_STATE_STORE_NUM_RETRIES = 0;
    public static final String FS_RM_STATE_STORE_RETRY_INTERVAL_MS = "yarn.resourcemanager.fs.state-store.retry-interval-ms";
    public static final long DEFAULT_FS_RM_STATE_STORE_RETRY_INTERVAL_MS = 1000L;
    public static final String RM_LEVELDB_STORE_PATH = "yarn.resourcemanager.leveldb-state-store.path";
    public static final String RM_LEVELDB_COMPACTION_INTERVAL_SECS = "yarn.resourcemanager.leveldb-state-store.compaction-interval-secs";
    public static final long DEFAULT_RM_LEVELDB_COMPACTION_INTERVAL_SECS = 3600L;
    public static final String RM_MAX_COMPLETED_APPLICATIONS = "yarn.resourcemanager.max-completed-applications";
    public static final int DEFAULT_RM_MAX_COMPLETED_APPLICATIONS = 1000;
    public static final String RM_STATE_STORE_MAX_COMPLETED_APPLICATIONS = "yarn.resourcemanager.state-store.max-completed-applications";
    @Deprecated
    public static final int DEFAULT_RM_STATE_STORE_MAX_COMPLETED_APPLICATIONS = 1000;
    public static final String DEFAULT_APPLICATION_NAME = "N/A";
    public static final String DEFAULT_APPLICATION_TYPE = "YARN";
    public static final int APPLICATION_TYPE_LENGTH = 20;
    public static final String DEFAULT_QUEUE_NAME = "default";
    public static final String RM_METRICS_RUNTIME_BUCKETS = "yarn.resourcemanager.metrics.runtime.buckets";
    public static final String DEFAULT_RM_METRICS_RUNTIME_BUCKETS = "60,300,1440";
    public static final String RM_AMRM_TOKEN_MASTER_KEY_ROLLING_INTERVAL_SECS = "yarn.resourcemanager.am-rm-tokens.master-key-rolling-interval-secs";
    public static final long DEFAULT_RM_AMRM_TOKEN_MASTER_KEY_ROLLING_INTERVAL_SECS = 86400L;
    public static final String RM_CONTAINER_TOKEN_MASTER_KEY_ROLLING_INTERVAL_SECS = "yarn.resourcemanager.container-tokens.master-key-rolling-interval-secs";
    public static final long DEFAULT_RM_CONTAINER_TOKEN_MASTER_KEY_ROLLING_INTERVAL_SECS = 86400L;
    public static final String RM_NMTOKEN_MASTER_KEY_ROLLING_INTERVAL_SECS = "yarn.resourcemanager.nm-tokens.master-key-rolling-interval-secs";
    public static final long DEFAULT_RM_NMTOKEN_MASTER_KEY_ROLLING_INTERVAL_SECS = 86400L;
    public static final String RM_NODEMANAGER_MINIMUM_VERSION = "yarn.resourcemanager.nodemanager.minimum.version";
    public static final String DEFAULT_RM_NODEMANAGER_MINIMUM_VERSION = "NONE";
    public static final String RM_NODEMANAGER_UNTRACKED_REMOVAL_TIMEOUT_MSEC = "yarn.resourcemanager.node-removal-untracked.timeout-ms";
    public static final int DEFAULT_RM_NODEMANAGER_UNTRACKED_REMOVAL_TIMEOUT_MSEC = 60000;
    public static final String RM_PROXY_USER_PREFIX = "yarn.resourcemanager.proxyuser.";
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static final String RM_RESOURCE_PROFILES_ENABLED = "yarn.resourcemanager.resource-profiles.enabled";
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static final boolean DEFAULT_RM_RESOURCE_PROFILES_ENABLED = false;
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static final String RM_RESOURCE_PROFILES_SOURCE_FILE = "yarn.resourcemanager.resource-profiles.source-file";
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static final String DEFAULT_RM_RESOURCE_PROFILES_SOURCE_FILE = "resource-profiles.json";
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static final String YARN_CLIENT_LOAD_RESOURCETYPES_FROM_SERVER = "yarn.client.load.resource-types.from-server";
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static final boolean DEFAULT_YARN_CLIENT_LOAD_RESOURCETYPES_FROM_SERVER = false;
    public static final String RM_NODE_GRACEFUL_DECOMMISSION_TIMEOUT = "yarn.resourcemanager.nodemanager-graceful-decommission-timeout-secs";
    public static final int DEFAULT_RM_NODE_GRACEFUL_DECOMMISSION_TIMEOUT = 3600;
    public static final String RM_DECOMMISSIONING_NODES_WATCHER_POLL_INTERVAL = "yarn.resourcemanager.decommissioning-nodes-watcher.poll-interval-secs";
    public static final int DEFAULT_RM_DECOMMISSIONING_NODES_WATCHER_POLL_INTERVAL = 20;
    public static final String NM_PREFIX = "yarn.nodemanager.";
    public static final String NM_OPPORTUNISTIC_CONTAINERS_MAX_QUEUE_LENGTH = "yarn.nodemanager.opportunistic-containers-max-queue-length";
    public static final int DEFAULT_NM_OPPORTUNISTIC_CONTAINERS_MAX_QUEUE_LENGTH = 0;
    public static final String DIST_SCHEDULING_ENABLED = "yarn.nodemanager.distributed-scheduling.enabled";
    public static final boolean DEFAULT_DIST_SCHEDULING_ENABLED = false;
    public static final String NM_ADMIN_USER_ENV = "yarn.nodemanager.admin-env";
    public static final String DEFAULT_NM_ADMIN_USER_ENV = "MALLOC_ARENA_MAX=$MALLOC_ARENA_MAX";
    public static final String NM_ENV_WHITELIST = "yarn.nodemanager.env-whitelist";
    public static final String DEFAULT_NM_ENV_WHITELIST;
    public static final String NM_ADDRESS = "yarn.nodemanager.address";
    public static final int DEFAULT_NM_PORT = 0;
    public static final String DEFAULT_NM_ADDRESS = "0.0.0.0:0";
    public static final String NM_BIND_HOST = "yarn.nodemanager.bind-host";
    public static final String NM_CONTAINER_EXECUTOR = "yarn.nodemanager.container-executor.class";
    public static final String NM_CONTAINER_STATE_TRANSITION_LISTENERS = "yarn.nodemanager.container-state-transition-listener.classes";
    public static final String NM_CONTAINER_EXECUTOR_SCHED_PRIORITY = "yarn.nodemanager.container-executor.os.sched.priority.adjustment";
    public static final int DEFAULT_NM_CONTAINER_EXECUTOR_SCHED_PRIORITY = 0;
    public static final String NM_CONTAINER_MGR_THREAD_COUNT = "yarn.nodemanager.container-manager.thread-count";
    public static final int DEFAULT_NM_CONTAINER_MGR_THREAD_COUNT = 20;
    public static final String NM_COLLECTOR_SERVICE_THREAD_COUNT = "yarn.nodemanager.collector-service.thread-count";
    public static final int DEFAULT_NM_COLLECTOR_SERVICE_THREAD_COUNT = 5;
    public static final String NM_DELETE_THREAD_COUNT = "yarn.nodemanager.delete.thread-count";
    public static final int DEFAULT_NM_DELETE_THREAD_COUNT = 4;
    public static final String NM_KEYTAB = "yarn.nodemanager.keytab";
    public static final String NM_LOCAL_DIRS = "yarn.nodemanager.local-dirs";
    public static final String DEFAULT_NM_LOCAL_DIRS = "/tmp/nm-local-dir";
    public static final String NM_LOCAL_CACHE_MAX_FILES_PER_DIRECTORY = "yarn.nodemanager.local-cache.max-files-per-directory";
    public static final int DEFAULT_NM_LOCAL_CACHE_MAX_FILES_PER_DIRECTORY = 8192;
    public static final String NM_LOCALIZER_ADDRESS = "yarn.nodemanager.localizer.address";
    public static final int DEFAULT_NM_LOCALIZER_PORT = 8040;
    public static final String DEFAULT_NM_LOCALIZER_ADDRESS = "0.0.0.0:8040";
    public static final String NM_COLLECTOR_SERVICE_ADDRESS = "yarn.nodemanager.collector-service.address";
    public static final int DEFAULT_NM_COLLECTOR_SERVICE_PORT = 8048;
    public static final String DEFAULT_NM_COLLECTOR_SERVICE_ADDRESS = "0.0.0.0:8048";
    public static final String NM_LOCALIZER_CACHE_CLEANUP_INTERVAL_MS = "yarn.nodemanager.localizer.cache.cleanup.interval-ms";
    public static final long DEFAULT_NM_LOCALIZER_CACHE_CLEANUP_INTERVAL_MS = 600000L;
    public static final String NM_LOCALIZER_CACHE_TARGET_SIZE_MB = "yarn.nodemanager.localizer.cache.target-size-mb";
    public static final long DEFAULT_NM_LOCALIZER_CACHE_TARGET_SIZE_MB = 10240L;
    public static final String NM_LOCALIZER_CLIENT_THREAD_COUNT = "yarn.nodemanager.localizer.client.thread-count";
    public static final int DEFAULT_NM_LOCALIZER_CLIENT_THREAD_COUNT = 5;
    public static final String NM_LOCALIZER_FETCH_THREAD_COUNT = "yarn.nodemanager.localizer.fetch.thread-count";
    public static final int DEFAULT_NM_LOCALIZER_FETCH_THREAD_COUNT = 4;
    public static final String NM_LOG_DIRS = "yarn.nodemanager.log-dirs";
    public static final String DEFAULT_NM_LOG_DIRS = "/tmp/logs";
    public static final String NM_LOG_AGGREGATION_THREAD_POOL_SIZE = "yarn.nodemanager.logaggregation.threadpool-size-max";
    public static final int DEFAULT_NM_LOG_AGGREGATION_THREAD_POOL_SIZE = 100;
    public static final String NM_DEFAULT_CONTAINER_EXECUTOR_PREFIX = "yarn.nodemanager.default-container-executor.";
    public static final String NM_DEFAULT_CONTAINER_EXECUTOR_LOG_DIRS_PERMISSIONS = "yarn.nodemanager.default-container-executor.log-dirs.permissions";
    public static final String NM_DEFAULT_CONTAINER_EXECUTOR_LOG_DIRS_PERMISSIONS_DEFAULT = "710";
    public static final String NM_RESOURCEMANAGER_MINIMUM_VERSION = "yarn.nodemanager.resourcemanager.minimum.version";
    public static final String DEFAULT_NM_RESOURCEMANAGER_MINIMUM_VERSION = "NONE";
    public static final String DISK_VALIDATOR = "yarn.nodemanager.disk-validator";
    public static final String DEFAULT_DISK_VALIDATOR = "basic";
    public static final String NM_CONTAINER_DIAGNOSTICS_MAXIMUM_SIZE = "yarn.nodemanager.container-diagnostics-maximum-size";
    public static final int DEFAULT_NM_CONTAINER_DIAGNOSTICS_MAXIMUM_SIZE = 10000;
    public static final String NM_CONTAINER_RETRY_MINIMUM_INTERVAL_MS = "yarn.nodemanager.container-retry-minimum-interval-ms";
    public static final int DEFAULT_NM_CONTAINER_RETRY_MINIMUM_INTERVAL_MS = 1000;
    public static final String NM_CONTAINER_QUEUING_USE_PAUSE_FOR_PREEMPTION = "yarn.nodemanager.opportunistic-containers-use-pause-for-preemption";
    public static final boolean DEFAULT_NM_CONTAINER_QUEUING_USE_PAUSE_FOR_PREEMPTION = false;
    public static final String RM_DELAYED_DELEGATION_TOKEN_REMOVAL_INTERVAL_MS = "yarn.resourcemanager.delayed.delegation-token.removal-interval-ms";
    public static final long DEFAULT_RM_DELAYED_DELEGATION_TOKEN_REMOVAL_INTERVAL_MS = 30000L;
    public static final String RM_DELEGATION_TOKEN_RENEWER_THREAD_COUNT = "yarn.resourcemanager.delegation-token-renewer.thread-count";
    public static final int DEFAULT_RM_DELEGATION_TOKEN_RENEWER_THREAD_COUNT = 50;
    public static final String RM_PROXY_USER_PRIVILEGES_ENABLED = "yarn.resourcemanager.proxy-user-privileges.enabled";
    public static final boolean DEFAULT_RM_PROXY_USER_PRIVILEGES_ENABLED = false;
    public static final String RM_NODE_IP_CACHE_EXPIRY_INTERVAL_SECS = "yarn.resourcemanager.node-ip-cache.expiry-interval-secs";
    public static final int DEFAULT_RM_NODE_IP_CACHE_EXPIRY_INTERVAL_SECS = -1;
    public static final String RM_MAX_LOG_AGGREGATION_DIAGNOSTICS_IN_MEMORY = "yarn.resourcemanager.max-log-aggregation-diagnostics-in-memory";
    public static final int DEFAULT_RM_MAX_LOG_AGGREGATION_DIAGNOSTICS_IN_MEMORY = 10;
    public static final String LOG_AGGREGATION_ENABLED = "yarn.log-aggregation-enable";
    public static final boolean DEFAULT_LOG_AGGREGATION_ENABLED = false;
    public static final String LOG_AGGREGATION_FILE_FORMATS = "yarn.log-aggregation.file-formats";
    public static final String LOG_AGGREGATION_FILE_CONTROLLER_FMT = "yarn.log-aggregation.file-controller.%s.class";
    public static final String LOG_AGGREGATION_REMOTE_APP_LOG_DIR_FMT = "yarn.log-aggregation.%s.remote-app-log-dir";
    public static final String LOG_AGGREGATION_REMOTE_APP_LOG_DIR_SUFFIX_FMT = "yarn.log-aggregation.%s.remote-app-log-dir-suffix";
    public static final String LOG_AGGREGATION_RETAIN_SECONDS = "yarn.log-aggregation.retain-seconds";
    public static final long DEFAULT_LOG_AGGREGATION_RETAIN_SECONDS = -1L;
    public static final String LOG_AGGREGATION_DEBUG_FILESIZE = "yarn.log-aggregation.debug.filesize";
    public static final long DEFAULT_LOG_AGGREGATION_DEBUG_FILESIZE = 0x6400000L;
    public static final String LOG_AGGREGATION_RETAIN_CHECK_INTERVAL_SECONDS = "yarn.log-aggregation.retain-check-interval-seconds";
    public static final long DEFAULT_LOG_AGGREGATION_RETAIN_CHECK_INTERVAL_SECONDS = -1L;
    public static final String LOG_AGGREGATION_STATUS_TIME_OUT_MS = "yarn.log-aggregation-status.time-out.ms";
    public static final long DEFAULT_LOG_AGGREGATION_STATUS_TIME_OUT_MS = 600000L;
    public static final String NM_LOG_RETAIN_SECONDS = "yarn.nodemanager.log.retain-seconds";
    public static final long DEFAULT_NM_LOG_RETAIN_SECONDS = 10800L;
    public static final String NM_LOG_AGGREGATION_ROLL_MONITORING_INTERVAL_SECONDS = "yarn.nodemanager.log-aggregation.roll-monitoring-interval-seconds";
    public static final long DEFAULT_NM_LOG_AGGREGATION_ROLL_MONITORING_INTERVAL_SECONDS = -1L;
    public static final String MIN_LOG_ROLLING_INTERVAL_SECONDS = "yarn.nodemanager.log-aggregation.roll-monitoring-interval-seconds.min";
    public static final long MIN_LOG_ROLLING_INTERVAL_SECONDS_DEFAULT = 3600L;
    public static final String NM_LOG_AGGREGATION_NUM_LOG_FILES_SIZE_PER_APP = "yarn.nodemanager.log-aggregation.num-log-files-per-app";
    public static final int DEFAULT_NM_LOG_AGGREGATION_NUM_LOG_FILES_SIZE_PER_APP = 30;
    public static final String NM_LOG_DELETION_THREADS_COUNT = "yarn.nodemanager.log.deletion-threads-count";
    public static final int DEFAULT_NM_LOG_DELETE_THREAD_COUNT = 4;
    public static final String NM_REMOTE_APP_LOG_DIR = "yarn.nodemanager.remote-app-log-dir";
    public static final String DEFAULT_NM_REMOTE_APP_LOG_DIR = "/tmp/logs";
    public static final String NM_REMOTE_APP_LOG_DIR_SUFFIX = "yarn.nodemanager.remote-app-log-dir-suffix";
    public static final String DEFAULT_NM_REMOTE_APP_LOG_DIR_SUFFIX = "logs";
    public static final String YARN_LOG_SERVER_URL = "yarn.log.server.url";
    public static final String YARN_LOG_SERVER_WEBSERVICE_URL = "yarn.log.server.web-service.url";
    public static final String YARN_TRACKING_URL_GENERATOR = "yarn.tracking.url.generator";
    public static final String NM_PMEM_MB = "yarn.nodemanager.resource.memory-mb";
    public static final int DEFAULT_NM_PMEM_MB = 8192;
    public static final String NM_SYSTEM_RESERVED_PMEM_MB = "yarn.nodemanager.resource.system-reserved-memory-mb";
    public static final String NM_PMEM_CHECK_ENABLED = "yarn.nodemanager.pmem-check-enabled";
    public static final boolean DEFAULT_NM_PMEM_CHECK_ENABLED = true;
    public static final String NM_VMEM_CHECK_ENABLED = "yarn.nodemanager.vmem-check-enabled";
    public static final boolean DEFAULT_NM_VMEM_CHECK_ENABLED = true;
    public static final String NM_VMEM_PMEM_RATIO = "yarn.nodemanager.vmem-pmem-ratio";
    public static final float DEFAULT_NM_VMEM_PMEM_RATIO = 2.1f;
    public static final String NM_VCORES = "yarn.nodemanager.resource.cpu-vcores";
    public static final int DEFAULT_NM_VCORES = 8;
    public static final String NM_COUNT_LOGICAL_PROCESSORS_AS_CORES = "yarn.nodemanager.resource.count-logical-processors-as-cores";
    public static final boolean DEFAULT_NM_COUNT_LOGICAL_PROCESSORS_AS_CORES = false;
    public static final String NM_PCORES_VCORES_MULTIPLIER = "yarn.nodemanager.resource.pcores-vcores-multiplier";
    public static final float DEFAULT_NM_PCORES_VCORES_MULTIPLIER = 1.0f;
    public static final String NM_RESOURCE_PERCENTAGE_PHYSICAL_CPU_LIMIT = "yarn.nodemanager.resource.percentage-physical-cpu-limit";
    public static final int DEFAULT_NM_RESOURCE_PERCENTAGE_PHYSICAL_CPU_LIMIT = 100;
    public static final String NM_ENABLE_HARDWARE_CAPABILITY_DETECTION = "yarn.nodemanager.resource.detect-hardware-capabilities";
    public static final boolean DEFAULT_NM_ENABLE_HARDWARE_CAPABILITY_DETECTION = false;
    @InterfaceAudience.Private
    public static final String NM_MEMORY_RESOURCE_PREFIX = "yarn.nodemanager.resource.memory.";
    public static final String NM_MEMORY_RESOURCE_ENABLED = "yarn.nodemanager.resource.memory.enabled";
    public static final boolean DEFAULT_NM_MEMORY_RESOURCE_ENABLED = false;
    public static final String NM_MEMORY_RESOURCE_ENFORCED = "yarn.nodemanager.resource.memory.enforced";
    public static final boolean DEFAULT_NM_MEMORY_RESOURCE_ENFORCED = true;
    public static final String NM_MEMORY_RESOURCE_CGROUPS_SWAPPINESS = "yarn.nodemanager.resource.memory.cgroups.swappiness";
    public static final int DEFAULT_NM_MEMORY_RESOURCE_CGROUPS_SWAPPINESS = 0;
    public static final String NM_MEMORY_RESOURCE_CGROUPS_SOFT_LIMIT_PERCENTAGE = "yarn.nodemanager.resource.memory.cgroups.soft-limit-percentage";
    public static final float DEFAULT_NM_MEMORY_RESOURCE_CGROUPS_SOFT_LIMIT_PERCENTAGE = 90.0f;
    @InterfaceAudience.Private
    public static final String NM_CPU_RESOURCE_PREFIX = "yarn.nodemanager.resource.cpu.";
    @InterfaceAudience.Private
    public static final String NM_CPU_RESOURCE_ENABLED = "yarn.nodemanager.resource.cpu.enabled";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_NM_CPU_RESOURCE_ENABLED = false;
    @InterfaceAudience.Private
    public static final String NM_DISK_RESOURCE_PREFIX = "yarn.nodemanager.resource.disk.";
    @InterfaceAudience.Private
    public static final String NM_DISK_RESOURCE_ENABLED = "yarn.nodemanager.resource.disk.enabled";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_NM_DISK_RESOURCE_ENABLED = false;
    public static final String NM_NETWORK_RESOURCE_PREFIX = "yarn.nodemanager.resource.network.";
    @InterfaceAudience.Private
    public static final String NM_NETWORK_RESOURCE_ENABLED = "yarn.nodemanager.resource.network.enabled";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_NM_NETWORK_RESOURCE_ENABLED = false;
    @InterfaceAudience.Private
    public static final String NM_NETWORK_RESOURCE_INTERFACE = "yarn.nodemanager.resource.network.interface";
    @InterfaceAudience.Private
    public static final String DEFAULT_NM_NETWORK_RESOURCE_INTERFACE = "eth0";
    @InterfaceAudience.Private
    public static final String NM_NETWORK_RESOURCE_OUTBOUND_BANDWIDTH_MBIT = "yarn.nodemanager.resource.network.outbound-bandwidth-mbit";
    @InterfaceAudience.Private
    public static final int DEFAULT_NM_NETWORK_RESOURCE_OUTBOUND_BANDWIDTH_MBIT = 1000;
    @InterfaceAudience.Private
    public static final String NM_NETWORK_RESOURCE_OUTBOUND_BANDWIDTH_YARN_MBIT = "yarn.nodemanager.resource.network.outbound-bandwidth-yarn-mbit";
    @InterfaceAudience.Private
    public static final String NM_RESOURCE_PLUGINS = "yarn.nodemanager.resource-plugins";
    @InterfaceAudience.Private
    public static final String NM_GPU_RESOURCE_PREFIX = "yarn.nodemanager.resource-plugins.gpu.";
    @InterfaceAudience.Private
    public static final String NM_GPU_ALLOWED_DEVICES = "yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices";
    @InterfaceAudience.Private
    public static final String AUTOMATICALLY_DISCOVER_GPU_DEVICES = "auto";
    @InterfaceAudience.Private
    public static final String NM_GPU_PATH_TO_EXEC = "yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables";
    @InterfaceAudience.Private
    public static final String NM_GPU_DOCKER_PLUGIN_IMPL = "yarn.nodemanager.resource-plugins.gpu.docker-plugin";
    @InterfaceAudience.Private
    public static final String NVIDIA_DOCKER_V1 = "nvidia-docker-v1";
    @InterfaceAudience.Private
    public static final String NVIDIA_DOCKER_V2 = "nvidia-docker-v2";
    @InterfaceAudience.Private
    public static final String DEFAULT_NM_GPU_DOCKER_PLUGIN_IMPL = "nvidia-docker-v1";
    @InterfaceAudience.Private
    public static final String NVIDIA_DOCKER_PLUGIN_V1_ENDPOINT = "yarn.nodemanager.resource-plugins.gpu.docker-plugin.nvidia-docker-v1.endpoint";
    @InterfaceAudience.Private
    public static final String DEFAULT_NVIDIA_DOCKER_PLUGIN_V1_ENDPOINT = "http://localhost:3476/v1.0/docker/cli";
    @InterfaceAudience.Private
    public static final String NM_FPGA_RESOURCE_PREFIX = "yarn.nodemanager.resource-plugins.fpga.";
    @InterfaceAudience.Private
    public static final String NM_FPGA_ALLOWED_DEVICES = "yarn.nodemanager.resource-plugins.fpga.allowed-fpga-devices";
    @InterfaceAudience.Private
    public static final String NM_FPGA_PATH_TO_EXEC = "yarn.nodemanager.resource-plugins.fpga.path-to-discovery-executables";
    @InterfaceAudience.Private
    public static final String NM_FPGA_VENDOR_PLUGIN = "yarn.nodemanager.resource-plugins.fpga.vendor-plugin.class";
    @InterfaceAudience.Private
    public static final String DEFAULT_NM_FPGA_VENDOR_PLUGIN = "org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.IntelFpgaOpenclPlugin";
    public static final String NM_NETWORK_TAG_PREFIX = "yarn.nodemanager.network-tagging";
    public static final String NM_NETWORK_TAG_HANDLER_ENABLED = "yarn.nodemanager.network-tagging-handler.enabled";
    public static final boolean DEFAULT_NM_NETWORK_TAG_HANDLER_ENABLED = false;
    public static final String NM_NETWORK_TAG_MAPPING_MANAGER = "yarn.nodemanager.network-tagging.mapping-mamager.class";
    public static final String NM_NETWORK_TAG_MAPPING_FILE_PATH = "yarn.nodemanager.network-tagging.mapping-file.path";
    public static final String DEFAULT_NM_NETWORK_RESOURCE_TAG_MAPPING_FILE_PATH = "";
    public static final String NM_WEBAPP_ADDRESS = "yarn.nodemanager.webapp.address";
    public static final int DEFAULT_NM_WEBAPP_PORT = 8042;
    public static final String DEFAULT_NM_WEBAPP_ADDRESS = "0.0.0.0:8042";
    public static final String NM_WEBAPP_HTTPS_ADDRESS = "yarn.nodemanager.webapp.https.address";
    public static final int DEFAULT_NM_WEBAPP_HTTPS_PORT = 8044;
    public static final String DEFAULT_NM_WEBAPP_HTTPS_ADDRESS = "0.0.0.0:8044";
    public static final String NM_WEBAPP_ENABLE_CORS_FILTER = "yarn.nodemanager.webapp.cross-origin.enabled";
    public static final boolean DEFAULT_NM_WEBAPP_ENABLE_CORS_FILTER = false;
    public static final String NM_RESOURCE_MON_INTERVAL_MS = "yarn.nodemanager.resource-monitor.interval-ms";
    public static final int DEFAULT_NM_RESOURCE_MON_INTERVAL_MS = 3000;
    public static final String NM_CONTAINER_MONITOR_ENABLED = "yarn.nodemanager.container-monitor.enabled";
    public static final boolean DEFAULT_NM_CONTAINER_MONITOR_ENABLED = true;
    public static final String NM_CONTAINER_MON_INTERVAL_MS = "yarn.nodemanager.container-monitor.interval-ms";
    @Deprecated
    public static final int DEFAULT_NM_CONTAINER_MON_INTERVAL_MS = 3000;
    public static final String NM_MON_RESOURCE_CALCULATOR = "yarn.nodemanager.resource-calculator.class";
    public static final String NM_CONTAINER_MON_RESOURCE_CALCULATOR = "yarn.nodemanager.container-monitor.resource-calculator.class";
    public static final String NM_CONTAINER_MON_PROCESS_TREE = "yarn.nodemanager.container-monitor.process-tree.class";
    public static final String PROCFS_USE_SMAPS_BASED_RSS_ENABLED = "yarn.nodemanager.container-monitor.procfs-tree.smaps-based-rss.enabled";
    public static final boolean DEFAULT_PROCFS_USE_SMAPS_BASED_RSS_ENABLED = false;
    @InterfaceAudience.Private
    public static final String NM_CONTAINER_METRICS_ENABLE = "yarn.nodemanager.container-metrics.enable";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_NM_CONTAINER_METRICS_ENABLE = true;
    @InterfaceAudience.Private
    public static final String NM_CONTAINER_METRICS_PERIOD_MS = "yarn.nodemanager.container-metrics.period-ms";
    @InterfaceAudience.Private
    public static final int DEFAULT_NM_CONTAINER_METRICS_PERIOD_MS = -1;
    @InterfaceAudience.Private
    public static final String NM_CONTAINER_METRICS_UNREGISTER_DELAY_MS = "yarn.nodemanager.container-metrics.unregister-delay-ms";
    @InterfaceAudience.Private
    public static final int DEFAULT_NM_CONTAINER_METRICS_UNREGISTER_DELAY_MS = 10000;
    private static final String NM_DISK_HEALTH_CHECK_PREFIX = "yarn.nodemanager.disk-health-checker.";
    public static final String NM_DISK_HEALTH_CHECK_ENABLE = "yarn.nodemanager.disk-health-checker.enable";
    public static final String NM_DISK_HEALTH_CHECK_INTERVAL_MS = "yarn.nodemanager.disk-health-checker.interval-ms";
    public static final long DEFAULT_NM_DISK_HEALTH_CHECK_INTERVAL_MS = 120000L;
    public static final String NM_MIN_HEALTHY_DISKS_FRACTION = "yarn.nodemanager.disk-health-checker.min-healthy-disks";
    public static final float DEFAULT_NM_MIN_HEALTHY_DISKS_FRACTION = 0.25f;
    public static final String NM_MAX_PER_DISK_UTILIZATION_PERCENTAGE = "yarn.nodemanager.disk-health-checker.max-disk-utilization-per-disk-percentage";
    public static final float DEFAULT_NM_MAX_PER_DISK_UTILIZATION_PERCENTAGE = 90.0f;
    public static final String NM_WM_LOW_PER_DISK_UTILIZATION_PERCENTAGE = "yarn.nodemanager.disk-health-checker.disk-utilization-watermark-low-per-disk-percentage";
    public static final String NM_MIN_PER_DISK_FREE_SPACE_MB = "yarn.nodemanager.disk-health-checker.min-free-space-per-disk-mb";
    public static final long DEFAULT_NM_MIN_PER_DISK_FREE_SPACE_MB = 0L;
    public static final String NM_HEALTH_CHECK_INTERVAL_MS = "yarn.nodemanager.health-checker.interval-ms";
    public static final long DEFAULT_NM_HEALTH_CHECK_INTERVAL_MS = 600000L;
    public static final String NM_HEALTH_CHECK_SCRIPT_TIMEOUT_MS = "yarn.nodemanager.health-checker.script.timeout-ms";
    public static final long DEFAULT_NM_HEALTH_CHECK_SCRIPT_TIMEOUT_MS = 1200000L;
    public static final String NM_HEALTH_CHECK_SCRIPT_PATH = "yarn.nodemanager.health-checker.script.path";
    public static final String NM_HEALTH_CHECK_SCRIPT_OPTS = "yarn.nodemanager.health-checker.script.opts";
    public static final String NM_CONTAINER_LOCALIZER_JAVA_OPTS_KEY = "yarn.nodemanager.container-localizer.java.opts";
    public static final String NM_CONTAINER_LOCALIZER_JAVA_OPTS_DEFAULT = "-Xmx256m";
    public static final String NM_CONTAINER_LOCALIZER_LOG_LEVEL = "yarn.nodemanager.container-localizer.log.level";
    public static final String NM_CONTAINER_LOCALIZER_LOG_LEVEL_DEFAULT = "INFO";
    public static final String LINUX_CONTAINER_RUNTIME_PREFIX = "yarn.nodemanager.runtime.linux.";
    public static final String LINUX_CONTAINER_RUNTIME_ALLOWED_RUNTIMES = "yarn.nodemanager.runtime.linux.allowed-runtimes";
    public static final String LINUX_CONTAINER_RUNTIME_CLASS_FMT = "yarn.nodemanager.runtime.linux.%s.class";
    public static final String[] DEFAULT_LINUX_CONTAINER_RUNTIME_ALLOWED_RUNTIMES;
    public static final String DOCKER_CONTAINER_RUNTIME_PREFIX = "yarn.nodemanager.runtime.linux.docker.";
    public static final String NM_DOCKER_CONTAINER_CAPABILITIES = "yarn.nodemanager.runtime.linux.docker.capabilities";
    public static final String[] DEFAULT_NM_DOCKER_CONTAINER_CAPABILITIES;
    public static final String NM_DOCKER_ALLOW_PRIVILEGED_CONTAINERS = "yarn.nodemanager.runtime.linux.docker.privileged-containers.allowed";
    public static final boolean DEFAULT_NM_DOCKER_ALLOW_PRIVILEGED_CONTAINERS = false;
    public static final String NM_DOCKER_ENABLE_USER_REMAPPING = "yarn.nodemanager.runtime.linux.docker.enable-userremapping.allowed";
    public static final boolean DEFAULT_NM_DOCKER_ENABLE_USER_REMAPPING = true;
    public static final String NM_DOCKER_USER_REMAPPING_UID_THRESHOLD = "yarn.nodemanager.runtime.linux.docker.userremapping-uid-threshold";
    public static final int DEFAULT_NM_DOCKER_USER_REMAPPING_UID_THRESHOLD = 1;
    public static final String NM_DOCKER_USER_REMAPPING_GID_THRESHOLD = "yarn.nodemanager.runtime.linux.docker.userremapping-gid-threshold";
    public static final int DEFAULT_NM_DOCKER_USER_REMAPPING_GID_THRESHOLD = 1;
    public static final String NM_DOCKER_PRIVILEGED_CONTAINERS_ACL = "yarn.nodemanager.runtime.linux.docker.privileged-containers.acl";
    public static final String DEFAULT_NM_DOCKER_PRIVILEGED_CONTAINERS_ACL = "";
    public static final String NM_DOCKER_ALLOWED_CONTAINER_NETWORKS = "yarn.nodemanager.runtime.linux.docker.allowed-container-networks";
    public static final String[] DEFAULT_NM_DOCKER_ALLOWED_CONTAINER_NETWORKS;
    public static final String NM_DOCKER_DEFAULT_CONTAINER_NETWORK = "yarn.nodemanager.runtime.linux.docker.default-container-network";
    public static final String DEFAULT_NM_DOCKER_DEFAULT_CONTAINER_NETWORK = "host";
    public static final String NM_DOCKER_ALLOW_HOST_PID_NAMESPACE = "yarn.nodemanager.runtime.linux.docker.host-pid-namespace.allowed";
    public static final boolean DEFAULT_NM_DOCKER_ALLOW_HOST_PID_NAMESPACE = false;
    public static final String NM_DOCKER_ALLOW_DELAYED_REMOVAL = "yarn.nodemanager.runtime.linux.docker.delayed-removal.allowed";
    public static final boolean DEFAULT_NM_DOCKER_ALLOW_DELAYED_REMOVAL = false;
    public static final String NM_DOCKER_DEFAULT_RO_MOUNTS = "yarn.nodemanager.runtime.linux.docker.default-ro-mounts";
    public static final String NM_DOCKER_DEFAULT_RW_MOUNTS = "yarn.nodemanager.runtime.linux.docker.default-rw-mounts";
    public static final String NM_DOCKER_DEFAULT_TMPFS_MOUNTS = "yarn.nodemanager.runtime.linux.docker.default-tmpfs-mounts";
    public static final String YARN_CONTAINER_SANDBOX = "yarn.nodemanager.runtime.linux.sandbox-mode";
    public static final String DEFAULT_YARN_CONTAINER_SANDBOX = "disabled";
    public static final String YARN_CONTAINER_SANDBOX_FILE_PERMISSIONS = "yarn.nodemanager.runtime.linux.sandbox-mode.local-dirs.permissions";
    public static final String DEFAULT_YARN_CONTAINER_SANDBOX_FILE_PERMISSIONS = "read";
    public static final String YARN_CONTAINER_SANDBOX_POLICY = "yarn.nodemanager.runtime.linux.sandbox-mode.policy";
    public static final String YARN_CONTAINER_SANDBOX_POLICY_GROUP_PREFIX = "yarn.nodemanager.runtime.linux.sandbox-mode.policy.group.";
    public static final String YARN_CONTAINER_SANDBOX_WHITELIST_GROUP = "yarn.nodemanager.runtime.linux.sandbox-mode.whitelist-group";
    public static final String NM_LINUX_CONTAINER_EXECUTOR_PATH = "yarn.nodemanager.linux-container-executor.path";
    public static final String NM_LINUX_CONTAINER_GROUP = "yarn.nodemanager.linux-container-executor.group";
    public static final String NM_NONSECURE_MODE_LIMIT_USERS = "yarn.nodemanager.linux-container-executor.nonsecure-mode.limit-users";
    public static final boolean DEFAULT_NM_NONSECURE_MODE_LIMIT_USERS = true;
    public static final String NM_NONSECURE_MODE_LOCAL_USER_KEY = "yarn.nodemanager.linux-container-executor.nonsecure-mode.local-user";
    public static final String DEFAULT_NM_NONSECURE_MODE_LOCAL_USER = "nobody";
    public static final String NM_NONSECURE_MODE_USER_PATTERN_KEY = "yarn.nodemanager.linux-container-executor.nonsecure-mode.user-pattern";
    public static final String DEFAULT_NM_NONSECURE_MODE_USER_PATTERN = "^[_.A-Za-z0-9][-@_.A-Za-z0-9]{0,255}?[$]?$";
    public static final String NM_LINUX_CONTAINER_RESOURCES_HANDLER = "yarn.nodemanager.linux-container-executor.resources-handler.class";
    public static final String NM_LINUX_CONTAINER_CGROUPS_HIERARCHY = "yarn.nodemanager.linux-container-executor.cgroups.hierarchy";
    public static final String NM_LINUX_CONTAINER_CGROUPS_MOUNT = "yarn.nodemanager.linux-container-executor.cgroups.mount";
    public static final String NM_LINUX_CONTAINER_CGROUPS_MOUNT_PATH = "yarn.nodemanager.linux-container-executor.cgroups.mount-path";
    public static final String NM_LINUX_CONTAINER_CGROUPS_STRICT_RESOURCE_USAGE = "yarn.nodemanager.linux-container-executor.cgroups.strict-resource-usage";
    public static final boolean DEFAULT_NM_LINUX_CONTAINER_CGROUPS_STRICT_RESOURCE_USAGE = false;
    public static final String RM_APPLICATION_MONITOR_INTERVAL_MS = "yarn.resourcemanager.application-timeouts.monitor.interval-ms";
    public static final long DEFAULT_RM_APPLICATION_MONITOR_INTERVAL_MS = 3000L;
    public static final String NM_LINUX_CONTAINER_CGROUPS_DELETE_TIMEOUT = "yarn.nodemanager.linux-container-executor.cgroups.delete-timeout-ms";
    public static final long DEFAULT_NM_LINUX_CONTAINER_CGROUPS_DELETE_TIMEOUT = 1000L;
    public static final String NM_LINUX_CONTAINER_CGROUPS_DELETE_DELAY = "yarn.nodemanager.linux-container-executor.cgroups.delete-delay-ms";
    public static final long DEFAULT_NM_LINUX_CONTAINER_CGROUPS_DELETE_DELAY = 20L;
    public static final String NM_WINDOWS_CONTAINER_MEMORY_LIMIT_ENABLED = "yarn.nodemanager.windows-container.memory-limit.enabled";
    public static final boolean DEFAULT_NM_WINDOWS_CONTAINER_MEMORY_LIMIT_ENABLED = false;
    public static final String NM_WINDOWS_CONTAINER_CPU_LIMIT_ENABLED = "yarn.nodemanager.windows-container.cpu-limit.enabled";
    public static final boolean DEFAULT_NM_WINDOWS_CONTAINER_CPU_LIMIT_ENABLED = false;
    public static final String NM_WINDOWS_SECURE_CONTAINER_GROUP = "yarn.nodemanager.windows-secure-container-executor.group";
    public static final String NM_LOG_AGG_COMPRESSION_TYPE = "yarn.nodemanager.log-aggregation.compression-type";
    public static final String DEFAULT_NM_LOG_AGG_COMPRESSION_TYPE = "none";
    public static final String NM_PRINCIPAL = "yarn.nodemanager.principal";
    public static final String NM_AUX_SERVICES = "yarn.nodemanager.aux-services";
    public static final String NM_AUX_SERVICE_FMT = "yarn.nodemanager.aux-services.%s.class";
    public static final String NM_AUX_SERVICES_CLASSPATH = "yarn.nodemanager.aux-services.%s.classpath";
    public static final String NM_AUX_SERVICE_REMOTE_CLASSPATH = "yarn.nodemanager.aux-services.%s.remote-classpath";
    public static final String NM_AUX_SERVICES_SYSTEM_CLASSES = "yarn.nodemanager.aux-services.%s.system-classes";
    public static final String NM_USER_HOME_DIR = "yarn.nodemanager.user-home-dir";
    public static final String NM_CONTAINER_STDERR_PATTERN = "yarn.nodemanager.container.stderr.pattern";
    public static final String DEFAULT_NM_CONTAINER_STDERR_PATTERN = "{*stderr*,*STDERR*}";
    public static final String NM_CONTAINER_STDERR_BYTES = "yarn.nodemanager.container.stderr.tail.bytes";
    public static final long DEFAULT_NM_CONTAINER_STDERR_BYTES = 4096L;
    public static final String NM_WEBAPP_SPNEGO_USER_NAME_KEY = "yarn.nodemanager.webapp.spnego-principal";
    public static final String NM_WEBAPP_SPNEGO_KEYTAB_FILE_KEY = "yarn.nodemanager.webapp.spnego-keytab-file";
    public static final String DEFAULT_NM_USER_HOME_DIR = "/home/";
    public static final String NM_RECOVERY_PREFIX = "yarn.nodemanager.recovery.";
    public static final String NM_RECOVERY_ENABLED = "yarn.nodemanager.recovery.enabled";
    public static final boolean DEFAULT_NM_RECOVERY_ENABLED = false;
    public static final String NM_RECOVERY_DIR = "yarn.nodemanager.recovery.dir";
    public static final String NM_RECOVERY_COMPACTION_INTERVAL_SECS = "yarn.nodemanager.recovery.compaction-interval-secs";
    public static final int DEFAULT_NM_RECOVERY_COMPACTION_INTERVAL_SECS = 3600;
    public static final String NM_RECOVERY_SUPERVISED = "yarn.nodemanager.recovery.supervised";
    public static final boolean DEFAULT_NM_RECOVERY_SUPERVISED = false;
    public static final String NM_LOG_AGG_POLICY_CLASS = "yarn.nodemanager.log-aggregation.policy.class";
    public static final String NM_LOG_AGG_POLICY_CLASS_PARAMETERS = "yarn.nodemanager.log-aggregation.policy.parameters";
    public static final String PROXY_PREFIX = "yarn.web-proxy.";
    public static final String PROXY_PRINCIPAL = "yarn.web-proxy.principal";
    public static final String PROXY_KEYTAB = "yarn.web-proxy.keytab";
    public static final String PROXY_ADDRESS = "yarn.web-proxy.address";
    public static final int DEFAULT_PROXY_PORT = 9099;
    public static final String DEFAULT_PROXY_ADDRESS = "0.0.0.0:9099";
    public static final String YARN_SECURITY_SERVICE_AUTHORIZATION_RESOURCETRACKER_PROTOCOL = "security.resourcetracker.protocol.acl";
    public static final String YARN_SECURITY_SERVICE_AUTHORIZATION_APPLICATIONCLIENT_PROTOCOL = "security.applicationclient.protocol.acl";
    public static final String YARN_SECURITY_SERVICE_AUTHORIZATION_RESOURCEMANAGER_ADMINISTRATION_PROTOCOL = "security.resourcemanager-administration.protocol.acl";
    public static final String YARN_SECURITY_SERVICE_AUTHORIZATION_APPLICATIONMASTER_PROTOCOL = "security.applicationmaster.protocol.acl";
    public static final String YARN_SECURITY_SERVICE_AUTHORIZATION_DISTRIBUTEDSCHEDULING_PROTOCOL = "security.distributedscheduling.protocol.acl";
    public static final String YARN_SECURITY_SERVICE_AUTHORIZATION_CONTAINER_MANAGEMENT_PROTOCOL = "security.containermanagement.protocol.acl";
    public static final String YARN_SECURITY_SERVICE_AUTHORIZATION_RESOURCE_LOCALIZER = "security.resourcelocalizer.protocol.acl";
    public static final String YARN_SECURITY_SERVICE_AUTHORIZATION_APPLICATIONHISTORY_PROTOCOL = "security.applicationhistory.protocol.acl";
    public static final String YARN_SECURITY_SERVICE_AUTHORIZATION_COLLECTOR_NODEMANAGER_PROTOCOL = "security.collector-nodemanager.protocol.acl";
    public static final String YARN_SECURITY_SERVICE_AUTHORIZATION_APPLICATIONMASTER_NODEMANAGER_PROTOCOL = "security.applicationmaster-nodemanager.applicationmaster.protocol.acl";
    public static final String NM_SLEEP_DELAY_BEFORE_SIGKILL_MS = "yarn.nodemanager.sleep-delay-before-sigkill.ms";
    public static final long DEFAULT_NM_SLEEP_DELAY_BEFORE_SIGKILL_MS = 250L;
    public static final String NM_PROCESS_KILL_WAIT_MS = "yarn.nodemanager.process-kill-wait.ms";
    public static final long DEFAULT_NM_PROCESS_KILL_WAIT_MS = 5000L;
    public static final String RESOURCEMANAGER_CONNECT_MAX_WAIT_MS = "yarn.resourcemanager.connect.max-wait.ms";
    public static final long DEFAULT_RESOURCEMANAGER_CONNECT_MAX_WAIT_MS = 900000L;
    public static final String RESOURCEMANAGER_CONNECT_RETRY_INTERVAL_MS = "yarn.resourcemanager.connect.retry-interval.ms";
    public static final long DEFAULT_RESOURCEMANAGER_CONNECT_RETRY_INTERVAL_MS = 30000L;
    public static final String DISPATCHER_DRAIN_EVENTS_TIMEOUT = "yarn.dispatcher.drain-events.timeout";
    public static final long DEFAULT_DISPATCHER_DRAIN_EVENTS_TIMEOUT = 300000L;
    public static final String YARN_APPLICATION_CLASSPATH = "yarn.application.classpath";
    public static final String AMRM_PROXY_ENABLED = "yarn.nodemanager.amrmproxy.enabled";
    public static final boolean DEFAULT_AMRM_PROXY_ENABLED = false;
    public static final String AMRM_PROXY_ADDRESS = "yarn.nodemanager.amrmproxy.address";
    public static final int DEFAULT_AMRM_PROXY_PORT = 8049;
    public static final String DEFAULT_AMRM_PROXY_ADDRESS = "0.0.0.0:8049";
    public static final String AMRM_PROXY_CLIENT_THREAD_COUNT = "yarn.nodemanager.amrmproxy.client.thread-count";
    public static final int DEFAULT_AMRM_PROXY_CLIENT_THREAD_COUNT = 3;
    public static final String AMRM_PROXY_INTERCEPTOR_CLASS_PIPELINE = "yarn.nodemanager.amrmproxy.interceptor-class.pipeline";
    public static final String DEFAULT_AMRM_PROXY_INTERCEPTOR_CLASS_PIPELINE = "org.apache.hadoop.yarn.server.nodemanager.amrmproxy.DefaultRequestInterceptor";
    public static final String AMRM_PROXY_HA_ENABLED = "yarn.nodemanager.amrmproxy.ha.enable";
    public static final boolean DEFAULT_AMRM_PROXY_HA_ENABLED = false;
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static final String[] DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH;
    public static final String[] DEFAULT_YARN_APPLICATION_CLASSPATH;
    public static final String DEFAULT_CONTAINER_TEMP_DIR = "./tmp";
    public static final String IS_MINI_YARN_CLUSTER = "yarn.is.minicluster";
    public static final String YARN_MC_PREFIX = "yarn.minicluster.";
    public static final String YARN_MINICLUSTER_FIXED_PORTS = "yarn.minicluster.fixed.ports";
    public static final boolean DEFAULT_YARN_MINICLUSTER_FIXED_PORTS = false;
    public static final String YARN_MINICLUSTER_USE_RPC = "yarn.minicluster.use-rpc";
    public static final boolean DEFAULT_YARN_MINICLUSTER_USE_RPC = false;
    public static final String YARN_MINICLUSTER_CONTROL_RESOURCE_MONITORING = "yarn.minicluster.control-resource-monitoring";
    public static final boolean DEFAULT_YARN_MINICLUSTER_CONTROL_RESOURCE_MONITORING = false;
    public static final String YARN_MINICLUSTER_NM_PMEM_MB = "yarn.minicluster.yarn.nodemanager.resource.memory-mb";
    public static final int DEFAULT_YARN_MINICLUSTER_NM_PMEM_MB = 4096;
    public static final String YARN_APP_CONTAINER_LOG_DIR = "yarn.app.container.log.dir";
    public static final String YARN_APP_CONTAINER_LOG_SIZE = "yarn.app.container.log.filesize";
    public static final String YARN_APP_CONTAINER_LOG_BACKUPS = "yarn.app.container.log.backups";
    public static final String TIMELINE_SERVICE_PREFIX = "yarn.timeline-service.";
    public static final String TIMELINE_SERVICE_VERSION = "yarn.timeline-service.version";
    public static final float DEFAULT_TIMELINE_SERVICE_VERSION = 1.0f;
    public static final String TIMELINE_SERVICE_VERSIONS = "yarn.timeline-service.versions";
    public static final String TIMELINE_SERVICE_UI_NAMES = "yarn.timeline-service.ui-names";
    public static final String TIMELINE_SERVICE_UI_WEB_PATH_PREFIX = "yarn.timeline-service.ui-web-path.";
    public static final String TIMELINE_SERVICE_CLIENT_PREFIX = "yarn.timeline-service.client.";
    public static final String TIMELINE_SERVICE_UI_ON_DISK_PATH_PREFIX = "yarn.timeline-service.ui-on-disk-path.";
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_PREFIX = "yarn.timeline-service.entity-group-fs-store.";
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_CACHE_STORE = "yarn.timeline-service.entity-group-fs-store.cache-store-class";
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_ACTIVE_DIR = "yarn.timeline-service.entity-group-fs-store.active-dir";
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_ACTIVE_DIR_DEFAULT = "/tmp/entity-file-history/active";
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_DONE_DIR = "yarn.timeline-service.entity-group-fs-store.done-dir";
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_DONE_DIR_DEFAULT = "/tmp/entity-file-history/done";
    public static final String TIMELINE_SERVICE_ENTITY_GROUP_PLUGIN_CLASSES = "yarn.timeline-service.entity-group-fs-store.group-id-plugin-classes";
    public static final String TIMELINE_SERVICE_ENTITY_GROUP_PLUGIN_CLASSPATH = "yarn.timeline-service.entity-group-fs-store.group-id-plugin-classpath";
    public static final String TIMELINE_SERVICE_ENTITY_GROUP_PLUGIN_SYSTEM_CLASSES = "yarn.timeline-service.entity-group-fs-store.group-id-plugin-system-classes";
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_SUMMARY_STORE = "yarn.timeline-service.entity-group-fs-store.summary-store";
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_SUMMARY_ENTITY_TYPES = "yarn.timeline-service.entity-group-fs-store.summary-entity-types";
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_SCAN_INTERVAL_SECONDS = "yarn.timeline-service.entity-group-fs-store.scan-interval-seconds";
    public static final long TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_SCAN_INTERVAL_SECONDS_DEFAULT = 60L;
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_THREADS = "yarn.timeline-service.entity-group-fs-store.threads";
    public static final int TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_THREADS_DEFAULT = 16;
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_APP_CACHE_SIZE = "yarn.timeline-service.entity-group-fs-store.app-cache-size";
    public static final int TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_APP_CACHE_SIZE_DEFAULT = 10;
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_CLEANER_INTERVAL_SECONDS = "yarn.timeline-service.entity-group-fs-store.cleaner-interval-seconds";
    public static final int TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_CLEANER_INTERVAL_SECONDS_DEFAULT = 3600;
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETAIN_SECONDS = "yarn.timeline-service.entity-group-fs-store.retain-seconds";
    public static final int TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETAIN_SECONDS_DEFAULT = 604800;
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_UNKNOWN_ACTIVE_SECONDS = "yarn.timeline-service.entity-group-fs-store.unknown-active-seconds";
    public static final int TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_UNKNOWN_ACTIVE_SECONDS_DEFAULT = 86400;
    public static final String TIMELINE_SERVICE_LEVELDB_CACHE_READ_CACHE_SIZE = "yarn.timeline-service.entity-group-fs-store.leveldb-cache-read-cache-size";
    public static final long DEFAULT_TIMELINE_SERVICE_LEVELDB_CACHE_READ_CACHE_SIZE = 0xA00000L;
    public static final String TIMELINE_SERVICE_CLIENT_FD_FLUSH_INTERVAL_SECS = "yarn.timeline-service.client.fd-flush-interval-secs";
    public static final long TIMELINE_SERVICE_CLIENT_FD_FLUSH_INTERVAL_SECS_DEFAULT = 10L;
    public static final String TIMELINE_SERVICE_CLIENT_FD_CLEAN_INTERVAL_SECS = "yarn.timeline-service.client.fd-clean-interval-secs";
    public static final long TIMELINE_SERVICE_CLIENT_FD_CLEAN_INTERVAL_SECS_DEFAULT = 60L;
    public static final String TIMELINE_SERVICE_CLIENT_FD_RETAIN_SECS = "yarn.timeline-service.client.fd-retain-secs";
    public static final long TIMELINE_SERVICE_CLIENT_FD_RETAIN_SECS_DEFAULT = 300L;
    public static final String TIMELINE_SERVICE_CLIENT_INTERNAL_TIMERS_TTL_SECS = "yarn.timeline-service.client.internal-timers-ttl-secs";
    public static final long TIMELINE_SERVICE_CLIENT_INTERNAL_TIMERS_TTL_SECS_DEFAULT = 420L;
    public static final String TIMELINE_SERVICE_CLIENT_INTERNAL_ATTEMPT_DIR_CACHE_SIZE = "yarn.timeline-service.client.internal-attempt-dir-cache-size";
    public static final int DEFAULT_TIMELINE_SERVICE_CLIENT_INTERNAL_ATTEMPT_DIR_CACHE_SIZE = 1000;
    public static final String TIMELINE_SERVICE_ENTITYFILE_FS_SUPPORT_APPEND = "yarn.timeline-service.entity-file.fs-support-append";
    public static final String TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_WITH_USER_DIR = "yarn.timeline-service.entity-group-fs-store.with-user-dir";
    public static final String TIMELINE_SERVICE_READER_PREFIX = "yarn.timeline-service.reader.";
    public static final String TIMELINE_SERVICE_WRITER_CLASS = "yarn.timeline-service.writer.class";
    public static final String DEFAULT_TIMELINE_SERVICE_WRITER_CLASS = "org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineWriterImpl";
    public static final String TIMELINE_SERVICE_READER_CLASS = "yarn.timeline-service.reader.class";
    public static final String DEFAULT_TIMELINE_SERVICE_READER_CLASS = "org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineReaderImpl";
    public static final String DEFAULT_TIMELINE_SERVICE_HBASE_SCHEMA_PREFIX = "prod.";
    public static final String TIMELINE_SERVICE_HBASE_SCHEMA_PREFIX_NAME = "yarn.timeline-service.hbase-schema.prefix";
    public static final String TIMELINE_SERVICE_WRITER_FLUSH_INTERVAL_SECONDS = "yarn.timeline-service.writer.flush-interval-seconds";
    public static final int DEFAULT_TIMELINE_SERVICE_WRITER_FLUSH_INTERVAL_SECONDS = 60;
    public static final String APP_FINAL_VALUE_RETENTION_THRESHOLD = "yarn.timeline-service.hbase.coprocessor.app-final-value-retention-milliseconds";
    public static final String FLOW_RUN_COPROCESSOR_JAR_HDFS_LOCATION = "yarn.timeline-service.hbase.coprocessor.jar.hdfs.location";
    public static final String DEFAULT_HDFS_LOCATION_FLOW_RUN_COPROCESSOR_JAR = "/hbase/coprocessor/hadoop-yarn-server-timelineservice.jar";
    public static final String TIMELINE_SERVICE_HBASE_CONFIGURATION_FILE = "yarn.timeline-service.hbase.configuration.file";
    public static final String TIMELINE_SERVICE_READ_AUTH_ENABLED = "yarn.timeline-service.read.authentication.enabled";
    public static final Boolean DEFAULT_TIMELINE_SERVICE_READ_AUTH_ENABLED;
    public static final String TIMELINE_SERVICE_READ_ALLOWED_USERS = "yarn.timeline-service.read.allowed.users";
    public static final String DEFAULT_TIMELINE_SERVICE_READ_ALLOWED_USERS = "";
    public static final long DEFAULT_APP_FINAL_VALUE_RETENTION_THRESHOLD = 259200000L;
    public static final String ATS_APP_COLLECTOR_LINGER_PERIOD_IN_MS = "yarn.timeline-service.app-collector.linger-period.ms";
    public static final int DEFAULT_ATS_APP_COLLECTOR_LINGER_PERIOD_IN_MS = 60000;
    public static final String NUMBER_OF_ASYNC_ENTITIES_TO_MERGE = "yarn.timeline-service.timeline-client.number-of-async-entities-to-merge";
    public static final int DEFAULT_NUMBER_OF_ASYNC_ENTITIES_TO_MERGE = 10;
    public static final String DEFAULT_FLOW_VERSION = "1";
    public static final String TIMELINE_V2_CLIENT_DRAIN_TIME_MILLIS = "yarn.timeline-service.client.drain-entities.timeout.ms";
    public static final long DEFAULT_TIMELINE_V2_CLIENT_DRAIN_TIME_MILLIS = 2000L;
    @InterfaceAudience.Private
    public static final String APPLICATION_HISTORY_PREFIX = "yarn.timeline-service.generic-application-history.";
    @InterfaceAudience.Private
    public static final String APPLICATION_HISTORY_ENABLED = "yarn.timeline-service.generic-application-history.enabled";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_APPLICATION_HISTORY_ENABLED = false;
    @InterfaceAudience.Private
    public static final String APPLICATION_HISTORY_STORE = "yarn.timeline-service.generic-application-history.store-class";
    @InterfaceAudience.Private
    public static final String APPLICATION_HISTORY_SAVE_NON_AM_CONTAINER_META_INFO = "yarn.timeline-service.generic-application-history.save-non-am-container-meta-info";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_APPLICATION_HISTORY_SAVE_NON_AM_CONTAINER_META_INFO = true;
    @InterfaceAudience.Private
    public static final String FS_APPLICATION_HISTORY_STORE_URI = "yarn.timeline-service.generic-application-history.fs-history-store.uri";
    @InterfaceAudience.Private
    public static final String FS_APPLICATION_HISTORY_STORE_COMPRESSION_TYPE = "yarn.timeline-service.generic-application-history.fs-history-store.compression-type";
    @InterfaceAudience.Private
    public static final String DEFAULT_FS_APPLICATION_HISTORY_STORE_COMPRESSION_TYPE = "none";
    public static final String TIMELINE_SERVICE_ENABLED = "yarn.timeline-service.enabled";
    public static final boolean DEFAULT_TIMELINE_SERVICE_ENABLED = false;
    public static final String TIMELINE_SERVICE_ADDRESS = "yarn.timeline-service.address";
    public static final int DEFAULT_TIMELINE_SERVICE_PORT = 10200;
    public static final String DEFAULT_TIMELINE_SERVICE_ADDRESS = "0.0.0.0:10200";
    public static final String TIMELINE_SERVICE_BIND_HOST = "yarn.timeline-service.bind-host";
    public static final String DEFAULT_TIMELINE_SERVICE_BIND_HOST = "0.0.0.0";
    public static final String TIMELINE_SERVICE_HANDLER_THREAD_COUNT = "yarn.timeline-service.handler-thread-count";
    public static final int DEFAULT_TIMELINE_SERVICE_CLIENT_THREAD_COUNT = 10;
    public static final String TIMELINE_SERVICE_WEBAPP_ADDRESS = "yarn.timeline-service.webapp.address";
    public static final int DEFAULT_TIMELINE_SERVICE_WEBAPP_PORT = 8188;
    public static final String DEFAULT_TIMELINE_SERVICE_WEBAPP_ADDRESS = "0.0.0.0:8188";
    public static final String TIMELINE_SERVICE_WEBAPP_HTTPS_ADDRESS = "yarn.timeline-service.webapp.https.address";
    public static final int DEFAULT_TIMELINE_SERVICE_WEBAPP_HTTPS_PORT = 8190;
    public static final String DEFAULT_TIMELINE_SERVICE_WEBAPP_HTTPS_ADDRESS = "0.0.0.0:8190";
    public static final String APPLICATION_HISTORY_MAX_APPS = "yarn.timeline-service.generic-application-history.max-applications";
    public static final long DEFAULT_APPLICATION_HISTORY_MAX_APPS = 10000L;
    public static final String TIMELINE_SERVICE_STORE = "yarn.timeline-service.store-class";
    public static final String TIMELINE_SERVICE_TTL_ENABLE = "yarn.timeline-service.ttl-enable";
    public static final String TIMELINE_SERVICE_TTL_MS = "yarn.timeline-service.ttl-ms";
    public static final long DEFAULT_TIMELINE_SERVICE_TTL_MS = 604800000L;
    public static final String TIMELINE_SERVICE_ROLLING_PERIOD = "yarn.timeline-service.rolling-period";
    public static final String DEFAULT_TIMELINE_SERVICE_ROLLING_PERIOD = "hourly";
    public static final String TIMELINE_SERVICE_LEVELDB_PREFIX = "yarn.timeline-service.leveldb-timeline-store.";
    public static final String TIMELINE_SERVICE_LEVELDB_PATH = "yarn.timeline-service.leveldb-timeline-store.path";
    public static final String TIMELINE_SERVICE_LEVELDB_READ_CACHE_SIZE = "yarn.timeline-service.leveldb-timeline-store.read-cache-size";
    public static final long DEFAULT_TIMELINE_SERVICE_LEVELDB_READ_CACHE_SIZE = 0x6400000L;
    public static final String TIMELINE_SERVICE_LEVELDB_WRITE_BUFFER_SIZE = "yarn.timeline-service.leveldb-timeline-store.write-buffer-size";
    public static final int DEFAULT_TIMELINE_SERVICE_LEVELDB_WRITE_BUFFER_SIZE = 0x1000000;
    public static final String TIMELINE_SERVICE_LEVELDB_WRITE_BATCH_SIZE = "yarn.timeline-service.leveldb-timeline-store.write-batch-size";
    public static final int DEFAULT_TIMELINE_SERVICE_LEVELDB_WRITE_BATCH_SIZE = 10000;
    public static final String TIMELINE_SERVICE_LEVELDB_START_TIME_READ_CACHE_SIZE = "yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size";
    public static final int DEFAULT_TIMELINE_SERVICE_LEVELDB_START_TIME_READ_CACHE_SIZE = 10000;
    public static final String TIMELINE_SERVICE_LEVELDB_START_TIME_WRITE_CACHE_SIZE = "yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size";
    public static final int DEFAULT_TIMELINE_SERVICE_LEVELDB_START_TIME_WRITE_CACHE_SIZE = 10000;
    public static final String TIMELINE_SERVICE_LEVELDB_TTL_INTERVAL_MS = "yarn.timeline-service.leveldb-timeline-store.ttl-interval-ms";
    public static final long DEFAULT_TIMELINE_SERVICE_LEVELDB_TTL_INTERVAL_MS = 300000L;
    public static final String TIMELINE_SERVICE_LEVELDB_MAX_OPEN_FILES = "yarn.timeline-service.leveldb-timeline-store.max-open-files";
    public static final int DEFAULT_TIMELINE_SERVICE_LEVELDB_MAX_OPEN_FILES = 1000;
    public static final String TIMELINE_SERVICE_PRINCIPAL = "yarn.timeline-service.principal";
    public static final String TIMELINE_SERVICE_KEYTAB = "yarn.timeline-service.keytab";
    public static final String TIMELINE_SERVICE_HTTP_CROSS_ORIGIN_ENABLED = "yarn.timeline-service.http-cross-origin.enabled";
    public static final boolean TIMELINE_SERVICE_HTTP_CROSS_ORIGIN_ENABLED_DEFAULT = false;
    public static final String TIMELINE_SERVICE_CLIENT_MAX_RETRIES = "yarn.timeline-service.client.max-retries";
    public static final int DEFAULT_TIMELINE_SERVICE_CLIENT_MAX_RETRIES = 30;
    public static final String TIMELINE_SERVICE_CLIENT_RETRY_INTERVAL_MS = "yarn.timeline-service.client.retry-interval-ms";
    public static final long DEFAULT_TIMELINE_SERVICE_CLIENT_RETRY_INTERVAL_MS = 1000L;
    public static final String TIMELINE_SERVICE_CLIENT_BEST_EFFORT = "yarn.timeline-service.client.best-effort";
    public static final boolean DEFAULT_TIMELINE_SERVICE_CLIENT_BEST_EFFORT = false;
    public static final String TIMELINE_SERVICE_RECOVERY_ENABLED = "yarn.timeline-service.recovery.enabled";
    public static final boolean DEFAULT_TIMELINE_SERVICE_RECOVERY_ENABLED = false;
    public static final String TIMELINE_SERVICE_STATE_STORE_CLASS = "yarn.timeline-service.state-store-class";
    public static final String TIMELINE_SERVICE_LEVELDB_STATE_STORE_PREFIX = "yarn.timeline-service.leveldb-state-store.";
    public static final String TIMELINE_SERVICE_LEVELDB_STATE_STORE_PATH = "yarn.timeline-service.leveldb-state-store.path";
    public static final String TIMELINE_DELEGATION_KEY_UPDATE_INTERVAL = "yarn.timeline-service.delegation.key.update-interval";
    public static final long DEFAULT_TIMELINE_DELEGATION_KEY_UPDATE_INTERVAL = 86400000L;
    public static final String TIMELINE_DELEGATION_TOKEN_RENEW_INTERVAL = "yarn.timeline-service.delegation.token.renew-interval";
    public static final long DEFAULT_TIMELINE_DELEGATION_TOKEN_RENEW_INTERVAL = 86400000L;
    public static final String TIMELINE_DELEGATION_TOKEN_MAX_LIFETIME = "yarn.timeline-service.delegation.token.max-lifetime";
    public static final long DEFAULT_TIMELINE_DELEGATION_TOKEN_MAX_LIFETIME = 604800000L;
    public static final String TIMELINE_OFFLINE_AGGREGATION_PREFIX = "yarn.timeline-service.aggregation.offline.";
    public static final String PHOENIX_OFFLINE_STORAGE_CONN_STR = "yarn.timeline-service.aggregation.offline.phoenix.connectionString";
    public static final String PHOENIX_OFFLINE_STORAGE_CONN_STR_DEFAULT = "jdbc:phoenix:localhost:2181:/hbase";
    public static final String SHARED_CACHE_PREFIX = "yarn.sharedcache.";
    public static final String SHARED_CACHE_ENABLED = "yarn.sharedcache.enabled";
    public static final boolean DEFAULT_SHARED_CACHE_ENABLED = false;
    public static final String SHARED_CACHE_ROOT = "yarn.sharedcache.root-dir";
    public static final String DEFAULT_SHARED_CACHE_ROOT = "/sharedcache";
    public static final String SHARED_CACHE_NESTED_LEVEL = "yarn.sharedcache.nested-level";
    public static final int DEFAULT_SHARED_CACHE_NESTED_LEVEL = 3;
    public static final String SCM_STORE_PREFIX = "yarn.sharedcache.store.";
    public static final String SCM_STORE_CLASS = "yarn.sharedcache.store.class";
    public static final String DEFAULT_SCM_STORE_CLASS = "org.apache.hadoop.yarn.server.sharedcachemanager.store.InMemorySCMStore";
    public static final String SCM_APP_CHECKER_CLASS = "yarn.sharedcache.app-checker.class";
    public static final String DEFAULT_SCM_APP_CHECKER_CLASS = "org.apache.hadoop.yarn.server.sharedcachemanager.RemoteAppChecker";
    public static final String SCM_ADMIN_ADDRESS = "yarn.sharedcache.admin.address";
    public static final int DEFAULT_SCM_ADMIN_PORT = 8047;
    public static final String DEFAULT_SCM_ADMIN_ADDRESS = "0.0.0.0:8047";
    public static final String SCM_ADMIN_CLIENT_THREAD_COUNT = "yarn.sharedcache.admin.thread-count";
    public static final int DEFAULT_SCM_ADMIN_CLIENT_THREAD_COUNT = 1;
    public static final String SCM_WEBAPP_ADDRESS = "yarn.sharedcache.webapp.address";
    public static final int DEFAULT_SCM_WEBAPP_PORT = 8788;
    public static final String DEFAULT_SCM_WEBAPP_ADDRESS = "0.0.0.0:8788";
    public static final String IN_MEMORY_STORE_PREFIX = "yarn.sharedcache.store.in-memory.";
    public static final String IN_MEMORY_STALENESS_PERIOD_MINS = "yarn.sharedcache.store.in-memory.staleness-period-mins";
    public static final int DEFAULT_IN_MEMORY_STALENESS_PERIOD_MINS = 10080;
    public static final String IN_MEMORY_INITIAL_DELAY_MINS = "yarn.sharedcache.store.in-memory.initial-delay-mins";
    public static final int DEFAULT_IN_MEMORY_INITIAL_DELAY_MINS = 10;
    public static final String IN_MEMORY_CHECK_PERIOD_MINS = "yarn.sharedcache.store.in-memory.check-period-mins";
    public static final int DEFAULT_IN_MEMORY_CHECK_PERIOD_MINS = 720;
    private static final String SCM_CLEANER_PREFIX = "yarn.sharedcache.cleaner.";
    public static final String SCM_CLEANER_PERIOD_MINS = "yarn.sharedcache.cleaner.period-mins";
    public static final int DEFAULT_SCM_CLEANER_PERIOD_MINS = 1440;
    public static final String SCM_CLEANER_INITIAL_DELAY_MINS = "yarn.sharedcache.cleaner.initial-delay-mins";
    public static final int DEFAULT_SCM_CLEANER_INITIAL_DELAY_MINS = 10;
    public static final String SCM_CLEANER_RESOURCE_SLEEP_MS = "yarn.sharedcache.cleaner.resource-sleep-ms";
    public static final long DEFAULT_SCM_CLEANER_RESOURCE_SLEEP_MS = 0L;
    public static final String SCM_UPLOADER_SERVER_ADDRESS = "yarn.sharedcache.uploader.server.address";
    public static final int DEFAULT_SCM_UPLOADER_SERVER_PORT = 8046;
    public static final String DEFAULT_SCM_UPLOADER_SERVER_ADDRESS = "0.0.0.0:8046";
    public static final String SCM_UPLOADER_SERVER_THREAD_COUNT = "yarn.sharedcache.uploader.server.thread-count";
    public static final int DEFAULT_SCM_UPLOADER_SERVER_THREAD_COUNT = 50;
    public static final String SCM_CLIENT_SERVER_ADDRESS = "yarn.sharedcache.client-server.address";
    public static final int DEFAULT_SCM_CLIENT_SERVER_PORT = 8045;
    public static final String DEFAULT_SCM_CLIENT_SERVER_ADDRESS = "0.0.0.0:8045";
    public static final String SCM_CLIENT_SERVER_THREAD_COUNT = "yarn.sharedcache.client-server.thread-count";
    public static final int DEFAULT_SCM_CLIENT_SERVER_THREAD_COUNT = 50;
    public static final String SHARED_CACHE_CHECKSUM_ALGO_IMPL = "yarn.sharedcache.checksum.algo.impl";
    public static final String DEFAULT_SHARED_CACHE_CHECKSUM_ALGO_IMPL = "org.apache.hadoop.yarn.sharedcache.ChecksumSHA256Impl";
    public static final String SHARED_CACHE_NM_UPLOADER_REPLICATION_FACTOR = "yarn.sharedcache.nm.uploader.replication.factor";
    public static final int DEFAULT_SHARED_CACHE_NM_UPLOADER_REPLICATION_FACTOR = 10;
    public static final String SHARED_CACHE_NM_UPLOADER_THREAD_COUNT = "yarn.sharedcache.nm.uploader.thread-count";
    public static final int DEFAULT_SHARED_CACHE_NM_UPLOADER_THREAD_COUNT = 20;
    public static final String FEDERATION_PREFIX = "yarn.federation.";
    public static final String FEDERATION_ENABLED = "yarn.federation.enabled";
    public static final boolean DEFAULT_FEDERATION_ENABLED = false;
    public static final String FEDERATION_FAILOVER_ENABLED = "yarn.federation.failover.enabled";
    public static final boolean DEFAULT_FEDERATION_FAILOVER_ENABLED = true;
    public static final String FEDERATION_STATESTORE_CLIENT_CLASS = "yarn.federation.state-store.class";
    public static final String DEFAULT_FEDERATION_STATESTORE_CLIENT_CLASS = "org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore";
    public static final String FEDERATION_CACHE_TIME_TO_LIVE_SECS = "yarn.federation.cache-ttl.secs";
    public static final int DEFAULT_FEDERATION_CACHE_TIME_TO_LIVE_SECS = 300;
    public static final String FEDERATION_FLUSH_CACHE_FOR_RM_ADDR = "yarn.federation.flush-cache-for-rm-addr";
    public static final boolean DEFAULT_FEDERATION_FLUSH_CACHE_FOR_RM_ADDR = true;
    public static final String FEDERATION_REGISTRY_BASE_KEY = "yarn.federation.registry.base-dir";
    public static final String DEFAULT_FEDERATION_REGISTRY_BASE_KEY = "yarnfederation/";
    public static final String FEDERATION_STATESTORE_HEARTBEAT_INTERVAL_SECS = "yarn.federation.state-store.heartbeat-interval-secs";
    public static final int DEFAULT_FEDERATION_STATESTORE_HEARTBEAT_INTERVAL_SECS = 300;
    public static final String FEDERATION_MACHINE_LIST = "yarn.federation.machine-list";
    public static final String FEDERATION_CLUSTER_RESOLVER_CLASS = "yarn.federation.subcluster-resolver.class";
    public static final String DEFAULT_FEDERATION_CLUSTER_RESOLVER_CLASS = "org.apache.hadoop.yarn.server.federation.resolver.DefaultSubClusterResolverImpl";
    public static final String DEFAULT_FEDERATION_POLICY_KEY = "*";
    public static final String FEDERATION_POLICY_MANAGER = "yarn.federation.policy-manager";
    public static final String DEFAULT_FEDERATION_POLICY_MANAGER = "org.apache.hadoop.yarn.server.federation.policies.manager.UniformBroadcastPolicyManager";
    public static final String FEDERATION_POLICY_MANAGER_PARAMS = "yarn.federation.policy-manager-params";
    public static final String DEFAULT_FEDERATION_POLICY_MANAGER_PARAMS = "";
    public static final String FEDERATION_STATESTORE_ZK_PREFIX = "yarn.federation.zk-state-store.";
    public static final String FEDERATION_STATESTORE_ZK_PARENT_PATH = "yarn.federation.zk-state-store.parent-path";
    public static final String DEFAULT_FEDERATION_STATESTORE_ZK_PARENT_PATH = "/federationstore";
    private static final String FEDERATION_STATESTORE_SQL_PREFIX = "yarn.federation.state-store.sql.";
    public static final String FEDERATION_STATESTORE_SQL_USERNAME = "yarn.federation.state-store.sql.username";
    public static final String FEDERATION_STATESTORE_SQL_PASSWORD = "yarn.federation.state-store.sql.password";
    public static final String FEDERATION_STATESTORE_SQL_URL = "yarn.federation.state-store.sql.url";
    public static final String FEDERATION_STATESTORE_SQL_JDBC_CLASS = "yarn.federation.state-store.sql.jdbc-class";
    public static final String DEFAULT_FEDERATION_STATESTORE_SQL_JDBC_CLASS = "org.apache.hadoop.shaded.org.hsqldb.jdbc.JDBCDataSource";
    public static final String FEDERATION_STATESTORE_SQL_MAXCONNECTIONS = "yarn.federation.state-store.sql.max-connections";
    public static final int DEFAULT_FEDERATION_STATESTORE_SQL_MAXCONNECTIONS = 1;
    public static final String ROUTER_PREFIX = "yarn.router.";
    public static final String ROUTER_BIND_HOST = "yarn.router.bind-host";
    public static final String ROUTER_CLIENTRM_PREFIX = "yarn.router.clientrm.";
    public static final String ROUTER_CLIENTRM_ADDRESS = "yarn.router.clientrm.address";
    public static final int DEFAULT_ROUTER_CLIENTRM_PORT = 8050;
    public static final String DEFAULT_ROUTER_CLIENTRM_ADDRESS = "0.0.0.0:8050";
    public static final String ROUTER_CLIENTRM_INTERCEPTOR_CLASS_PIPELINE = "yarn.router.clientrm.interceptor-class.pipeline";
    public static final String DEFAULT_ROUTER_CLIENTRM_INTERCEPTOR_CLASS = "org.apache.hadoop.yarn.server.router.clientrm.DefaultClientRequestInterceptor";
    public static final String ROUTER_PIPELINE_CACHE_MAX_SIZE = "yarn.router.pipeline.cache-max-size";
    public static final int DEFAULT_ROUTER_PIPELINE_CACHE_MAX_SIZE = 25;
    public static final String ROUTER_RMADMIN_PREFIX = "yarn.router.rmadmin.";
    public static final String ROUTER_RMADMIN_ADDRESS = "yarn.router.rmadmin.address";
    public static final int DEFAULT_ROUTER_RMADMIN_PORT = 8052;
    public static final String DEFAULT_ROUTER_RMADMIN_ADDRESS = "0.0.0.0:8052";
    public static final String ROUTER_RMADMIN_INTERCEPTOR_CLASS_PIPELINE = "yarn.router.rmadmin.interceptor-class.pipeline";
    public static final String DEFAULT_ROUTER_RMADMIN_INTERCEPTOR_CLASS = "org.apache.hadoop.yarn.server.router.rmadmin.DefaultRMAdminRequestInterceptor";
    public static final String ROUTER_CLIENTRM_SUBMIT_RETRY = "yarn.router.submit.retry";
    public static final int DEFAULT_ROUTER_CLIENTRM_SUBMIT_RETRY = 3;
    public static final String ROUTER_WEBAPP_PREFIX = "yarn.router.webapp.";
    public static final String ROUTER_WEBAPP_ADDRESS = "yarn.router.webapp.address";
    public static final int DEFAULT_ROUTER_WEBAPP_PORT = 8089;
    public static final String DEFAULT_ROUTER_WEBAPP_ADDRESS = "0.0.0.0:8089";
    public static final String ROUTER_WEBAPP_HTTPS_ADDRESS = "yarn.router.webapp.https.address";
    public static final int DEFAULT_ROUTER_WEBAPP_HTTPS_PORT = 8091;
    public static final String DEFAULT_ROUTER_WEBAPP_HTTPS_ADDRESS = "0.0.0.0:8091";
    public static final String ROUTER_WEBAPP_INTERCEPTOR_CLASS_PIPELINE = "yarn.router.webapp.interceptor-class.pipeline";
    public static final String DEFAULT_ROUTER_WEBAPP_INTERCEPTOR_CLASS = "org.apache.hadoop.yarn.server.router.webapp.DefaultRequestInterceptorREST";
    public static final String ROUTER_WEBAPP_DEFAULT_INTERCEPTOR_CLASS = "yarn.router.webapp.default-interceptor-class";
    public static final String DEFAULT_ROUTER_WEBAPP_DEFAULT_INTERCEPTOR_CLASS = "org.apache.hadoop.yarn.server.router.webapp.DefaultRequestInterceptorREST";
    public static final String ROUTER_WEBAPP_PARTIAL_RESULTS_ENABLED = "yarn.router.webapp.partial-result.enabled";
    public static final boolean DEFAULT_ROUTER_WEBAPP_PARTIAL_RESULTS_ENABLED = false;
    public static final String YARN_REGISTRY_CLASS = "yarn.registry.class";
    public static final String DEFAULT_YARN_REGISTRY_CLASS = "org.apache.hadoop.registry.client.impl.FSRegistryOperationsService";
    @Deprecated
    public static final String YARN_CLIENT_APP_SUBMISSION_POLL_INTERVAL_MS = "yarn.client.app-submission.poll-interval";
    public static final String YARN_CLIENT_APPLICATION_CLIENT_PROTOCOL_POLL_INTERVAL_MS = "yarn.client.application-client-protocol.poll-interval-ms";
    public static final long DEFAULT_YARN_CLIENT_APPLICATION_CLIENT_PROTOCOL_POLL_INTERVAL_MS = 200L;
    public static final String YARN_CLIENT_APPLICATION_CLIENT_PROTOCOL_POLL_TIMEOUT_MS = "yarn.client.application-client-protocol.poll-timeout-ms";
    public static final long DEFAULT_YARN_CLIENT_APPLICATION_CLIENT_PROTOCOL_POLL_TIMEOUT_MS = -1L;
    public static final String NM_CLIENT_ASYNC_THREAD_POOL_MAX_SIZE = "yarn.client.nodemanager-client-async.thread-pool-max-size";
    public static final int DEFAULT_NM_CLIENT_ASYNC_THREAD_POOL_MAX_SIZE = 500;
    public static final String NM_CLIENT_MAX_NM_PROXIES = "yarn.client.max-cached-nodemanagers-proxies";
    public static final int DEFAULT_NM_CLIENT_MAX_NM_PROXIES = 0;
    public static final String CLIENT_NM_CONNECT_MAX_WAIT_MS = "yarn.client.nodemanager-connect.max-wait-ms";
    public static final long DEFAULT_CLIENT_NM_CONNECT_MAX_WAIT_MS = 180000L;
    public static final String CLIENT_NM_CONNECT_RETRY_INTERVAL_MS = "yarn.client.nodemanager-connect.retry-interval-ms";
    public static final long DEFAULT_CLIENT_NM_CONNECT_RETRY_INTERVAL_MS = 10000L;
    public static final String YARN_HTTP_POLICY_KEY = "yarn.http.policy";
    public static final String YARN_HTTP_POLICY_DEFAULT;
    public static final String NM_RESOURCEMANAGER_CONNECT_MAX_WAIT_MS = "yarn.nodemanager.resourcemanager.connect.max-wait.ms";
    public static final String NM_RESOURCEMANAGER_CONNECT_RETRY_INTERVAL_MS = "yarn.nodemanager.resourcemanager.connect.retry-interval.ms";
    public static final String NODE_LABELS_PREFIX = "yarn.node-labels.";
    public static final String FS_NODE_LABELS_STORE_IMPL_CLASS = "yarn.node-labels.fs-store.impl.class";
    public static final String DEFAULT_FS_NODE_LABELS_STORE_IMPL_CLASS = "org.apache.hadoop.yarn.nodelabels.FileSystemNodeLabelsStore";
    public static final String FS_NODE_LABELS_STORE_ROOT_DIR = "yarn.node-labels.fs-store.root-dir";
    public static final String NODE_LABELS_ENABLED = "yarn.node-labels.enabled";
    public static final boolean DEFAULT_NODE_LABELS_ENABLED = false;
    public static final String NODELABEL_CONFIGURATION_TYPE = "yarn.node-labels.configuration-type";
    public static final String CENTRALIZED_NODELABEL_CONFIGURATION_TYPE = "centralized";
    public static final String DELEGATED_CENTALIZED_NODELABEL_CONFIGURATION_TYPE = "delegated-centralized";
    public static final String DISTRIBUTED_NODELABEL_CONFIGURATION_TYPE = "distributed";
    public static final String DEFAULT_NODELABEL_CONFIGURATION_TYPE = "centralized";
    public static final String MAX_CLUSTER_LEVEL_APPLICATION_PRIORITY = "yarn.cluster.max-application-priority";
    public static final int DEFAULT_CLUSTER_LEVEL_APPLICATION_PRIORITY = 0;
    public static final String APP_ATTEMPT_DIAGNOSTICS_LIMIT_KC = "yarn.app.attempt.diagnostics.limit.kc";
    public static final int DEFAULT_APP_ATTEMPT_DIAGNOSTICS_LIMIT_KC = 64;
    private static final String NM_NODE_LABELS_PREFIX = "yarn.nodemanager.node-labels.";
    public static final String NM_NODE_LABELS_PROVIDER_CONFIG = "yarn.nodemanager.node-labels.provider";
    public static final String CONFIG_NODE_LABELS_PROVIDER = "config";
    public static final String SCRIPT_NODE_LABELS_PROVIDER = "script";
    private static final String NM_NODE_LABELS_PROVIDER_PREFIX = "yarn.nodemanager.node-labels.provider.";
    public static final String NM_NODE_LABELS_RESYNC_INTERVAL = "yarn.nodemanager.node-labels.resync-interval-ms";
    public static final long DEFAULT_NM_NODE_LABELS_RESYNC_INTERVAL = 120000L;
    public static final String NM_NODE_LABELS_PROVIDER_FETCH_INTERVAL_MS = "yarn.nodemanager.node-labels.provider.fetch-interval-ms";
    public static final String NM_NODE_LABELS_PROVIDER_FETCH_TIMEOUT_MS = "yarn.nodemanager.node-labels.provider.fetch-timeout-ms";
    public static final long DEFAULT_NM_NODE_LABELS_PROVIDER_FETCH_INTERVAL_MS = 600000L;
    public static final long DEFAULT_NM_NODE_LABELS_PROVIDER_FETCH_TIMEOUT_MS = 1200000L;
    public static final String NM_PROVIDER_CONFIGURED_NODE_PARTITION = "yarn.nodemanager.node-labels.provider.configured-node-partition";
    private static final String RM_NODE_LABELS_PREFIX = "yarn.resourcemanager.node-labels.";
    public static final String RM_NODE_LABELS_PROVIDER_CONFIG = "yarn.resourcemanager.node-labels.provider";
    private static final String RM_NODE_LABELS_PROVIDER_PREFIX = "yarn.resourcemanager.node-labels.provider.";
    public static final String RM_NODE_LABELS_PROVIDER_FETCH_INTERVAL_MS = "yarn.resourcemanager.node-labels.provider.fetch-interval-ms";
    public static final long DEFAULT_RM_NODE_LABELS_PROVIDER_FETCH_INTERVAL_MS = 1800000L;
    @InterfaceAudience.Private
    public static final String AM_SCHEDULING_NODE_BLACKLISTING_ENABLED = "yarn.resourcemanager.am-scheduling.node-blacklisting-enabled";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_AM_SCHEDULING_NODE_BLACKLISTING_ENABLED = false;
    @InterfaceAudience.Private
    public static final String AM_SCHEDULING_NODE_BLACKLISTING_DISABLE_THRESHOLD = "yarn.resourcemanager.am-scheduling.node-blacklisting-disable-threshold";
    @InterfaceAudience.Private
    public static final float DEFAULT_AM_SCHEDULING_NODE_BLACKLISTING_DISABLE_THRESHOLD = 0.2f;
    private static final String NM_SCRIPT_BASED_NODE_LABELS_PROVIDER_PREFIX = "yarn.nodemanager.node-labels.provider.script.";
    public static final String NM_SCRIPT_BASED_NODE_LABELS_PROVIDER_PATH = "yarn.nodemanager.node-labels.provider.script.path";
    public static final String NM_SCRIPT_BASED_NODE_LABELS_PROVIDER_SCRIPT_OPTS = "yarn.nodemanager.node-labels.provider.script.opts";
    @Deprecated
    public static final String DISPLAY_APPS_FOR_LOGGED_IN_USER = "yarn.resourcemanager.display.per-user-apps";
    public static final String FILTER_ENTITY_LIST_BY_USER = "yarn.webapp.filter-entity-list-by-user";
    public static final boolean DEFAULT_DISPLAY_APPS_FOR_LOGGED_IN_USER = false;
    public static final String REST_CSRF = "webapp.rest-csrf.";
    public static final String RM_CSRF_PREFIX = "yarn.resourcemanager.webapp.rest-csrf.";
    public static final String NM_CSRF_PREFIX = "yarn.nodemanager.webapp.rest-csrf.";
    public static final String TIMELINE_CSRF_PREFIX = "yarn.timeline-service.webapp.rest-csrf.";
    public static final String RM_CSRF_ENABLED = "yarn.resourcemanager.webapp.rest-csrf.enabled";
    public static final String NM_CSRF_ENABLED = "yarn.nodemanager.webapp.rest-csrf.enabled";
    public static final String TIMELINE_CSRF_ENABLED = "yarn.timeline-service.webapp.rest-csrf.enabled";
    public static final String RM_CSRF_CUSTOM_HEADER = "yarn.resourcemanager.webapp.rest-csrf.custom-header";
    public static final String NM_CSRF_CUSTOM_HEADER = "yarn.nodemanager.webapp.rest-csrf.custom-header";
    public static final String TIMELINE_CSRF_CUSTOM_HEADER = "yarn.timeline-service.webapp.rest-csrf.custom-header";
    public static final String RM_CSRF_METHODS_TO_IGNORE = "yarn.resourcemanager.webapp.rest-csrf.methods-to-ignore";
    public static final String NM_CSRF_METHODS_TO_IGNORE = "yarn.nodemanager.webapp.rest-csrf.methods-to-ignore";
    public static final String TIMELINE_CSRF_METHODS_TO_IGNORE = "yarn.timeline-service.webapp.rest-csrf.methods-to-ignore";
    public static final String XFS = "webapp.xfs-filter.";
    public static final String YARN_XFS_ENABLED = "yarn.webapp.xfs-filter.enabled";
    public static final String RM_XFS_PREFIX = "yarn.resourcemanager.webapp.xfs-filter.";
    public static final String NM_XFS_PREFIX = "yarn.nodemanager.webapp.xfs-filter.";
    public static final String TIMELINE_XFS_PREFIX = "yarn.timeline-service.webapp.xfs-filter.";
    public static final String RM_XFS_OPTIONS = "yarn.resourcemanager.webapp.xfs-filter.xframe-options";
    public static final String NM_XFS_OPTIONS = "yarn.nodemanager.webapp.xfs-filter.xframe-options";
    public static final String TIMELINE_XFS_OPTIONS = "yarn.timeline-service.webapp.xfs-filter.xframe-options";
    public static final String TIMELINE_SERVICE_READER_BIND_HOST = "yarn.timeline-service.reader.bind-host";
    public static final String TIMELINE_SERVICE_READER_WEBAPP_ADDRESS = "yarn.timeline-service.reader.webapp.address";
    public static final String DEFAULT_TIMELINE_SERVICE_READER_WEBAPP_ADDRESS = "0.0.0.0:8188";
    public static final String TIMELINE_SERVICE_READER_WEBAPP_HTTPS_ADDRESS = "yarn.timeline-service.reader.webapp.https.address";
    public static final String DEFAULT_TIMELINE_SERVICE_READER_WEBAPP_HTTPS_ADDRESS = "0.0.0.0:8190";
    @InterfaceAudience.Private
    public static final String TIMELINE_SERVICE_READER_STORAGE_MONITOR_INTERVAL_MS = "yarn.timeline-service.reader.storage-monitor.interval-ms";
    public static final long DEFAULT_TIMELINE_SERVICE_STORAGE_MONITOR_INTERVAL_MS = 60000L;
    public static final String TIMELINE_SERVICE_COLLECTOR_PREFIX = "yarn.timeline-service.collector.";
    @InterfaceAudience.Private
    public static final String TIMELINE_SERVICE_COLLECTOR_BIND_HOST = "yarn.timeline-service.collector.bind-host";
    @InterfaceAudience.Private
    public static final String TIMELINE_SERVICE_COLLECTOR_WEBAPP_ADDRESS = "yarn.timeline-service.collector.webapp.address";
    public static final String DEFAULT_TIMELINE_SERVICE_COLLECTOR_WEBAPP_ADDRESS = "0.0.0.0:8188";
    @InterfaceAudience.Private
    public static final String TIMELINE_SERVICE_COLLECTOR_WEBAPP_HTTPS_ADDRESS = "yarn.timeline-service.collector.webapp.https.address";
    public static final String DEFAULT_TIMELINE_SERVICE_COLLECTOR_WEBAPP_HTTPS_ADDRESS = "0.0.0.0:8190";
    public static final String NM_NUMA_AWARENESS_ENABLED = "yarn.nodemanager.numa-awareness.enabled";
    public static final boolean DEFAULT_NM_NUMA_AWARENESS_ENABLED = false;
    public static final String NM_NUMA_AWARENESS_READ_TOPOLOGY = "yarn.nodemanager.numa-awareness.read-topology";
    public static final boolean DEFAULT_NM_NUMA_AWARENESS_READ_TOPOLOGY = false;
    public static final String NM_NUMA_AWARENESS_NODE_IDS = "yarn.nodemanager.numa-awareness.node-ids";
    public static final String NM_NUMA_AWARENESS_NUMACTL_CMD = "yarn.nodemanager.numa-awareness.numactl.cmd";
    public static final String DEFAULT_NM_NUMA_AWARENESS_NUMACTL_CMD = "/usr/bin/numactl";
    public static final String NM_CONTAINERS_LAUNCHER_CLASS = "yarn.nodemanager.containers-launcher.class";

    private static void addDeprecatedKeys() {
        Configuration.addDeprecations(new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta("yarn.client.max-nodemanagers-proxies", NM_CLIENT_MAX_NM_PROXIES)});
        Configuration.addDeprecations(new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta(RM_SYSTEM_METRICS_PUBLISHER_ENABLED, SYSTEM_METRICS_PUBLISHER_ENABLED), new Configuration.DeprecationDelta(RM_ZK_ACL, "hadoop.zk.acl"), new Configuration.DeprecationDelta(RM_ZK_AUTH, "hadoop.zk.auth"), new Configuration.DeprecationDelta(RM_ZK_ADDRESS, "hadoop.zk.address"), new Configuration.DeprecationDelta(RM_ZK_NUM_RETRIES, "hadoop.zk.num-retries"), new Configuration.DeprecationDelta(RM_ZK_TIMEOUT_MS, "hadoop.zk.timeout-ms"), new Configuration.DeprecationDelta(RM_ZK_RETRY_INTERVAL_MS, "hadoop.zk.retry-interval-ms")});
        Configuration.addDeprecations(new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta(DISPLAY_APPS_FOR_LOGGED_IN_USER, FILTER_ENTITY_LIST_BY_USER)});
    }

    public static boolean isAclEnabled(Configuration conf) {
        return conf.getBoolean(YARN_ACL_ENABLE, false);
    }

    @InterfaceAudience.Private
    public static boolean isDistributedNodeLabelConfiguration(Configuration conf) {
        return DISTRIBUTED_NODELABEL_CONFIGURATION_TYPE.equals(conf.get(NODELABEL_CONFIGURATION_TYPE, "centralized"));
    }

    @InterfaceAudience.Private
    public static boolean isCentralizedNodeLabelConfiguration(Configuration conf) {
        return "centralized".equals(conf.get(NODELABEL_CONFIGURATION_TYPE, "centralized"));
    }

    @InterfaceAudience.Private
    public static boolean isDelegatedCentralizedNodeLabelConfiguration(Configuration conf) {
        return DELEGATED_CENTALIZED_NODELABEL_CONFIGURATION_TYPE.equals(conf.get(NODELABEL_CONFIGURATION_TYPE, "centralized"));
    }

    @InterfaceAudience.Private
    public static boolean areNodeLabelsEnabled(Configuration conf) {
        return conf.getBoolean(NODE_LABELS_ENABLED, false);
    }

    public YarnConfiguration() {
    }

    public YarnConfiguration(Configuration conf) {
        super(conf);
        if (!(conf instanceof YarnConfiguration)) {
            this.reloadConfiguration();
        }
    }

    @InterfaceAudience.Private
    public static List<String> getServiceAddressConfKeys(Configuration conf) {
        return YarnConfiguration.useHttps(conf) ? RM_SERVICES_ADDRESS_CONF_KEYS_HTTPS : RM_SERVICES_ADDRESS_CONF_KEYS_HTTP;
    }

    @Override
    public InetSocketAddress getSocketAddr(String name, String defaultAddress, int defaultPort) {
        String address = HAUtil.isHAEnabled(this) && YarnConfiguration.getServiceAddressConfKeys(this).contains(name) ? HAUtil.getConfValueForRMInstance(name, defaultAddress, this) : this.get(name, defaultAddress);
        return NetUtils.createSocketAddr(address, defaultPort, name);
    }

    @Override
    public InetSocketAddress updateConnectAddr(String name, InetSocketAddress addr) {
        String prefix = name;
        if (HAUtil.isHAEnabled(this) && YarnConfiguration.getServiceAddressConfKeys(this).contains(name)) {
            prefix = HAUtil.addSuffix(prefix, HAUtil.getRMHAId(this));
        }
        return super.updateConnectAddr(prefix, addr);
    }

    @InterfaceAudience.Private
    public static int getRMDefaultPortNumber(String addressPrefix, Configuration conf) {
        if (addressPrefix.equals(RM_ADDRESS)) {
            return 8032;
        }
        if (addressPrefix.equals(RM_SCHEDULER_ADDRESS)) {
            return 8030;
        }
        if (addressPrefix.equals(RM_WEBAPP_ADDRESS)) {
            return 8088;
        }
        if (addressPrefix.equals(RM_WEBAPP_HTTPS_ADDRESS)) {
            return 8090;
        }
        if (addressPrefix.equals(RM_RESOURCE_TRACKER_ADDRESS)) {
            return 8031;
        }
        if (addressPrefix.equals(RM_ADMIN_ADDRESS)) {
            return 8033;
        }
        throw new HadoopIllegalArgumentException("Invalid RM RPC address Prefix: " + addressPrefix + ". The valid value should be one of " + YarnConfiguration.getServiceAddressConfKeys(conf));
    }

    public static boolean useHttps(Configuration conf) {
        return HttpConfig.Policy.HTTPS_ONLY == HttpConfig.Policy.fromString(conf.get(YARN_HTTP_POLICY_KEY, YARN_HTTP_POLICY_DEFAULT));
    }

    public static boolean shouldRMFailFast(Configuration conf) {
        return conf.getBoolean(RM_FAIL_FAST, conf.getBoolean(YARN_FAIL_FAST, false));
    }

    @InterfaceAudience.Private
    public static String getClusterId(Configuration conf) {
        String clusterId = conf.get(RM_CLUSTER_ID);
        if (clusterId == null) {
            throw new HadoopIllegalArgumentException("Configuration doesn't specify yarn.resourcemanager.cluster-id");
        }
        return clusterId;
    }

    public static boolean isDistSchedulingEnabled(Configuration conf) {
        return conf.getBoolean(DIST_SCHEDULING_ENABLED, false);
    }

    public static boolean isOpportunisticContainerAllocationEnabled(Configuration conf) {
        return conf.getBoolean(OPPORTUNISTIC_CONTAINER_ALLOCATION_ENABLED, false);
    }

    public static boolean timelineServiceEnabled(Configuration conf) {
        return conf.getBoolean(TIMELINE_SERVICE_ENABLED, false);
    }

    public static float getTimelineServiceVersion(Configuration conf) {
        return conf.getFloat(TIMELINE_SERVICE_VERSION, 1.0f);
    }

    public static boolean timelineServiceV2Enabled(Configuration conf) {
        boolean enabled = false;
        if (YarnConfiguration.timelineServiceEnabled(conf)) {
            Collection<Float> versions = YarnConfiguration.getTimelineServiceVersions(conf);
            for (Float version : versions) {
                if (version.intValue() != 2) continue;
                enabled = true;
                break;
            }
        }
        return enabled;
    }

    public static boolean timelineServiceV1Enabled(Configuration conf) {
        boolean enabled = false;
        if (YarnConfiguration.timelineServiceEnabled(conf)) {
            Collection<Float> versions = YarnConfiguration.getTimelineServiceVersions(conf);
            for (Float version : versions) {
                if (version.intValue() != 1) continue;
                enabled = true;
                break;
            }
        }
        return enabled;
    }

    public static boolean timelineServiceV15Enabled(Configuration conf) {
        boolean enabled = false;
        if (YarnConfiguration.timelineServiceEnabled(conf)) {
            Collection<Float> versions = YarnConfiguration.getTimelineServiceVersions(conf);
            for (Float version : versions) {
                if (Float.compare(version.floatValue(), 1.5f) != 0) continue;
                enabled = true;
                break;
            }
        }
        return enabled;
    }

    private static Collection<Float> getTimelineServiceVersions(Configuration conf) {
        String versions = conf.get(TIMELINE_SERVICE_VERSIONS);
        if (versions == null) {
            versions = Float.toString(YarnConfiguration.getTimelineServiceVersion(conf));
        }
        List<String> stringList = Arrays.asList(versions.split(","));
        ArrayList<Float> floatList = new ArrayList<Float>();
        for (String s : stringList) {
            Float f = Float.valueOf(Float.parseFloat(s));
            floatList.add(f);
        }
        return floatList;
    }

    public static boolean systemMetricsPublisherEnabled(Configuration conf) {
        return conf.getBoolean(SYSTEM_METRICS_PUBLISHER_ENABLED, false);
    }

    public static boolean numaAwarenessEnabled(Configuration conf) {
        return conf.getBoolean(NM_NUMA_AWARENESS_ENABLED, false);
    }

    public static void main(String[] args) throws Exception {
        new YarnConfiguration(new Configuration()).writeXml(System.out);
    }

    static {
        YarnConfiguration.addDeprecatedKeys();
        Configuration.addDefaultResource(YARN_DEFAULT_CONFIGURATION_FILE);
        Configuration.addDefaultResource(YARN_SITE_CONFIGURATION_FILE);
        Configuration.addDefaultResource(RESOURCE_TYPES_CONFIGURATION_FILE);
        RM_SERVICES_ADDRESS_CONF_KEYS_HTTP = Collections.unmodifiableList(Arrays.asList(RM_ADDRESS, RM_SCHEDULER_ADDRESS, RM_ADMIN_ADDRESS, RM_RESOURCE_TRACKER_ADDRESS, RM_WEBAPP_ADDRESS));
        RM_SERVICES_ADDRESS_CONF_KEYS_HTTPS = Collections.unmodifiableList(Arrays.asList(RM_ADDRESS, RM_SCHEDULER_ADDRESS, RM_ADMIN_ADDRESS, RM_RESOURCE_TRACKER_ADDRESS, RM_WEBAPP_HTTPS_ADDRESS));
        DEFAULT_NM_ENV_WHITELIST = StringUtils.join((CharSequence)",", Arrays.asList(ApplicationConstants.Environment.JAVA_HOME.key(), ApplicationConstants.Environment.HADOOP_COMMON_HOME.key(), ApplicationConstants.Environment.HADOOP_HDFS_HOME.key(), ApplicationConstants.Environment.HADOOP_CONF_DIR.key(), ApplicationConstants.Environment.CLASSPATH_PREPEND_DISTCACHE.key(), ApplicationConstants.Environment.HADOOP_YARN_HOME.key()));
        DEFAULT_LINUX_CONTAINER_RUNTIME_ALLOWED_RUNTIMES = new String[]{DEFAULT_QUEUE_NAME};
        DEFAULT_NM_DOCKER_CONTAINER_CAPABILITIES = new String[]{"CHOWN", "DAC_OVERRIDE", "FSETID", "FOWNER", "MKNOD", "NET_RAW", "SETGID", "SETUID", "SETFCAP", "SETPCAP", "NET_BIND_SERVICE", "SYS_CHROOT", "KILL", "AUDIT_WRITE"};
        DEFAULT_NM_DOCKER_ALLOWED_CONTAINER_NETWORKS = new String[]{DEFAULT_NM_DOCKER_DEFAULT_CONTAINER_NETWORK, "none", "bridge"};
        DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH = new String[]{ApplicationConstants.Environment.HADOOP_CONF_DIR.$$(), ApplicationConstants.Environment.HADOOP_COMMON_HOME.$$() + "/share/hadoop/common/*", ApplicationConstants.Environment.HADOOP_COMMON_HOME.$$() + "/share/hadoop/common/lib/*", ApplicationConstants.Environment.HADOOP_HDFS_HOME.$$() + "/share/hadoop/hdfs/*", ApplicationConstants.Environment.HADOOP_HDFS_HOME.$$() + "/share/hadoop/hdfs/lib/*", ApplicationConstants.Environment.HADOOP_YARN_HOME.$$() + "/share/hadoop/yarn/*", ApplicationConstants.Environment.HADOOP_YARN_HOME.$$() + "/share/hadoop/yarn/lib/*"};
        DEFAULT_YARN_APPLICATION_CLASSPATH = new String[]{ApplicationConstants.Environment.HADOOP_CONF_DIR.$(), ApplicationConstants.Environment.HADOOP_COMMON_HOME.$() + "/share/hadoop/common/*", ApplicationConstants.Environment.HADOOP_COMMON_HOME.$() + "/share/hadoop/common/lib/*", ApplicationConstants.Environment.HADOOP_HDFS_HOME.$() + "/share/hadoop/hdfs/*", ApplicationConstants.Environment.HADOOP_HDFS_HOME.$() + "/share/hadoop/hdfs/lib/*", ApplicationConstants.Environment.HADOOP_YARN_HOME.$() + "/share/hadoop/yarn/*", ApplicationConstants.Environment.HADOOP_YARN_HOME.$() + "/share/hadoop/yarn/lib/*"};
        DEFAULT_TIMELINE_SERVICE_READ_AUTH_ENABLED = false;
        YARN_HTTP_POLICY_DEFAULT = HttpConfig.Policy.HTTP_ONLY.name();
    }
}

