/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public abstract class TestConfigurationFieldsBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestConfigurationFieldsBase.class);
    private static final Logger LOG_CONFIG = LoggerFactory.getLogger((String)"org.apache.hadoop.conf.TestConfigurationFieldsBase.config");
    private static final Logger LOG_XML = LoggerFactory.getLogger((String)"org.apache.hadoop.conf.TestConfigurationFieldsBase.xml");
    protected String xmlFilename = null;
    protected Class[] configurationClasses = null;
    protected boolean errorIfMissingConfigProps = false;
    protected boolean errorIfMissingXmlProps = false;
    protected Set<String> configurationPropsToSkipCompare = new HashSet<String>();
    protected Set<String> configurationPrefixToSkipCompare = new HashSet<String>();
    protected Set<String> xmlPropsToSkipCompare = new HashSet<String>();
    protected Set<String> xmlPrefixToSkipCompare = new HashSet<String>();
    private Map<String, String> configurationMemberVariables = null;
    private Map<String, String> configurationDefaultVariables = null;
    private Map<String, String> xmlKeyValueMap = null;
    private Set<String> configurationFieldsMissingInXmlFile = null;
    private Set<String> xmlFieldsMissingInConfiguration = null;
    protected Set<String> filtersForDefaultValueCollisionCheck = new HashSet<String>();

    public abstract void initializeMemberVariables();

    private HashMap<String, String> extractMemberVariablesFromConfigurationFields(Field[] fields) {
        if (fields == null) {
            return null;
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        String propRegex = "^[A-Za-z][A-Za-z0-9_-]+(\\.[A-Za-z0-9_-]+)+$";
        Pattern p = Pattern.compile(propRegex);
        for (Field f : fields) {
            String value;
            LOG_CONFIG.debug("Field: {}", (Object)f);
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !f.getType().getName().equals("java.lang.String") || TestConfigurationFieldsBase.isFieldADefaultValue(f)) continue;
            try {
                value = (String)f.get(null);
            }
            catch (IllegalAccessException iaException) {
                continue;
            }
            LOG_CONFIG.debug("  Value: {}", (Object)value);
            if (value.endsWith(".xml") || value.endsWith(".") || value.endsWith("-") || this.configurationPropsToSkipCompare.contains(value)) continue;
            boolean skipPrefix = false;
            for (String cfgPrefix : this.configurationPrefixToSkipCompare) {
                if (!value.startsWith(cfgPrefix)) continue;
                skipPrefix = true;
                break;
            }
            if (skipPrefix) continue;
            Matcher m = p.matcher(value);
            if (!m.find()) {
                LOG_CONFIG.debug("  Passes Regex: false");
                continue;
            }
            LOG_CONFIG.debug("  Passes Regex: true");
            if (!retVal.containsKey(value)) {
                retVal.put(value, f.getName());
                continue;
            }
            LOG_CONFIG.debug("ERROR: Already found key for property " + value);
        }
        return retVal;
    }

    private HashMap<String, String> extractPropertiesFromXml(String filename) {
        if (filename == null) {
            return null;
        }
        Configuration conf = new Configuration(false);
        conf.setAllowNullValueProperties(true);
        conf.addResource(filename);
        HashMap<String, String> retVal = new HashMap<String, String>();
        Iterator kvItr = conf.iterator();
        while (kvItr.hasNext()) {
            Map.Entry entry = (Map.Entry)kvItr.next();
            String key = (String)entry.getKey();
            if (this.xmlPropsToSkipCompare.contains(key)) {
                LOG_XML.debug("  Skipping Full Key: {}", (Object)key);
                continue;
            }
            if (this.xmlPrefixToSkipCompare.stream().anyMatch(key::startsWith)) {
                LOG_XML.debug("  Skipping Prefix Key: " + key);
                continue;
            }
            if (conf.onlyKeyExists(key)) {
                retVal.put(key, null);
                LOG_XML.debug("  XML Key,Null Value: " + key);
            } else if (conf.get(key) != null) {
                retVal.put(key, (String)entry.getValue());
                LOG_XML.debug("  XML Key,Valid Value: " + key);
            }
            kvItr.remove();
        }
        return retVal;
    }

    private static boolean isFieldADefaultValue(Field field) {
        return field.getName().startsWith("DEFAULT_") || field.getName().endsWith("_DEFAULT");
    }

    private HashMap<String, String> extractDefaultVariablesFromConfigurationFields(Field[] fields) {
        if (fields == null) {
            return null;
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        String propRegex = "^[A-Za-z][A-Za-z0-9_-]+(\\.[A-Za-z0-9_-]+)+$";
        Pattern p = Pattern.compile(propRegex);
        boolean totalFields = false;
        for (Field f : fields) {
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !TestConfigurationFieldsBase.isFieldADefaultValue(f) || retVal.containsKey(f.getName())) continue;
            try {
                if (f.getType().getName().equals("java.lang.String")) {
                    String sValue = (String)f.get(null);
                    retVal.put(f.getName(), sValue);
                    continue;
                }
                if (f.getType().getName().equals("short")) {
                    short shValue = (Short)f.get(null);
                    retVal.put(f.getName(), Integer.toString(shValue));
                    continue;
                }
                if (f.getType().getName().equals("int")) {
                    int iValue = (Integer)f.get(null);
                    retVal.put(f.getName(), Integer.toString(iValue));
                    continue;
                }
                if (f.getType().getName().equals("long")) {
                    long lValue = (Long)f.get(null);
                    retVal.put(f.getName(), Long.toString(lValue));
                    continue;
                }
                if (f.getType().getName().equals("float")) {
                    float fValue = ((Float)f.get(null)).floatValue();
                    retVal.put(f.getName(), Float.toString(fValue));
                    continue;
                }
                if (f.getType().getName().equals("double")) {
                    double dValue = (Double)f.get(null);
                    retVal.put(f.getName(), Double.toString(dValue));
                    continue;
                }
                if (f.getType().getName().equals("boolean")) {
                    boolean bValue = (Boolean)f.get(null);
                    retVal.put(f.getName(), Boolean.toString(bValue));
                    continue;
                }
                LOG.debug("Config variable {} has unknown type {}", (Object)f.getName(), (Object)f.getType().getName());
            }
            catch (IllegalAccessException iaException) {
                LOG.error("{}", (Object)f, (Object)iaException);
            }
        }
        return retVal;
    }

    private static Set<String> compareConfigurationToXmlFields(Map<String, String> keyMap1, Map<String, String> keyMap2) {
        HashSet<String> retVal = new HashSet<String>(keyMap1.keySet());
        retVal.removeAll(keyMap2.keySet());
        return retVal;
    }

    @Before
    public void setupTestConfigurationFields() throws Exception {
        this.initializeMemberVariables();
        Assert.assertNotNull((Object)this.xmlFilename);
        Assert.assertNotNull((Object)this.configurationClasses);
        this.configurationMemberVariables = new HashMap<String, String>();
        LOG_CONFIG.debug("Reading configuration classes\n");
        for (Class c : this.configurationClasses) {
            Field[] fields = c.getDeclaredFields();
            HashMap<String, String> memberMap = this.extractMemberVariablesFromConfigurationFields(fields);
            if (memberMap == null) continue;
            this.configurationMemberVariables.putAll(memberMap);
        }
        LOG_CONFIG.debug("\n=====\n");
        LOG_XML.debug("Reading XML property files\n");
        this.xmlKeyValueMap = this.extractPropertiesFromXml(this.xmlFilename);
        LOG_XML.debug("\n=====\n");
        LOG.debug("Reading Config property files for defaults\n");
        this.configurationDefaultVariables = new HashMap<String, String>();
        Arrays.stream(this.configurationClasses).map(Class::getDeclaredFields).map(this::extractDefaultVariablesFromConfigurationFields).filter(Objects::nonNull).forEach(map -> this.configurationDefaultVariables.putAll((Map<String, String>)map));
        LOG.debug("\n=====\n");
        this.configurationFieldsMissingInXmlFile = TestConfigurationFieldsBase.compareConfigurationToXmlFields(this.configurationMemberVariables, this.xmlKeyValueMap);
        this.xmlFieldsMissingInConfiguration = TestConfigurationFieldsBase.compareConfigurationToXmlFields(this.xmlKeyValueMap, this.configurationMemberVariables);
    }

    @Test
    public void testCompareConfigurationClassAgainstXml() {
        Assert.assertNotNull((Object)this.xmlFilename);
        Assert.assertNotNull((Object)this.configurationClasses);
        int missingXmlSize = this.configurationFieldsMissingInXmlFile.size();
        for (Class c : this.configurationClasses) {
            LOG.info(c.toString());
        }
        LOG.info("({} member variables)\n", (Object)this.configurationMemberVariables.size());
        StringBuilder xmlErrorMsg = new StringBuilder();
        for (Class c : this.configurationClasses) {
            xmlErrorMsg.append(c);
            xmlErrorMsg.append(" ");
        }
        xmlErrorMsg.append("has ");
        xmlErrorMsg.append(missingXmlSize);
        xmlErrorMsg.append(" variables missing in ");
        xmlErrorMsg.append(this.xmlFilename);
        LOG.error(xmlErrorMsg.toString());
        if (missingXmlSize == 0) {
            LOG.info("  (None)");
        } else {
            this.appendMissingEntries(xmlErrorMsg, this.configurationFieldsMissingInXmlFile);
        }
        LOG.info("\n=====\n");
        if (this.errorIfMissingXmlProps) {
            Assert.assertEquals((String)xmlErrorMsg.toString(), (long)0L, (long)missingXmlSize);
        }
    }

    private void appendMissingEntries(StringBuilder sb, Set<String> missing) {
        sb.append(" Entries: ");
        new TreeSet<String>(missing).forEach(s -> {
            LOG.info("  {}", s);
            sb.append("  ").append((String)s);
        });
    }

    @Test
    public void testCompareXmlAgainstConfigurationClass() {
        Assert.assertNotNull((Object)this.xmlFilename);
        Assert.assertNotNull((Object)this.configurationClasses);
        int missingConfigSize = this.xmlFieldsMissingInConfiguration.size();
        LOG.info("File {} ({} properties)", (Object)this.xmlFilename, (Object)this.xmlKeyValueMap.size());
        StringBuilder configErrorMsg = new StringBuilder();
        configErrorMsg.append(this.xmlFilename);
        configErrorMsg.append(" has ");
        configErrorMsg.append(missingConfigSize);
        configErrorMsg.append(" properties missing in");
        Arrays.stream(this.configurationClasses).forEach(c -> configErrorMsg.append("  ").append(c));
        LOG.info(configErrorMsg.toString());
        if (missingConfigSize == 0) {
            LOG.info("  (None)");
        } else {
            this.appendMissingEntries(configErrorMsg, this.xmlFieldsMissingInConfiguration);
        }
        LOG.info("\n=====\n");
        if (this.errorIfMissingConfigProps) {
            Assert.assertEquals((String)configErrorMsg.toString(), (long)0L, (long)missingConfigSize);
        }
    }

    @Test
    public void testXmlAgainstDefaultValuesInConfigurationClass() {
        Assert.assertNotNull((Object)this.xmlFilename);
        Assert.assertNotNull(this.configurationMemberVariables);
        Assert.assertNotNull(this.configurationDefaultVariables);
        TreeSet<String> xmlPropertiesWithEmptyValue = new TreeSet<String>();
        TreeSet<String> configPropertiesWithNoDefaultConfig = new TreeSet<String>();
        HashMap<String, String> xmlPropertiesMatchingConfigDefault = new HashMap<String, String>();
        HashMap mismatchingXmlConfig = new HashMap();
        for (Map.Entry<String, String> entry : this.xmlKeyValueMap.entrySet()) {
            String xmlProperty = entry.getKey();
            String xmlDefaultValue = entry.getValue();
            String configProperty = this.configurationMemberVariables.get(xmlProperty);
            if (configProperty == null) continue;
            String defaultConfigName = null;
            String defaultConfigValue = null;
            String defaultNameCheck1 = "DEFAULT_" + configProperty;
            String defaultValueCheck1 = this.configurationDefaultVariables.get(defaultNameCheck1);
            String defaultNameCheck2 = null;
            if (configProperty.endsWith("_KEY")) {
                defaultNameCheck2 = configProperty.substring(0, configProperty.length() - 4) + "_DEFAULT";
            }
            String defaultValueCheck2 = this.configurationDefaultVariables.get(defaultNameCheck2);
            String defaultNameCheck3 = configProperty + "_DEFAULT";
            String defaultValueCheck3 = this.configurationDefaultVariables.get(defaultNameCheck3);
            if (defaultValueCheck1 != null) {
                defaultConfigName = defaultNameCheck1;
                defaultConfigValue = defaultValueCheck1;
            } else if (defaultValueCheck2 != null) {
                defaultConfigName = defaultNameCheck2;
                defaultConfigValue = defaultValueCheck2;
            } else if (defaultValueCheck3 != null) {
                defaultConfigName = defaultNameCheck3;
                defaultConfigValue = defaultValueCheck3;
            }
            if (defaultConfigValue != null) {
                if (xmlDefaultValue == null) {
                    xmlPropertiesWithEmptyValue.add(xmlProperty);
                    continue;
                }
                if (!xmlDefaultValue.equals(defaultConfigValue)) {
                    HashMap<String, String> xmlEntry = new HashMap<String, String>();
                    xmlEntry.put(xmlProperty, xmlDefaultValue);
                    HashMap<String, String> configEntry = new HashMap<String, String>();
                    configEntry.put(defaultConfigName, defaultConfigValue);
                    mismatchingXmlConfig.put(xmlEntry, configEntry);
                    continue;
                }
                xmlPropertiesMatchingConfigDefault.put(xmlProperty, defaultConfigName);
                continue;
            }
            configPropertiesWithNoDefaultConfig.add(configProperty);
        }
        LOG.info("{} has {} properties that do not match the default Config value", (Object)this.xmlFilename, (Object)mismatchingXmlConfig.size());
        if (mismatchingXmlConfig.isEmpty()) {
            LOG.info("  (None)");
        } else {
            for (Map.Entry<String, String> entry : mismatchingXmlConfig.entrySet()) {
                ((HashMap)((Object)entry.getKey())).forEach((key, value) -> {
                    LOG.info("XML Property: {}", key);
                    LOG.info("XML Value:    {}", value);
                });
                ((HashMap)((Object)entry.getValue())).forEach((key, value) -> {
                    LOG.info("Config Name:  {}", key);
                    LOG.info("Config Value: {}", value);
                });
                LOG.info("");
            }
        }
        LOG.info("\n");
        LOG.info("Configuration(s) have {}  properties with no corresponding default member variable.  These will need to be verified manually.", (Object)configPropertiesWithNoDefaultConfig.size());
        if (configPropertiesWithNoDefaultConfig.isEmpty()) {
            LOG.info("  (None)");
        } else {
            configPropertiesWithNoDefaultConfig.forEach(c -> LOG.info(" {}", c));
        }
        LOG.info("\n");
        LOG.info("{} has {} properties with empty values", (Object)this.xmlFilename, (Object)xmlPropertiesWithEmptyValue.size());
        if (xmlPropertiesWithEmptyValue.isEmpty()) {
            LOG.info("  (None)");
        } else {
            xmlPropertiesWithEmptyValue.forEach(p -> LOG.info("  {}", p));
        }
        LOG.info("\n");
        LOG.info("{} has {} properties which match a corresponding Config variable", (Object)this.xmlFilename, (Object)xmlPropertiesMatchingConfigDefault.size());
        if (xmlPropertiesMatchingConfigDefault.isEmpty()) {
            LOG.info("  (None)");
        } else {
            xmlPropertiesMatchingConfigDefault.forEach((key, value) -> LOG.info("  {} / {}", key, value));
        }
        LOG.info("\n=====\n");
    }

    @Test
    public void testDefaultValueCollision() {
        for (String filter : this.filtersForDefaultValueCollisionCheck) {
            LOG.info("Checking if any of the default values whose name contains string \"{}\" collide.", (Object)filter);
            HashMap<String, String> filteredValues = new HashMap<String, String>();
            int valuesChecked = 0;
            for (Map.Entry<String, String> ent : this.configurationDefaultVariables.entrySet()) {
                if (!ent.getKey().contains(filter)) continue;
                if (StringUtils.isNumeric((String)ent.getValue())) {
                    String crtValue = filteredValues.putIfAbsent(ent.getValue(), ent.getKey());
                    Assert.assertNull((String)("Parameters " + ent.getKey() + " and " + crtValue + " are using the same default value!"), (Object)crtValue);
                }
                ++valuesChecked;
            }
            LOG.info("Checked {} default values for collision.", (Object)valuesChecked);
        }
    }
}

