/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec;
import org.apache.hadoop.crypto.TestCryptoStreams;
import org.apache.hadoop.crypto.random.OsSecureRandom;
import org.apache.hadoop.fs.CommonConfigurationKeysPublic;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestCryptoStreamsWithOpensslAesCtrCryptoCodec
extends TestCryptoStreams {
    @BeforeClass
    public static void init() throws Exception {
        GenericTestUtils.assumeInNativeProfile();
        Configuration conf = new Configuration();
        conf.set(CommonConfigurationKeysPublic.HADOOP_SECURITY_CRYPTO_CODEC_CLASSES_AES_CTR_NOPADDING_KEY, OpensslAesCtrCryptoCodec.class.getName());
        codec = CryptoCodec.getInstance((Configuration)conf);
        Assert.assertNotNull((String)("Unable to instantiate codec " + OpensslAesCtrCryptoCodec.class.getName() + ", is the required version of OpenSSL installed?"), (Object)codec);
        Assert.assertEquals((Object)OpensslAesCtrCryptoCodec.class.getCanonicalName(), (Object)codec.getClass().getCanonicalName());
    }

    @Test
    public void testCodecClosesRandom() throws Exception {
        GenericTestUtils.assumeInNativeProfile();
        Configuration conf = new Configuration();
        conf.set(CommonConfigurationKeysPublic.HADOOP_SECURITY_CRYPTO_CODEC_CLASSES_AES_CTR_NOPADDING_KEY, OpensslAesCtrCryptoCodec.class.getName());
        conf.set("hadoop.security.secure.random.impl", OsSecureRandom.class.getName());
        CryptoCodec codecWithRandom = CryptoCodec.getInstance((Configuration)conf);
        Assert.assertNotNull((String)("Unable to instantiate codec " + OpensslAesCtrCryptoCodec.class.getName() + ", is the required version of OpenSSL installed?"), (Object)codecWithRandom);
        OsSecureRandom random = (OsSecureRandom)Whitebox.getInternalState((Object)codecWithRandom, (String)"random");
        random.nextBytes(new byte[10]);
        Assert.assertNotNull((Object)Whitebox.getInternalState((Object)random, (String)"stream"));
        codecWithRandom.close();
        Assert.assertNull((Object)Whitebox.getInternalState((Object)random, (String)"stream"));
    }
}

