/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.LayoutFlags;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.HttpGetFailedException;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.base.Throwables;
import org.apache.hadoop.shaded.com.google.protobuf.ByteString;

@InterfaceAudience.Private
public class EditLogFileInputStream
extends EditLogInputStream {
    private final LogSource log;
    private final long firstTxId;
    private final long lastTxId;
    private final boolean isInProgress;
    private int maxOpSize;
    private State state = State.UNINIT;
    private InputStream fStream = null;
    private int logVersion = 0;
    private FSEditLogOp.Reader reader = null;
    private FSEditLogLoader.PositionTrackingInputStream tracker = null;
    private DataInputStream dataIn = null;
    static final Log LOG = LogFactory.getLog(EditLogInputStream.class);

    EditLogFileInputStream(File name) throws LogHeaderCorruptException, IOException {
        this(name, -12345L, -12345L, false);
    }

    public EditLogFileInputStream(File name, long firstTxId, long lastTxId, boolean isInProgress) {
        this(new FileLog(name), firstTxId, lastTxId, isInProgress);
    }

    public static EditLogInputStream fromUrl(URLConnectionFactory connectionFactory, URL url, long startTxId, long endTxId, boolean inProgress) {
        return new EditLogFileInputStream(new URLLog(connectionFactory, url), startTxId, endTxId, inProgress);
    }

    public static EditLogInputStream fromByteString(ByteString bytes, long startTxId, long endTxId, boolean inProgress) {
        return new EditLogFileInputStream(new ByteStringLog(bytes, String.format("ByteStringEditLog[%d, %d]", startTxId, endTxId)), startTxId, endTxId, inProgress);
    }

    private EditLogFileInputStream(LogSource log, long firstTxId, long lastTxId, boolean isInProgress) {
        this.log = log;
        this.firstTxId = firstTxId;
        this.lastTxId = lastTxId;
        this.isInProgress = isInProgress;
        this.maxOpSize = 0x3200000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(boolean verifyLayoutVersion) throws LogHeaderCorruptException, IOException {
        Preconditions.checkState((this.state == State.UNINIT ? 1 : 0) != 0);
        BufferedInputStream bin = null;
        try {
            this.fStream = this.log.getInputStream();
            bin = new BufferedInputStream(this.fStream);
            this.tracker = new FSEditLogLoader.PositionTrackingInputStream(bin);
            this.dataIn = new DataInputStream(this.tracker);
            try {
                this.logVersion = EditLogFileInputStream.readLogVersion(this.dataIn, verifyLayoutVersion);
            }
            catch (EOFException eofe) {
                throw new LogHeaderCorruptException("No header found in log");
            }
            if (this.logVersion == -1) {
                throw new LogHeaderCorruptException("No header present in log (value is -1), probably due to disk space issues when it was created. The log has no transactions and will be sidelined.");
            }
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_LAYOUT_FLAGS, this.logVersion) || this.logVersion < NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION) {
                try {
                    LayoutFlags.read(this.dataIn);
                }
                catch (EOFException eofe) {
                    throw new LogHeaderCorruptException("EOF while reading layout flags from log");
                }
            }
            this.reader = FSEditLogOp.Reader.create(this.dataIn, this.tracker, this.logVersion);
            this.reader.setMaxOpSize(this.maxOpSize);
            this.state = State.OPEN;
            if (this.reader != null) return;
        }
        catch (Throwable throwable) {
            if (this.reader != null) throw throwable;
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dataIn, this.tracker, bin, this.fStream});
            this.state = State.CLOSED;
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dataIn, this.tracker, bin, this.fStream});
        this.state = State.CLOSED;
    }

    @Override
    public long getFirstTxId() {
        return this.firstTxId;
    }

    @Override
    public long getLastTxId() {
        return this.lastTxId;
    }

    @Override
    public String getName() {
        return this.log.getName();
    }

    private FSEditLogOp nextOpImpl(boolean skipBrokenEdits) throws IOException {
        FSEditLogOp op = null;
        switch (this.state) {
            case UNINIT: {
                try {
                    this.init(true);
                }
                catch (Throwable e) {
                    LOG.error((Object)("caught exception initializing " + this), e);
                    if (skipBrokenEdits) {
                        return null;
                    }
                    Throwables.propagateIfPossible((Throwable)e, IOException.class);
                }
                Preconditions.checkState((this.state != State.UNINIT ? 1 : 0) != 0);
                return this.nextOpImpl(skipBrokenEdits);
            }
            case OPEN: {
                long skipAmt;
                long txId;
                op = this.reader.readOp(skipBrokenEdits);
                if (op == null || !op.hasTransactionId() || (txId = op.getTransactionId()) < this.lastTxId || this.lastTxId == -12345L || (skipAmt = this.log.length() - this.tracker.getPos()) <= 0L) break;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("skipping " + skipAmt + " bytes at the end of edit log  '" + this.getName() + "': reached txid " + txId + " out of " + this.lastTxId));
                }
                this.tracker.clearLimit();
                IOUtils.skipFully((InputStream)this.tracker, (long)skipAmt);
                break;
            }
        }
        return op;
    }

    @Override
    protected long scanNextOp() throws IOException {
        Preconditions.checkState((this.state == State.OPEN ? 1 : 0) != 0);
        FSEditLogOp cachedNext = this.getCachedOp();
        return cachedNext == null ? this.reader.scanOp() : cachedNext.txid;
    }

    @Override
    protected FSEditLogOp nextOp() throws IOException {
        return this.nextOpImpl(false);
    }

    @Override
    protected FSEditLogOp nextValidOp() {
        try {
            return this.nextOpImpl(true);
        }
        catch (Throwable e) {
            LOG.error((Object)("nextValidOp: got exception while reading " + this), e);
            return null;
        }
    }

    @Override
    public int getVersion(boolean verifyVersion) throws IOException {
        if (this.state == State.UNINIT) {
            this.init(verifyVersion);
        }
        return this.logVersion;
    }

    @Override
    public long getPosition() {
        if (this.state == State.OPEN) {
            return this.tracker.getPos();
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
        if (this.state == State.OPEN) {
            this.dataIn.close();
        }
        this.state = State.CLOSED;
    }

    @Override
    public long length() throws IOException {
        return this.log.length();
    }

    @Override
    public boolean isInProgress() {
        return this.isInProgress;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FSEditLogLoader.EditLogValidation scanEditLog(File file, long maxTxIdToScan, boolean verifyVersion) throws IOException {
        EditLogFileInputStream in;
        try {
            in = new EditLogFileInputStream(file);
            in.getVersion(verifyVersion);
        }
        catch (LogHeaderCorruptException e) {
            LOG.warn((Object)("Log file " + file + " has no valid header"), (Throwable)e);
            return new FSEditLogLoader.EditLogValidation(0L, -12345L, true);
        }
        try {
            FSEditLogLoader.EditLogValidation editLogValidation = FSEditLogLoader.scanEditLog(in, maxTxIdToScan);
            return editLogValidation;
        }
        finally {
            IOUtils.closeStream((Closeable)in);
        }
    }

    @VisibleForTesting
    static int readLogVersion(DataInputStream in, boolean verifyLayoutVersion) throws IOException, LogHeaderCorruptException {
        int logVersion;
        try {
            logVersion = in.readInt();
        }
        catch (EOFException eofe) {
            throw new LogHeaderCorruptException("Reached EOF when reading log header");
        }
        if (verifyLayoutVersion && (logVersion < HdfsServerConstants.NAMENODE_LAYOUT_VERSION || logVersion > -16)) {
            throw new LogHeaderCorruptException("Unexpected version of the file system log file: " + logVersion + ". Current version = " + HdfsServerConstants.NAMENODE_LAYOUT_VERSION + ".");
        }
        return logVersion;
    }

    @Override
    public void setMaxOpSize(int maxOpSize) {
        this.maxOpSize = maxOpSize;
        if (this.reader != null) {
            this.reader.setMaxOpSize(maxOpSize);
        }
    }

    @Override
    public boolean isLocalLog() {
        return this.log instanceof FileLog;
    }

    private static class URLLog
    implements LogSource {
        private final URL url;
        private long advertisedSize = -1L;
        private static final String CONTENT_LENGTH = "Content-Length";
        private final URLConnectionFactory connectionFactory;
        private final boolean isSpnegoEnabled;

        public URLLog(URLConnectionFactory connectionFactory, URL url) {
            this.connectionFactory = connectionFactory;
            this.isSpnegoEnabled = UserGroupInformation.isSecurityEnabled();
            this.url = url;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return (InputStream)SecurityUtil.doAsCurrentUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    HttpURLConnection connection;
                    try {
                        connection = (HttpURLConnection)connectionFactory.openConnection(url, isSpnegoEnabled);
                    }
                    catch (AuthenticationException e) {
                        throw new IOException(e);
                    }
                    if (connection.getResponseCode() != 200) {
                        throw new HttpGetFailedException("Fetch of " + url + " failed with status code " + connection.getResponseCode() + "\nResponse message:\n" + connection.getResponseMessage(), connection);
                    }
                    String contentLength = connection.getHeaderField(URLLog.CONTENT_LENGTH);
                    if (contentLength != null) {
                        advertisedSize = Long.parseLong(contentLength);
                        if (advertisedSize <= 0L) {
                            throw new IOException("Invalid Content-Length header: " + contentLength);
                        }
                    } else {
                        throw new IOException("Content-Length header is not provided by the server when trying to fetch " + url);
                    }
                    return connection.getInputStream();
                }
            });
        }

        @Override
        public long length() {
            return this.advertisedSize;
        }

        @Override
        public String getName() {
            return this.url.toString();
        }
    }

    private static class FileLog
    implements LogSource {
        private final File file;

        public FileLog(File file) {
            this.file = file;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public String getName() {
            return this.file.getPath();
        }
    }

    private static class ByteStringLog
    implements LogSource {
        private final ByteString bytes;
        private final String name;

        public ByteStringLog(ByteString bytes, String name) {
            this.bytes = bytes;
            this.name = name;
        }

        @Override
        public InputStream getInputStream() {
            return this.bytes.newInput();
        }

        @Override
        public long length() {
            return this.bytes.size();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static interface LogSource {
        public InputStream getInputStream() throws IOException;

        public long length();

        public String getName();
    }

    static class LogHeaderCorruptException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private LogHeaderCorruptException(String msg) {
            super(msg);
        }
    }

    private static enum State {
        UNINIT,
        OPEN,
        CLOSED;

    }
}

