/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.DirectoryListingStartAfterNotFoundException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSDirEncryptionZoneOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirErasureCodingOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectorySnapshottableFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.util.Time;

class FSDirStatAndListingOp {
    FSDirStatAndListingOp() {
    }

    static DirectoryListing getListingInt(FSDirectory fsd, FSPermissionChecker pc, String srcArg, byte[] startAfter, boolean needLocation) throws IOException {
        String startAfterString;
        INodesInPath iip = fsd.resolvePath(pc, srcArg, FSDirectory.DirOp.READ);
        if (startAfter.length > 0 && startAfter[0] == 47 && FSDirectory.isReservedName(startAfterString = DFSUtil.bytes2String(startAfter))) {
            try {
                byte[][] components = INode.getPathComponents(startAfterString);
                components = FSDirectory.resolveComponents(components, fsd);
                startAfter = components[components.length - 1];
            }
            catch (IOException e) {
                throw new DirectoryListingStartAfterNotFoundException("Can't find startAfter " + startAfterString);
            }
        }
        boolean isSuperUser = true;
        if (fsd.isPermissionEnabled()) {
            if (iip.getLastINode() != null && iip.getLastINode().isDirectory()) {
                fsd.checkPathAccess(pc, iip, FsAction.READ_EXECUTE);
            }
            isSuperUser = pc.isSuperUser();
        }
        return FSDirStatAndListingOp.getListing(fsd, iip, startAfter, needLocation, isSuperUser);
    }

    static HdfsFileStatus getFileInfo(FSDirectory fsd, FSPermissionChecker pc, String srcArg, boolean resolveLink, boolean needLocation, boolean needBlockToken) throws IOException {
        INodesInPath iip;
        FSDirectory.DirOp dirOp;
        FSDirectory.DirOp dirOp2 = dirOp = resolveLink ? FSDirectory.DirOp.READ : FSDirectory.DirOp.READ_LINK;
        if (pc.isSuperUser()) {
            try {
                iip = fsd.resolvePath(pc, srcArg, dirOp);
            }
            catch (AccessControlException ace) {
                return null;
            }
        } else {
            iip = fsd.resolvePath(pc, srcArg, dirOp);
        }
        return FSDirStatAndListingOp.getFileInfo(fsd, iip, needLocation, needBlockToken);
    }

    static boolean isFileClosed(FSDirectory fsd, FSPermissionChecker pc, String src) throws IOException {
        INodesInPath iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.READ);
        return !INodeFile.valueOf(iip.getLastINode(), src).isUnderConstruction();
    }

    static ContentSummary getContentSummary(FSDirectory fsd, FSPermissionChecker pc, String src) throws IOException {
        INodesInPath iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.READ_LINK);
        return FSDirStatAndListingOp.getContentSummaryInt(fsd, pc, iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GetBlockLocationsResult getBlockLocations(FSDirectory fsd, FSPermissionChecker pc, String src, long offset, long length, boolean needBlockToken) throws IOException {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)("Negative offset is not supported. File: " + src));
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)("Negative length is not supported. File: " + src));
        BlockManager bm = fsd.getBlockManager();
        fsd.readLock();
        try {
            INodesInPath iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.READ);
            src = iip.getPath();
            INodeFile inode = INodeFile.valueOf(iip.getLastINode(), src);
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.READ);
                fsd.checkUnreadableBySuperuser(pc, iip);
            }
            long fileSize = iip.isSnapshot() ? inode.computeFileSize(iip.getPathSnapshotId()) : inode.computeFileSizeNotIncludingLastUcBlock();
            boolean isUc = inode.isUnderConstruction();
            if (iip.isSnapshot()) {
                length = Math.min(length, fileSize - offset);
                isUc = false;
            }
            FileEncryptionInfo feInfo = FSDirEncryptionZoneOp.getFileEncryptionInfo(fsd, iip);
            ErasureCodingPolicy ecPolicy = FSDirErasureCodingOp.unprotectedGetErasureCodingPolicy(fsd.getFSNamesystem(), iip);
            LocatedBlocks blocks = bm.createLocatedBlocks(inode.getBlocks(iip.getPathSnapshotId()), fileSize, isUc, offset, length, needBlockToken, iip.isSnapshot(), feInfo, ecPolicy);
            long now = Time.now();
            boolean updateAccessTime = fsd.isAccessTimeSupported() && !iip.isSnapshot() && now > inode.getAccessTime() + fsd.getAccessTimePrecision();
            GetBlockLocationsResult getBlockLocationsResult = new GetBlockLocationsResult(updateAccessTime, blocks);
            return getBlockLocationsResult;
        }
        finally {
            fsd.readUnlock();
        }
    }

    private static byte getStoragePolicyID(byte inodePolicy, byte parentPolicy) {
        return inodePolicy != 0 ? inodePolicy : parentPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirectoryListing getListing(FSDirectory fsd, INodesInPath iip, byte[] startAfter, boolean needLocation, boolean includeStoragePolicy) throws IOException {
        if (FSDirectory.isExactReservedName(iip.getPathComponents())) {
            return FSDirStatAndListingOp.getReservedListing(fsd);
        }
        fsd.readLock();
        try {
            byte parentStoragePolicy;
            if (iip.isDotSnapshotDir()) {
                DirectoryListing directoryListing = FSDirStatAndListingOp.getSnapshotsListing(fsd, iip, startAfter);
                return directoryListing;
            }
            int snapshot = iip.getPathSnapshotId();
            INode targetNode = iip.getLastINode();
            if (targetNode == null) {
                DirectoryListing directoryListing = null;
                return directoryListing;
            }
            byte by = parentStoragePolicy = includeStoragePolicy ? targetNode.getStoragePolicyID() : (byte)0;
            if (!targetNode.isDirectory()) {
                DirectoryListing directoryListing = new DirectoryListing(new HdfsFileStatus[]{FSDirStatAndListingOp.createFileStatus(fsd, iip, null, parentStoragePolicy, needLocation, false)}, 0);
                return directoryListing;
            }
            INodeDirectory dirInode = targetNode.asDirectory();
            ReadOnlyList<INode> contents = dirInode.getChildrenList(snapshot);
            int startChild = INodeDirectory.nextChild(contents, startAfter);
            int totalNumChildren = contents.size();
            int numOfListing = Math.min(totalNumChildren - startChild, fsd.getLsLimit());
            int locationBudget = fsd.getLsLimit();
            int listingCnt = 0;
            HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
            for (int i = 0; i < numOfListing && locationBudget > 0; ++i) {
                INode child = contents.get(startChild + i);
                byte childStoragePolicy = includeStoragePolicy && !child.isSymlink() ? FSDirStatAndListingOp.getStoragePolicyID(child.getLocalStoragePolicyID(), parentStoragePolicy) : parentStoragePolicy;
                listing[i] = FSDirStatAndListingOp.createFileStatus(fsd, iip, child, childStoragePolicy, needLocation, false);
                ++listingCnt;
                if (!(listing[i] instanceof HdfsLocatedFileStatus)) continue;
                LocatedBlocks blks = ((HdfsLocatedFileStatus)listing[i]).getLocatedBlocks();
                locationBudget -= blks == null ? 0 : blks.locatedBlockCount() * listing[i].getReplication();
            }
            if (listingCnt < numOfListing) {
                listing = Arrays.copyOf(listing, listingCnt);
            }
            DirectoryListing directoryListing = new DirectoryListing(listing, totalNumChildren - startChild - listingCnt);
            return directoryListing;
        }
        finally {
            fsd.readUnlock();
        }
    }

    private static DirectoryListing getSnapshotsListing(FSDirectory fsd, INodesInPath iip, byte[] startAfter) throws IOException {
        Preconditions.checkState((boolean)fsd.hasReadLock());
        Preconditions.checkArgument((boolean)iip.isDotSnapshotDir(), (String)"%s does not end with %s", (Object)iip.getPath(), (Object)"/.snapshot");
        iip = iip.getParentINodesInPath();
        String dirPath = iip.getPath();
        INode node = iip.getLastINode();
        INodeDirectory dirNode = INodeDirectory.valueOf(node, dirPath);
        DirectorySnapshottableFeature sf = dirNode.getDirectorySnapshottableFeature();
        if (sf == null) {
            throw new SnapshotException("Directory is not a snapshottable directory: " + dirPath);
        }
        ReadOnlyList<Snapshot> snapshots = sf.getSnapshotList();
        int skipSize = ReadOnlyList.Util.binarySearch(snapshots, startAfter);
        skipSize = skipSize < 0 ? -skipSize - 1 : skipSize + 1;
        int numOfListing = Math.min(snapshots.size() - skipSize, fsd.getLsLimit());
        HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
        for (int i = 0; i < numOfListing; ++i) {
            Snapshot.Root sRoot = snapshots.get(i + skipSize).getRoot();
            listing[i] = FSDirStatAndListingOp.createFileStatus(fsd, iip, sRoot, (byte)0, false, false);
        }
        return new DirectoryListing(listing, snapshots.size() - skipSize - numOfListing);
    }

    private static DirectoryListing getReservedListing(FSDirectory fsd) {
        return new DirectoryListing(fsd.getReservedStatuses(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus getFileInfo(FSDirectory fsd, INodesInPath iip, boolean includeStoragePolicy, boolean needLocation, boolean needBlockToken) throws IOException {
        fsd.readLock();
        try {
            INode node = iip.getLastINode();
            if (node == null) {
                HdfsFileStatus hdfsFileStatus = null;
                return hdfsFileStatus;
            }
            byte policy = includeStoragePolicy && !node.isSymlink() ? node.getStoragePolicyID() : (byte)0;
            HdfsFileStatus hdfsFileStatus = FSDirStatAndListingOp.createFileStatus(fsd, iip, null, policy, needLocation, needBlockToken);
            return hdfsFileStatus;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus getFileInfo(FSDirectory fsd, INodesInPath iip, boolean needLocation, boolean needBlockToken) throws IOException {
        fsd.readLock();
        try {
            HdfsFileStatus status = null;
            if (FSDirectory.isExactReservedName(iip.getPathComponents())) {
                status = FSDirectory.DOT_RESERVED_STATUS;
            } else if (iip.isDotSnapshotDir()) {
                if (fsd.getINode4DotSnapshot(iip) != null) {
                    status = FSDirectory.DOT_SNAPSHOT_DIR_STATUS;
                }
            } else {
                status = FSDirStatAndListingOp.getFileInfo(fsd, iip, true, needLocation, needBlockToken);
            }
            HdfsFileStatus hdfsFileStatus = status;
            return hdfsFileStatus;
        }
        finally {
            fsd.readUnlock();
        }
    }

    static HdfsFileStatus createFileStatusForEditLog(FSDirectory fsd, INodesInPath iip) throws IOException {
        return FSDirStatAndListingOp.createFileStatus(fsd, iip, null, (byte)0, false, false);
    }

    private static HdfsFileStatus createFileStatus(FSDirectory fsd, INodesInPath iip, INode child, byte storagePolicy, boolean needLocation, boolean needBlockToken) throws IOException {
        boolean hasAcl;
        assert (fsd.hasReadLock());
        byte[] name = HdfsFileStatus.EMPTY_NAME;
        if (child != null) {
            name = child.getLocalNameBytes();
            iip = INodesInPath.append(iip, child, name);
        }
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        INode node = iip.getLastINode();
        int snapshot = iip.getPathSnapshotId();
        LocatedBlocks loc = null;
        boolean isEncrypted = FSDirEncryptionZoneOp.isInAnEZ(fsd, iip);
        FileEncryptionInfo feInfo = null;
        ErasureCodingPolicy ecPolicy = FSDirErasureCodingOp.unprotectedGetErasureCodingPolicy(fsd.getFSNamesystem(), iip);
        boolean isErasureCoded = ecPolicy != null;
        boolean isSnapShottable = false;
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            size = fileNode.computeFileSize(snapshot);
            replication = fileNode.getFileReplication(snapshot);
            blocksize = fileNode.getPreferredBlockSize();
            if (isEncrypted) {
                feInfo = FSDirEncryptionZoneOp.getFileEncryptionInfo(fsd, iip);
            }
            if (needLocation) {
                boolean inSnapshot = snapshot != 0x7FFFFFFE;
                boolean isUc = !inSnapshot && fileNode.isUnderConstruction();
                long fileSize = !inSnapshot && isUc ? fileNode.computeFileSizeNotIncludingLastUcBlock() : size;
                loc = fsd.getBlockManager().createLocatedBlocks(fileNode.getBlocks(snapshot), fileSize, isUc, 0L, size, needBlockToken, inSnapshot, feInfo, ecPolicy);
                if (loc == null) {
                    loc = new LocatedBlocks();
                }
            }
        } else if (node.isDirectory()) {
            isSnapShottable = node.asDirectory().isSnapshottable();
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum(snapshot) : 0;
        EnumSet<HdfsFileStatus.Flags> flags = EnumSet.noneOf(HdfsFileStatus.Flags.class);
        INodeAttributes nodeAttrs = fsd.getAttributes(iip);
        boolean bl = hasAcl = nodeAttrs.getAclFeature() != null;
        if (hasAcl) {
            flags.add(HdfsFileStatus.Flags.HAS_ACL);
        }
        if (isEncrypted) {
            flags.add(HdfsFileStatus.Flags.HAS_CRYPT);
        }
        if (isErasureCoded) {
            flags.add(HdfsFileStatus.Flags.HAS_EC);
        }
        if (isSnapShottable) {
            flags.add(HdfsFileStatus.Flags.SNAPSHOT_ENABLED);
        }
        return FSDirStatAndListingOp.createFileStatus(size, node.isDirectory(), replication, blocksize, node.getModificationTime(snapshot), node.getAccessTime(snapshot), nodeAttrs.getFsPermission(), flags, nodeAttrs.getUserName(), nodeAttrs.getGroupName(), node.isSymlink() ? node.asSymlink().getSymlink() : null, name, node.getId(), childrenNum, feInfo, storagePolicy, ecPolicy, loc);
    }

    private static HdfsFileStatus createFileStatus(long length, boolean isdir, int replication, long blocksize, long mtime, long atime, FsPermission permission, EnumSet<HdfsFileStatus.Flags> flags, String owner, String group, byte[] symlink, byte[] path, long fileId, int childrenNum, FileEncryptionInfo feInfo, byte storagePolicy, ErasureCodingPolicy ecPolicy, LocatedBlocks locations) {
        return new HdfsFileStatus.Builder().length(length).isdir(isdir).replication(replication).blocksize(blocksize).mtime(mtime).atime(atime).perm(permission).flags(flags).owner(owner).group(group).symlink(symlink).path(path).fileId(fileId).children(childrenNum).feInfo(feInfo).storagePolicy(storagePolicy).ecPolicy(ecPolicy).locations(locations).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContentSummary getContentSummaryInt(FSDirectory fsd, FSPermissionChecker pc, INodesInPath iip) throws IOException {
        fsd.readLock();
        try {
            INode targetNode = iip.getLastINode();
            if (targetNode == null) {
                throw new FileNotFoundException("File does not exist: " + iip.getPath());
            }
            ContentSummaryComputationContext cscc = new ContentSummaryComputationContext(fsd, fsd.getFSNamesystem(), fsd.getContentCountLimit(), fsd.getContentSleepMicroSec(), pc);
            ContentSummary cs = targetNode.computeAndConvertContentSummary(iip.getPathSnapshotId(), cscc);
            fsd.addYieldCount(cscc.getYieldCount());
            ContentSummary contentSummary = cs;
            return contentSummary;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static QuotaUsage getQuotaUsage(FSDirectory fsd, FSPermissionChecker pc, String src) throws IOException {
        INodesInPath iip;
        fsd.readLock();
        try {
            iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.READ_LINK);
            if (fsd.isPermissionEnabled()) {
                fsd.checkPermission(pc, iip, false, null, null, null, FsAction.READ_EXECUTE);
            }
        }
        finally {
            fsd.readUnlock();
        }
        QuotaUsage usage = FSDirStatAndListingOp.getQuotaUsageInt(fsd, iip);
        if (usage != null) {
            return usage;
        }
        return FSDirStatAndListingOp.getContentSummaryInt(fsd, pc, iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QuotaUsage getQuotaUsageInt(FSDirectory fsd, INodesInPath iip) throws IOException {
        fsd.readLock();
        try {
            DirectoryWithQuotaFeature feature;
            INode targetNode = iip.getLastINode();
            if (targetNode == null) {
                throw new FileNotFoundException("File/Directory does not exist: " + iip.getPath());
            }
            QuotaUsage usage = null;
            if (targetNode.isDirectory() && (feature = targetNode.asDirectory().getDirectoryWithQuotaFeature()) != null) {
                QuotaCounts counts = feature.getSpaceConsumed();
                QuotaCounts quotas = feature.getQuota();
                usage = new QuotaUsage.Builder().fileAndDirectoryCount(counts.getNameSpace()).quota(quotas.getNameSpace()).spaceConsumed(counts.getStorageSpace()).spaceQuota(quotas.getStorageSpace()).typeConsumed(counts.getTypeSpaces().asArray()).typeQuota(quotas.getTypeSpaces().asArray()).build();
            }
            QuotaUsage quotaUsage = usage;
            return quotaUsage;
        }
        finally {
            fsd.readUnlock();
        }
    }

    static class GetBlockLocationsResult {
        final boolean updateAccessTime;
        final LocatedBlocks blocks;

        boolean updateAccessTime() {
            return this.updateAccessTime;
        }

        private GetBlockLocationsResult(boolean updateAccessTime, LocatedBlocks blocks) {
            this.updateAccessTime = updateAccessTime;
            this.blocks = blocks;
        }
    }
}

