/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceContext;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceProcessor;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceUtils;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocolPB;
import org.apache.hadoop.yarn.api.impl.pb.service.ApplicationMasterProtocolPBServiceImpl;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.proto.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.DistributedSchedulingAMProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.DistributedSchedulingAllocateRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DistributedSchedulingAllocateResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterDistributedSchedulingAMResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoteNode;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.NodeQueueLoadMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.QueueLimitCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerAllocator;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.apache.hadoop.yarn.server.utils.YarnServerSecurityUtils;

public class OpportunisticContainerAllocatorAMService
extends ApplicationMasterService
implements DistributedSchedulingAMProtocol,
EventHandler<SchedulerEvent> {
    private static final Log LOG = LogFactory.getLog(OpportunisticContainerAllocatorAMService.class);
    private final NodeQueueLoadMonitor nodeMonitor;
    private final OpportunisticContainerAllocator oppContainerAllocator;
    private final int k;
    private final long cacheRefreshInterval;
    private volatile List<RemoteNode> cachedNodes;
    private volatile long lastCacheUpdateTime;

    public OpportunisticContainerAllocatorAMService(RMContext rmContext, YarnScheduler scheduler) {
        super(OpportunisticContainerAllocatorAMService.class.getName(), rmContext, scheduler);
        int limitMax;
        int limitMin;
        long nodeSortInterval;
        this.oppContainerAllocator = new OpportunisticContainerAllocator(rmContext.getContainerTokenSecretManager());
        this.k = rmContext.getYarnConfiguration().getInt("yarn.resourcemanager.opportunistic-container-allocation.nodes-used", 10);
        this.cacheRefreshInterval = nodeSortInterval = rmContext.getYarnConfiguration().getLong("yarn.resourcemanager.nm-container-queuing.sorting-nodes-interval-ms", 1000L);
        this.lastCacheUpdateTime = System.currentTimeMillis();
        NodeQueueLoadMonitor.LoadComparator comparator = NodeQueueLoadMonitor.LoadComparator.valueOf(rmContext.getYarnConfiguration().get("yarn.resourcemanager.nm-container-queuing.load-comparator", "QUEUE_LENGTH"));
        NodeQueueLoadMonitor topKSelector = new NodeQueueLoadMonitor(nodeSortInterval, comparator);
        float sigma = rmContext.getYarnConfiguration().getFloat("yarn.resourcemanager.nm-container-queuing.queue-limit-stdev", 1.0f);
        if (comparator == NodeQueueLoadMonitor.LoadComparator.QUEUE_LENGTH) {
            limitMin = rmContext.getYarnConfiguration().getInt("yarn.resourcemanager.nm-container-queuing.min-queue-length", 5);
            limitMax = rmContext.getYarnConfiguration().getInt("yarn.resourcemanager.nm-container-queuing.max-queue-length", 15);
        } else {
            limitMin = rmContext.getYarnConfiguration().getInt("yarn.resourcemanager.nm-container-queuing.min-queue-wait-time-ms", 10);
            limitMax = rmContext.getYarnConfiguration().getInt("yarn.resourcemanager.nm-container-queuing.max-queue-wait-time-ms", 100);
        }
        topKSelector.initThresholdCalculator(sigma, limitMin, limitMax);
        this.nodeMonitor = topKSelector;
    }

    @Override
    public Server getServer(YarnRPC rpc, Configuration serverConf, InetSocketAddress addr, AMRMTokenSecretManager secretManager) {
        if (YarnConfiguration.isDistSchedulingEnabled((Configuration)serverConf)) {
            Server server = rpc.getServer(DistributedSchedulingAMProtocol.class, (Object)this, addr, serverConf, (SecretManager)secretManager, serverConf.getInt("yarn.resourcemanager.scheduler.client.thread-count", 50));
            ((RPC.Server)server).addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, ApplicationMasterProtocolPB.class, (Object)ApplicationMasterProtocol.ApplicationMasterProtocolService.newReflectiveBlockingService((ApplicationMasterProtocol.ApplicationMasterProtocolService.BlockingInterface)new ApplicationMasterProtocolPBServiceImpl((ApplicationMasterProtocol)this)));
            return server;
        }
        return super.getServer(rpc, serverConf, addr, secretManager);
    }

    @Override
    protected List<ApplicationMasterServiceProcessor> getProcessorList(Configuration conf) {
        List<ApplicationMasterServiceProcessor> retVal = super.getProcessorList(conf);
        retVal.add(new OpportunisticAMSProcessor());
        return retVal;
    }

    @Override
    public RegisterDistributedSchedulingAMResponse registerApplicationMasterForDistributedScheduling(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        RegisterApplicationMasterResponse response = this.registerApplicationMaster(request);
        RegisterDistributedSchedulingAMResponse dsResp = (RegisterDistributedSchedulingAMResponse)this.recordFactory.newRecordInstance(RegisterDistributedSchedulingAMResponse.class);
        dsResp.setRegisterResponse(response);
        dsResp.setMinContainerResource(this.rmContext.getScheduler().getMinimumResourceCapability());
        dsResp.setMaxContainerResource(this.rmContext.getScheduler().getMaximumResourceCapability());
        dsResp.setContainerTokenExpiryInterval(this.getConfig().getInt("yarn.resourcemanager.rm.container-allocation.expiry-interval-ms", 600000));
        dsResp.setContainerIdStart(this.rmContext.getEpoch() << 40);
        dsResp.setNodesForScheduling(this.getLeastLoadedNodes());
        return dsResp;
    }

    @Override
    public DistributedSchedulingAllocateResponse allocateForDistributedScheduling(DistributedSchedulingAllocateRequest request) throws YarnException, IOException {
        List<Container> distAllocContainers = request.getAllocatedContainers();
        this.handleNewContainers(distAllocContainers, true);
        AllocateResponse response = this.allocate(request.getAllocateRequest());
        DistributedSchedulingAllocateResponse dsResp = (DistributedSchedulingAllocateResponse)this.recordFactory.newRecordInstance(DistributedSchedulingAllocateResponse.class);
        dsResp.setAllocateResponse(response);
        dsResp.setNodesForScheduling(this.getLeastLoadedNodes());
        return dsResp;
    }

    private void handleNewContainers(List<Container> allocContainers, boolean isRemotelyAllocated) {
        for (Container container : allocContainers) {
            RMContainer rmContainer = SchedulerUtils.createOpportunisticRmContainer(this.rmContext, container, isRemotelyAllocated);
            if (rmContainer == null) continue;
            rmContainer.handle((Event)new RMContainerEvent(container.getId(), RMContainerEventType.ACQUIRED));
        }
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                if (!(event instanceof NodeAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.nodeMonitor.addNode(nodeAddedEvent.getContainerReports(), nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                if (!(event instanceof NodeRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.nodeMonitor.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_UPDATE: {
                if (!(event instanceof NodeUpdateSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeMonitor.updateNode(nodeUpdatedEvent.getRMNode());
                break;
            }
            case NODE_RESOURCE_UPDATE: {
                if (!(event instanceof NodeResourceUpdateSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeResourceUpdateSchedulerEvent nodeResourceUpdatedEvent = (NodeResourceUpdateSchedulerEvent)event;
                this.nodeMonitor.updateNodeResource(nodeResourceUpdatedEvent.getRMNode(), nodeResourceUpdatedEvent.getResourceOption());
                break;
            }
            case APP_ADDED: {
                break;
            }
            case APP_REMOVED: {
                break;
            }
            case APP_ATTEMPT_ADDED: {
                break;
            }
            case APP_ATTEMPT_REMOVED: {
                break;
            }
            case CONTAINER_EXPIRED: {
                break;
            }
            case NODE_LABELS_UPDATE: {
                break;
            }
            case RELEASE_CONTAINER: {
                break;
            }
            default: {
                LOG.error((Object)("Unknown event arrived atOpportunisticContainerAllocatorAMService: " + event.toString()));
            }
        }
    }

    public QueueLimitCalculator getNodeManagerQueueLimitCalculator() {
        return this.nodeMonitor.getThresholdCalculator();
    }

    @VisibleForTesting
    synchronized List<RemoteNode> getLeastLoadedNodes() {
        long currTime = System.currentTimeMillis();
        if (currTime - this.lastCacheUpdateTime > this.cacheRefreshInterval || this.cachedNodes == null) {
            this.cachedNodes = this.convertToRemoteNodes(this.nodeMonitor.selectLeastLoadedNodes(this.k));
            if (this.cachedNodes.size() > 0) {
                this.lastCacheUpdateTime = currTime;
            }
        }
        return this.cachedNodes;
    }

    private List<RemoteNode> convertToRemoteNodes(List<NodeId> nodeIds) {
        ArrayList<RemoteNode> retNodes = new ArrayList<RemoteNode>();
        for (NodeId nId : nodeIds) {
            RemoteNode remoteNode = this.convertToRemoteNode(nId);
            if (null == remoteNode) continue;
            retNodes.add(remoteNode);
        }
        return retNodes;
    }

    private RemoteNode convertToRemoteNode(NodeId nodeId) {
        SchedulerNode node = ((AbstractYarnScheduler)this.rmContext.getScheduler()).getNode(nodeId);
        if (node != null) {
            RemoteNode rNode = RemoteNode.newInstance(nodeId, node.getHttpAddress());
            rNode.setRackName(node.getRackName());
            return rNode;
        }
        return null;
    }

    private static ApplicationAttemptId getAppAttemptId() throws YarnException {
        AMRMTokenIdentifier amrmTokenIdentifier = YarnServerSecurityUtils.authorizeRequest();
        ApplicationAttemptId applicationAttemptId = amrmTokenIdentifier.getApplicationAttemptId();
        return applicationAttemptId;
    }

    class OpportunisticAMSProcessor
    implements ApplicationMasterServiceProcessor {
        private ApplicationMasterServiceContext context;
        private ApplicationMasterServiceProcessor nextProcessor;

        OpportunisticAMSProcessor() {
        }

        private YarnScheduler getScheduler() {
            return ((RMContext)this.context).getScheduler();
        }

        public void init(ApplicationMasterServiceContext amsContext, ApplicationMasterServiceProcessor next) {
            this.context = amsContext;
            this.nextProcessor = next;
        }

        public void registerApplicationMaster(ApplicationAttemptId applicationAttemptId, RegisterApplicationMasterRequest request, RegisterApplicationMasterResponse response) throws IOException, YarnException {
            Object appAttempt = ((AbstractYarnScheduler)this.getScheduler()).getApplicationAttempt(applicationAttemptId);
            if (((SchedulerApplicationAttempt)appAttempt).getOpportunisticContainerContext() == null) {
                OpportunisticContainerContext opCtx = new OpportunisticContainerContext();
                opCtx.setContainerIdGenerator(new OpportunisticContainerAllocator.ContainerIdGenerator((SchedulerApplicationAttempt)appAttempt){
                    final /* synthetic */ SchedulerApplicationAttempt val$appAttempt;
                    {
                        this.val$appAttempt = schedulerApplicationAttempt;
                    }

                    @Override
                    public long generateContainerId() {
                        return this.val$appAttempt.getAppSchedulingInfo().getNewContainerId();
                    }
                });
                int tokenExpiryInterval = OpportunisticContainerAllocatorAMService.this.getConfig().getInt("yarn.resourcemanager.rm.container-allocation.expiry-interval-ms", 600000);
                opCtx.updateAllocationParams(this.getScheduler().getMinimumResourceCapability(), this.getScheduler().getMaximumResourceCapability(), this.getScheduler().getMinimumResourceCapability(), tokenExpiryInterval);
                ((SchedulerApplicationAttempt)appAttempt).setOpportunisticContainerContext(opCtx);
            }
            this.nextProcessor.registerApplicationMaster(applicationAttemptId, request, response);
        }

        public void allocate(ApplicationAttemptId appAttemptId, AllocateRequest request, AllocateResponse response) throws YarnException {
            OpportunisticContainerAllocator.PartitionedResourceRequests partitionedAsks = OpportunisticContainerAllocatorAMService.this.oppContainerAllocator.partitionAskList(request.getAskList());
            Object appAttempt = ((AbstractYarnScheduler)OpportunisticContainerAllocatorAMService.this.rmContext.getScheduler()).getApplicationAttempt(appAttemptId);
            if (!((SchedulerApplicationAttempt)appAttempt).getApplicationAttemptId().equals((Object)appAttemptId)) {
                LOG.error((Object)("Calling allocate on previous or removed or non existent application attempt " + appAttemptId));
                return;
            }
            OpportunisticContainerContext oppCtx = ((SchedulerApplicationAttempt)appAttempt).getOpportunisticContainerContext();
            oppCtx.updateNodeList(OpportunisticContainerAllocatorAMService.this.getLeastLoadedNodes());
            List<Container> oppContainers = OpportunisticContainerAllocatorAMService.this.oppContainerAllocator.allocateContainers(request.getResourceBlacklistRequest(), partitionedAsks.getOpportunistic(), appAttemptId, oppCtx, ResourceManager.getClusterTimeStamp(), ((SchedulerApplicationAttempt)appAttempt).getUser());
            if (!oppContainers.isEmpty()) {
                OpportunisticContainerAllocatorAMService.this.handleNewContainers(oppContainers, false);
                ((SchedulerApplicationAttempt)appAttempt).updateNMTokens(oppContainers);
                ApplicationMasterServiceUtils.addToAllocatedContainers((AllocateResponse)response, oppContainers);
            }
            request.setAskList(partitionedAsks.getGuaranteed());
            this.nextProcessor.allocate(appAttemptId, request, response);
        }

        public void finishApplicationMaster(ApplicationAttemptId applicationAttemptId, FinishApplicationMasterRequest request, FinishApplicationMasterResponse response) {
            this.nextProcessor.finishApplicationMaster(applicationAttemptId, request, response);
        }
    }
}

