/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;

public abstract class AbstractComparatorOrderingPolicy<S extends SchedulableEntity>
implements OrderingPolicy<S> {
    private static final Log LOG = LogFactory.getLog(OrderingPolicy.class);
    protected ConcurrentSkipListSet<S> schedulableEntities;
    protected Comparator<SchedulableEntity> comparator;
    protected Map<String, S> entitiesToReorder = new HashMap<String, S>();

    @Override
    public Collection<S> getSchedulableEntities() {
        return this.schedulableEntities;
    }

    @Override
    public Iterator<S> getAssignmentIterator() {
        this.reorderScheduleEntities();
        return this.schedulableEntities.iterator();
    }

    @Override
    public Iterator<S> getPreemptionIterator() {
        this.reorderScheduleEntities();
        return this.schedulableEntities.descendingIterator();
    }

    public static void updateSchedulingResourceUsage(ResourceUsage ru) {
        ru.setCachedUsed("*", ru.getAllUsed());
        ru.setCachedPending("*", ru.getAllPending());
    }

    protected void reorderSchedulableEntity(S schedulableEntity) {
        this.schedulableEntities.remove(schedulableEntity);
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage(schedulableEntity.getSchedulingResourceUsage());
        this.schedulableEntities.add(schedulableEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reorderScheduleEntities() {
        Map<String, S> map = this.entitiesToReorder;
        synchronized (map) {
            for (Map.Entry<String, S> entry : this.entitiesToReorder.entrySet()) {
                this.reorderSchedulableEntity((SchedulableEntity)entry.getValue());
            }
            this.entitiesToReorder.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void entityRequiresReordering(S schedulableEntity) {
        Map<String, S> map = this.entitiesToReorder;
        synchronized (map) {
            this.entitiesToReorder.put(schedulableEntity.getId(), schedulableEntity);
        }
    }

    public Comparator<SchedulableEntity> getComparator() {
        return this.comparator;
    }

    @Override
    public void addSchedulableEntity(S s) {
        if (null == s) {
            return;
        }
        this.schedulableEntities.add(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSchedulableEntity(S s) {
        if (null == s) {
            return false;
        }
        Map<String, S> map = this.entitiesToReorder;
        synchronized (map) {
            this.entitiesToReorder.remove(s.getId());
        }
        return this.schedulableEntities.remove(s);
    }

    @Override
    public void addAllSchedulableEntities(Collection<S> sc) {
        this.schedulableEntities.addAll(sc);
    }

    @Override
    public int getNumSchedulableEntities() {
        return this.schedulableEntities.size();
    }

    @Override
    public abstract void configure(Map<String, String> var1);

    @Override
    public abstract void containerAllocated(S var1, RMContainer var2);

    @Override
    public abstract void containerReleased(S var1, RMContainer var2);

    @Override
    public abstract void demandUpdated(S var1);

    @Override
    public abstract String getInfo();
}

