/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineWriteResponse;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineAggregationTrack;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemTimelineWriterImpl
extends AbstractService
implements TimelineWriter {
    private String outputRoot;
    public static final String TIMELINE_SERVICE_STORAGE_DIR_ROOT = "yarn.timeline-service.fs-writer.root-dir";
    public static final String ENTITIES_DIR = "entities";
    public static final String TIMELINE_SERVICE_STORAGE_EXTENSION = ".thist";
    private static final String STORAGE_DIR_ROOT = "timeline_service_data";

    FileSystemTimelineWriterImpl() {
        super(FileSystemTimelineWriterImpl.class.getName());
    }

    @Override
    public TimelineWriteResponse write(TimelineCollectorContext context, TimelineEntities entities, UserGroupInformation callerUgi) throws IOException {
        TimelineWriteResponse response = new TimelineWriteResponse();
        String clusterId = context.getClusterId();
        String userId = context.getUserId();
        String flowName = context.getFlowName();
        String flowVersion = context.getFlowVersion();
        long flowRunId = context.getFlowRunId();
        String appId = context.getAppId();
        for (TimelineEntity entity : entities.getEntities()) {
            this.write(clusterId, userId, flowName, flowVersion, flowRunId, appId, entity, response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void write(String clusterId, String userId, String flowName, String flowVersion, long flowRun, String appId, TimelineEntity entity, TimelineWriteResponse response) throws IOException {
        try (PrintWriter out = null;){
            String dir = FileSystemTimelineWriterImpl.mkdirs(this.outputRoot, ENTITIES_DIR, clusterId, userId, FileSystemTimelineWriterImpl.escape(flowName), FileSystemTimelineWriterImpl.escape(flowVersion), String.valueOf(flowRun), appId, entity.getType());
            String fileName = dir + entity.getId() + TIMELINE_SERVICE_STORAGE_EXTENSION;
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, true), "UTF-8")));
            out.println(TimelineUtils.dumpTimelineRecordtoJSON((Object)entity));
            out.write("\n");
        }
    }

    @Override
    public TimelineWriteResponse aggregate(TimelineEntity data, TimelineAggregationTrack track) throws IOException {
        return null;
    }

    @VisibleForTesting
    String getOutputRoot() {
        return this.outputRoot;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.outputRoot = conf.get(TIMELINE_SERVICE_STORAGE_DIR_ROOT, conf.get("hadoop.tmp.dir") + File.separator + STORAGE_DIR_ROOT);
    }

    public void serviceStart() throws Exception {
        FileSystemTimelineWriterImpl.mkdirs(this.outputRoot, ENTITIES_DIR);
    }

    @Override
    public void flush() throws IOException {
    }

    private static String mkdirs(String ... dirStrs) throws IOException {
        StringBuilder path = new StringBuilder();
        for (String dirStr : dirStrs) {
            path.append(dirStr).append(File.separatorChar);
            File dir = new File(path.toString());
            if (dir.exists() || dir.mkdirs()) continue;
            throw new IOException("Could not create directories for " + dir);
        }
        return path.toString();
    }

    private static String escape(String str) {
        return str.replace(File.separatorChar, '_');
    }
}

