/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Supplier;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class TestFileCorruption {
    static Logger LOG = NameNode.stateChangeLog;

    public TestFileCorruption() {
        DFSTestUtil.setNameNodeLogLevel(Level.ALL);
        GenericTestUtils.setLogLevel((Logger)DataNode.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCorruption() throws Exception {
        MiniDFSCluster cluster = null;
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFileCorruption").setNumFiles(20).build();
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            util.createFiles((FileSystem)fs, "/srcdat");
            String bpid = cluster.getNamesystem().getBlockPoolId();
            DataNode dn = cluster.getDataNodes().get(2);
            Map blockReports = dn.getFSDataset().getBlockReports(bpid);
            Assert.assertTrue((String)"Blocks do not exist on data-dir", (!blockReports.isEmpty() ? 1 : 0) != 0);
            for (BlockListAsLongs report : blockReports.values()) {
                for (BlockListAsLongs.BlockReportReplica brr : report) {
                    LOG.info("Deliberately removing block {}", (Object)brr.getBlockName());
                    cluster.getFsDatasetTestUtils(2).getMaterializedReplica(new ExtendedBlock(bpid, (Block)brr)).deleteData();
                }
            }
            Assert.assertTrue((String)"Corrupted replicas not handled properly.", (boolean)util.checkFiles((FileSystem)fs, "/srcdat"));
            util.cleanup((FileSystem)fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testLocalFileCorruption() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Path file = new Path(PathUtils.getTestDirName(this.getClass()), "corruptFile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Object dos = fs.create(file);
        ((DataOutputStream)dos).writeBytes("original bytes");
        ((FilterOutputStream)dos).close();
        dos = new DataOutputStream(new FileOutputStream(file.toString()));
        ((DataOutputStream)dos).writeBytes("corruption");
        ((FilterOutputStream)dos).close();
        FSDataInputStream dis = fs.open(file, 512);
        try {
            LOG.info("A ChecksumException is expected to be logged.");
            dis.readByte();
        }
        catch (ChecksumException checksumException) {
            // empty catch block
        }
        fs.delete(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayOutOfBoundsException() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path FILE_PATH = new Path("/tmp.txt");
            long FILE_LEN = 1L;
            DFSTestUtil.createFile((FileSystem)fs, FILE_PATH, 1L, (short)2, 1L);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ExtendedBlock blk = TestFileCorruption.getFirstBlock(cluster.getDataNodes().get(0), bpid);
            Assert.assertFalse((String)"Data directory does not contain any blocks or there was an IO error", (blk == null ? 1 : 0) != 0);
            cluster.startDataNodes((Configuration)conf, 1, true, null, null);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)3L);
            DataNode dataNode = datanodes.get(2);
            DatanodeRegistration dnR = InternalDataNodeTestUtils.getDNRegistrationForBP(dataNode, blk.getBlockPoolId());
            FSNamesystem ns = cluster.getNamesystem();
            ns.writeLock();
            try {
                cluster.getNamesystem().getBlockManager().findAndMarkBlockAsCorrupt(blk, new DatanodeInfo.DatanodeInfoBuilder().setNodeID((DatanodeID)dnR).build(), "TEST", "STORAGE_ID");
            }
            finally {
                ns.writeUnlock();
            }
            fs.open(FILE_PATH);
            fs.delete(FILE_PATH, false);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptionWithDiskFailure() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            BlockManager bm = cluster.getNamesystem().getBlockManager();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path FILE_PATH = new Path("/tmp.txt");
            long FILE_LEN = 1L;
            DFSTestUtil.createFile((FileSystem)fs, FILE_PATH, 1L, (short)3, 1L);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            File storageDir = cluster.getInstanceStorageDir(0, 0);
            File dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            Assert.assertTrue((String)"Data directory does not exist", (boolean)dataDir.exists());
            ExtendedBlock blk = TestFileCorruption.getFirstBlock(cluster.getDataNodes().get(0), bpid);
            if (blk == null) {
                blk = TestFileCorruption.getFirstBlock(cluster.getDataNodes().get(0), bpid);
            }
            Assert.assertFalse((String)"Data directory does not contain any blocks or there was an IO error", (blk == null ? 1 : 0) != 0);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)3L);
            FSNamesystem ns = cluster.getNamesystem();
            try {
                ns.writeLock();
                this.updateAllStorages(bm);
            }
            finally {
                ns.writeUnlock();
            }
            ns.writeLock();
            try {
                this.markAllBlocksAsCorrupt(bm, blk);
            }
            finally {
                ns.writeUnlock();
            }
            fs.open(FILE_PATH);
            fs.delete(FILE_PATH, false);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testSetReplicationWhenBatchIBR() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.heartbeat.interval", 100L);
        conf.setLong("dfs.blockreport.incremental.intervalMsec", 30000L);
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.namenode.file.close.num-committed-allowed", 1);
        try (final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();){
            int bufferSize = 1024;
            byte[] outBuffer = new byte[1024];
            DistributedFileSystem dfs = cluster.getFileSystem();
            String fileName = "/testSetRep1";
            Path filePath = new Path(fileName);
            FSDataOutputStream out = dfs.create(filePath);
            out.write(outBuffer, 0, 1024);
            out.close();
            cluster.triggerBlockReports();
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        cluster.triggerBlockReports();
                        if (cluster.getNamesystem().getBlocksTotal() == 1L) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
            }, (int)10, (int)3000);
            fileName = "/testSetRep2";
            filePath = new Path(fileName);
            out = dfs.create(filePath);
            out.write(outBuffer, 0, 1024);
            out.close();
            dfs.setReplication(filePath, (short)10);
            cluster.triggerBlockReports();
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        return cluster.getNamesystem().getBlockManager().getLowRedundancyBlocksCount() == 1L;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }, (int)10, (int)3000);
            Assert.assertEquals((long)0L, (long)cluster.getNamesystem().getBlockManager().getMissingBlocksCount());
        }
    }

    private void markAllBlocksAsCorrupt(BlockManager bm, ExtendedBlock blk) throws IOException {
        for (DatanodeStorageInfo info : bm.getStorages(blk.getLocalBlock())) {
            bm.findAndMarkBlockAsCorrupt(blk, (DatanodeInfo)info.getDatanodeDescriptor(), info.getStorageID(), "STORAGE_ID");
        }
    }

    private void updateAllStorages(BlockManager bm) {
        for (DatanodeDescriptor dd : bm.getDatanodeManager().getDatanodes()) {
            HashSet<DatanodeStorageInfo> setInfos = new HashSet<DatanodeStorageInfo>();
            DatanodeStorageInfo[] infos = dd.getStorageInfos();
            Random random = new Random();
            for (int i = 0; i < infos.length; ++i) {
                int blkId = random.nextInt(101);
                DatanodeStorage storage = new DatanodeStorage(Integer.toString(blkId), DatanodeStorage.State.FAILED, StorageType.DISK);
                infos[i].updateFromStorage(storage);
                setInfos.add(infos[i]);
            }
        }
    }

    private static ExtendedBlock getFirstBlock(DataNode dn, String bpid) {
        Map blockReports = dn.getFSDataset().getBlockReports(bpid);
        for (BlockListAsLongs blockLongs : blockReports.values()) {
            Iterator iterator = blockLongs.iterator();
            if (!iterator.hasNext()) continue;
            BlockListAsLongs.BlockReportReplica block = (BlockListAsLongs.BlockReportReplica)iterator.next();
            return new ExtendedBlock(bpid, (Block)block);
        }
        return null;
    }
}

