/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestTrash;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHDFSTrash {
    public static final Log LOG = LogFactory.getLog(TestHDFSTrash.class);
    private static MiniDFSCluster cluster = null;
    private static FileSystem fs;
    private static Configuration conf;
    private static final Path TEST_ROOT;
    private static final Path TRASH_ROOT;
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String GROUP3_NAME = "group3";
    private static final String USER1_NAME = "user1";
    private static final String USER2_NAME = "user2";
    private static UserGroupInformation superUser;
    private static UserGroupInformation user1;
    private static UserGroupInformation user2;

    @BeforeClass
    public static void setUp() throws Exception {
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        fs = FileSystem.get((Configuration)conf);
        superUser = UserGroupInformation.getCurrentUser();
        user1 = UserGroupInformation.createUserForTesting((String)USER1_NAME, (String[])new String[]{GROUP1_NAME, GROUP2_NAME});
        user2 = UserGroupInformation.createUserForTesting((String)USER2_NAME, (String[])new String[]{GROUP2_NAME, GROUP3_NAME});
        fs.mkdirs(TEST_ROOT);
        fs.setPermission(TEST_ROOT, new FsPermission(511));
        DFSTestUtil.verifyFilePermission(fs.getFileStatus(TEST_ROOT), superUser.getShortUserName(), null, FsAction.ALL, FsAction.ALL, FsAction.ALL);
        fs.mkdirs(TRASH_ROOT);
        fs.setPermission(TRASH_ROOT, new FsPermission(511));
        DFSTestUtil.verifyFilePermission(fs.getFileStatus(TRASH_ROOT), superUser.getShortUserName(), null, FsAction.ALL, FsAction.ALL, FsAction.ALL);
    }

    @AfterClass
    public static void tearDown() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testTrash() throws IOException {
        TestTrash.trashShell((FileSystem)cluster.getFileSystem(), (Path)new Path("/"));
    }

    @Test
    public void testNonDefaultFS() throws IOException {
        DistributedFileSystem fileSystem = cluster.getFileSystem();
        Configuration config = fileSystem.getConf();
        config.set("fs.defaultFS", fileSystem.getUri().toString());
        TestTrash.trashNonDefaultFS((Configuration)config);
    }

    @Test
    public void testHDFSTrashPermission() throws IOException {
        DistributedFileSystem fileSystem = cluster.getFileSystem();
        Configuration config = fileSystem.getConf();
        config.set("fs.trash.interval", "0.2");
        TestTrash.verifyTrashPermission((FileSystem)fileSystem, (Configuration)config);
    }

    @Test
    public void testMoveEmptyDirToTrash() throws IOException {
        DistributedFileSystem fileSystem = cluster.getFileSystem();
        Configuration config = fileSystem.getConf();
        config.set("fs.trash.interval", "1");
        TestTrash.verifyMoveEmptyDirToTrash((FileSystem)fileSystem, (Configuration)config);
    }

    @Test
    public void testDeleteTrash() throws Exception {
        Configuration testConf = new Configuration(conf);
        testConf.set("fs.trash.interval", "10");
        Path user1Tmp = new Path(TEST_ROOT, "test-del-u1");
        Path user2Tmp = new Path(TEST_ROOT, "test-del-u2");
        fs = DFSTestUtil.login(fs, testConf, user1);
        fs.mkdirs(user1Tmp);
        Trash u1Trash = this.getPerUserTrash(user1, fs, testConf);
        Path u1t = u1Trash.getCurrentTrashDir(user1Tmp);
        Assert.assertTrue((String)String.format("Failed to move %s to trash", user1Tmp), (boolean)u1Trash.moveToTrash(user1Tmp));
        Assert.assertTrue((String)String.format("%s should be allowed to remove its own trash directory %s", user1.getUserName(), u1t), (boolean)fs.delete(u1t, true));
        Assert.assertFalse((boolean)fs.exists(u1t));
        fs = DFSTestUtil.login(fs, testConf, user2);
        fs.mkdirs(user2Tmp);
        Trash u2Trash = this.getPerUserTrash(user2, fs, testConf);
        u2Trash.moveToTrash(user2Tmp);
        Path u2t = u2Trash.getCurrentTrashDir(user2Tmp);
        try {
            fs = DFSTestUtil.login(fs, testConf, user1);
            fs.delete(u2t, true);
            Assert.fail((String)String.format("%s should not be able to remove %s trash directory", USER1_NAME, USER2_NAME));
        }
        catch (AccessControlException e) {
            Assert.assertTrue((boolean)(e instanceof AccessControlException));
            Assert.assertTrue((String)"Permission denied messages must carry the username", (boolean)e.getMessage().contains(USER1_NAME));
        }
    }

    private Trash getPerUserTrash(UserGroupInformation ugi, FileSystem fileSystem, Configuration config) throws IOException {
        UUID trashId = UUID.randomUUID();
        StringBuffer sb = new StringBuffer().append(ugi.getUserName()).append("-").append(trashId.toString());
        Path userTrashRoot = new Path(TRASH_ROOT, sb.toString());
        FileSystem spyUserFs = (FileSystem)Mockito.spy((Object)fileSystem);
        Mockito.when((Object)spyUserFs.getTrashRoot((Path)Mockito.any())).thenReturn((Object)userTrashRoot);
        return new Trash(spyUserFs, config);
    }

    static {
        conf = new HdfsConfiguration();
        TEST_ROOT = new Path("/TestHDFSTrash-ROOT");
        TRASH_ROOT = new Path("/TestHDFSTrash-TRASH");
    }
}

