/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class TestReplaceDatanodeOnFailure {
    static final Log LOG = LogFactory.getLog(TestReplaceDatanodeOnFailure.class);
    static final String DIR = "/" + TestReplaceDatanodeOnFailure.class.getSimpleName() + "/";
    static final short REPLICATION = 3;
    private static final String RACK0 = "/rack0";
    private static final String RACK1 = "/rack1";

    public TestReplaceDatanodeOnFailure() {
        GenericTestUtils.setLogLevel((Logger)DataTransferProtocol.LOG, (Level)Level.ALL);
    }

    @Test
    public void testDefaultPolicy() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        ReplaceDatanodeOnFailure p = ReplaceDatanodeOnFailure.get((Configuration)conf);
        DatanodeInfo[] infos = new DatanodeInfo[5];
        DatanodeInfo[][] datanodes = new DatanodeInfo[infos.length + 1][];
        datanodes[0] = new DatanodeInfo[0];
        int i = 0;
        while (i < infos.length) {
            infos[i] = DFSTestUtil.getLocalDatanodeInfo(9867 + i);
            datanodes[++i] = new DatanodeInfo[i];
            System.arraycopy(infos, 0, datanodes[i], 0, datanodes[i].length);
        }
        boolean[] isAppend = new boolean[]{true, true, false, false};
        boolean[] isHflushed = new boolean[]{true, false, true, false};
        for (short replication = 1; replication <= infos.length; replication = (short)((short)(replication + 1))) {
            for (int nExistings = 0; nExistings < datanodes.length; ++nExistings) {
                DatanodeInfo[] existings = datanodes[nExistings];
                Assert.assertEquals((long)nExistings, (long)existings.length);
                for (int i2 = 0; i2 < isAppend.length; ++i2) {
                    for (int j = 0; j < isHflushed.length; ++j) {
                        boolean isAH;
                        int half = replication / 2;
                        boolean enoughReplica = replication <= nExistings;
                        boolean noReplica = nExistings == 0;
                        boolean replicationL3 = replication < 3;
                        boolean existingsLEhalf = nExistings <= half;
                        boolean bl = isAH = isAppend[i2] || isHflushed[j];
                        boolean expected = enoughReplica || noReplica || replicationL3 ? false : isAH || existingsLEhalf;
                        boolean computed = p.satisfy(replication, existings, isAppend[i2], isHflushed[j]);
                        try {
                            Assert.assertEquals((Object)expected, (Object)computed);
                            continue;
                        }
                        catch (AssertionError e) {
                            String s = "replication=" + replication + "\nnExistings =" + nExistings + "\nisAppend   =" + isAppend[i2] + "\nisHflushed =" + isHflushed[j];
                            throw new RuntimeException(s, (Throwable)((Object)e));
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplaceDatanodeOnFailure() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        ReplaceDatanodeOnFailure.write((ReplaceDatanodeOnFailure.Policy)ReplaceDatanodeOnFailure.Policy.ALWAYS, (boolean)true, (Configuration)conf);
        Object[] racks = new String[3];
        Arrays.fill(racks, RACK0);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).racks((String[])racks).numDataNodes(3).build();
        try {
            int i;
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path(DIR);
            int NUM_WRITERS = 10;
            int FIRST_BATCH = 5;
            SlowWriter[] slowwriters = new SlowWriter[10];
            for (i = 1; i <= slowwriters.length; ++i) {
                slowwriters[i - 1] = new SlowWriter(fs, new Path(dir, "file" + i), (long)i * 200L);
            }
            for (i = 0; i < 5; ++i) {
                slowwriters[i].start();
            }
            TestReplaceDatanodeOnFailure.sleepSeconds(3);
            cluster.startDataNodes((Configuration)conf, 2, true, null, new String[]{RACK1, RACK1});
            cluster.waitActive();
            cluster.waitFirstBRCompleted(0, 10000);
            MiniDFSCluster.DataNodeProperties dnprop = cluster.stopDataNode(AppendTestUtil.nextInt(3));
            for (int i2 = 5; i2 < slowwriters.length; ++i2) {
                slowwriters[i2].start();
            }
            this.waitForBlockReplication(slowwriters);
            for (SlowWriter s : slowwriters) {
                s.checkReplication();
                s.interruptRunning();
            }
            for (SlowWriter s : slowwriters) {
                s.joinAndClose();
            }
            LOG.info((Object)"Verify the file");
            for (int i3 = 0; i3 < slowwriters.length; ++i3) {
                LOG.info((Object)(slowwriters[i3].filepath + ": length=" + fs.getFileStatus(slowwriters[i3].filepath).getLen()));
                FSDataInputStream in = null;
                try {
                    int x;
                    in = fs.open(slowwriters[i3].filepath);
                    int j = 0;
                    while ((x = in.read()) != -1) {
                        Assert.assertEquals((long)j, (long)x);
                        ++j;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(in);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)in);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    void waitForBlockReplication(final SlowWriter[] slowwriters) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    for (SlowWriter s : slowwriters) {
                        if (s.out.getCurrentBlockReplication() >= 3) continue;
                        return false;
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)"IOException is thrown while getting the file block replication factor", (Throwable)e);
                    return false;
                }
                return true;
            }
        }, (int)1000, (int)10000);
    }

    static void sleepSeconds(int waittime) throws InterruptedException {
        LOG.info((Object)("Wait " + waittime + " seconds"));
        Thread.sleep((long)waittime * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int REPLICATION = 3;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path f = new Path(DIR, "testAppend");
            LOG.info((Object)("create an empty file " + f));
            fs.create(f, (short)3).close();
            FileStatus status = fs.getFileStatus(f);
            Assert.assertEquals((long)3L, (long)status.getReplication());
            Assert.assertEquals((long)0L, (long)status.getLen());
            byte[] bytes = new byte[1000];
            LOG.info((Object)("append " + bytes.length + " bytes to " + f));
            FSDataOutputStream out = fs.append(f);
            out.write(bytes);
            out.close();
            FileStatus status2 = fs.getFileStatus(f);
            Assert.assertEquals((long)3L, (long)status2.getReplication());
            Assert.assertEquals((long)bytes.length, (long)status2.getLen());
            LOG.info((Object)("append another " + bytes.length + " bytes to " + f));
            try {
                out = fs.append(f);
                out.write(bytes);
                out.close();
                Assert.fail();
            }
            catch (IOException ioe) {
                LOG.info((Object)"This exception is expected", (Throwable)ioe);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBestEffort() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        ReplaceDatanodeOnFailure.write((ReplaceDatanodeOnFailure.Policy)ReplaceDatanodeOnFailure.Policy.ALWAYS, (boolean)true, (Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path f = new Path(DIR, "testIgnoreReplaceFailure");
            byte[] bytes = new byte[1000];
            LOG.info((Object)("write " + bytes.length + " bytes to " + f));
            FSDataOutputStream out = fs.create(f, (short)3);
            out.write(bytes);
            out.close();
            FileStatus status = fs.getFileStatus(f);
            Assert.assertEquals((long)3L, (long)status.getReplication());
            Assert.assertEquals((long)bytes.length, (long)status.getLen());
            LOG.info((Object)("append another " + bytes.length + " bytes to " + f));
            out = fs.append(f);
            out.write(bytes);
            out.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static class SlowWriter
    extends Thread {
        final Path filepath;
        final HdfsDataOutputStream out;
        final long sleepms;
        private volatile boolean running = true;

        SlowWriter(DistributedFileSystem fs, Path filepath, long sleepms) throws IOException {
            super(SlowWriter.class.getSimpleName() + ":" + filepath);
            this.filepath = filepath;
            this.out = (HdfsDataOutputStream)fs.create(filepath, (short)3);
            this.sleepms = sleepms;
        }

        @Override
        public void run() {
            int i = 0;
            try {
                SlowWriter.sleep(this.sleepms);
                while (this.running) {
                    LOG.info((Object)(this.getName() + " writes " + i));
                    this.out.write(i);
                    this.out.hflush();
                    SlowWriter.sleep(this.sleepms);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                LOG.info((Object)(this.getName() + " interrupted:" + e));
            }
            catch (IOException e) {
                throw new RuntimeException(this.getName(), e);
            }
            finally {
                LOG.info((Object)(this.getName() + " terminated: i=" + i));
            }
        }

        void interruptRunning() {
            this.running = false;
            this.interrupt();
        }

        void joinAndClose() throws InterruptedException {
            LOG.info((Object)(this.getName() + " join and close"));
            this.join();
            IOUtils.closeStream((Closeable)this.out);
        }

        void checkReplication() throws IOException {
            Assert.assertEquals((long)3L, (long)this.out.getCurrentBlockReplication());
        }
    }
}

