/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.net.DFSNetworkTopology;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockReportLeaseManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostSet;
import org.apache.hadoop.hdfs.server.blockmanagement.UnresolvedTopologyException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockECReconstructionCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.util.Shell;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestDatanodeManager {
    public static final Log LOG = LogFactory.getLog(TestDatanodeManager.class);
    final int NUM_ITERATIONS = 500;

    private static DatanodeManager mockDatanodeManager(FSNamesystem fsn, Configuration conf) throws IOException {
        BlockManager bm = (BlockManager)Mockito.mock(BlockManager.class);
        BlockReportLeaseManager blm = new BlockReportLeaseManager(conf);
        Mockito.when((Object)bm.getBlockReportLeaseManager()).thenReturn((Object)blm);
        DatanodeManager dm = new DatanodeManager(bm, (Namesystem)fsn, conf);
        return dm;
    }

    private static InetSocketAddress entry(String host) {
        return HostFileManager.parseEntry((String)"dummy", (String)"dummy", (String)host);
    }

    @Test
    public void testNumVersionsCorrectAfterReregister() throws IOException, InterruptedException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        Configuration conf = new Configuration();
        conf.setLong("dfs.heartbeat.interval", 0L);
        conf.setLong("dfs.namenode.heartbeat.recheck-interval", 10L);
        DatanodeManager dm = TestDatanodeManager.mockDatanodeManager(fsn, conf);
        String storageID = "someStorageID1";
        String ip = "someIP" + storageID;
        for (int i = 0; i <= 1; ++i) {
            dm.registerDatanode(new DatanodeRegistration(new DatanodeID(ip, "", storageID, 9000, 0, 0, 0), null, null, "version" + i));
            if (i != 0) continue;
            Thread.sleep(25L);
        }
        HashMap mapToCheck = dm.getDatanodesSoftwareVersions();
        Assert.assertNull((String)"should be no more version0 nodes", mapToCheck.get("version0"));
        Assert.assertEquals((String)"should be one version1 node", (long)((Integer)mapToCheck.get("version1")).intValue(), (long)1L);
    }

    @Test
    public void testNumVersionsReportedCorrect() throws IOException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        DatanodeManager dm = TestDatanodeManager.mockDatanodeManager(fsn, new Configuration());
        Random rng = new Random();
        int seed = rng.nextInt();
        rng = new Random(seed);
        LOG.info((Object)("Using seed " + seed + " for testing"));
        HashMap<String, DatanodeRegistration> sIdToDnReg = new HashMap<String, DatanodeRegistration>();
        for (int i = 0; i < 500; ++i) {
            if (rng.nextBoolean() && i % 3 == 0 && sIdToDnReg.size() != 0) {
                int randomIndex = rng.nextInt() % sIdToDnReg.size();
                Iterator it = sIdToDnReg.entrySet().iterator();
                for (int j = 0; j < randomIndex - 1; ++j) {
                    it.next();
                }
                DatanodeRegistration toRemove = (DatanodeRegistration)it.next().getValue();
                LOG.info((Object)("Removing node " + toRemove.getDatanodeUuid() + " ip " + toRemove.getXferAddr() + " version : " + toRemove.getSoftwareVersion()));
                dm.removeDatanode((DatanodeID)toRemove);
                it.remove();
            } else {
                String storageID = "someStorageID" + rng.nextInt(5000);
                DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
                Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)storageID);
                if (sIdToDnReg.containsKey(storageID)) {
                    dr = (DatanodeRegistration)sIdToDnReg.get(storageID);
                    if (rng.nextBoolean()) {
                        dr.setIpAddr(dr.getIpAddr() + "newIP");
                    }
                } else {
                    String ip = "someIP" + storageID;
                    Mockito.when((Object)dr.getIpAddr()).thenReturn((Object)ip);
                    Mockito.when((Object)dr.getXferAddr()).thenReturn((Object)(ip + ":9000"));
                    Mockito.when((Object)dr.getXferPort()).thenReturn((Object)9000);
                }
                Mockito.when((Object)dr.getSoftwareVersion()).thenReturn((Object)("version" + rng.nextInt(5)));
                LOG.info((Object)("Registering node storageID: " + dr.getDatanodeUuid() + ", version: " + dr.getSoftwareVersion() + ", IP address: " + dr.getXferAddr()));
                dm.registerDatanode(dr);
                sIdToDnReg.put(storageID, dr);
            }
            HashMap mapToCheck = dm.getDatanodesSoftwareVersions();
            for (Map.Entry it : sIdToDnReg.entrySet()) {
                String ver = ((DatanodeRegistration)it.getValue()).getSoftwareVersion();
                if (!mapToCheck.containsKey(ver)) {
                    throw new AssertionError((Object)("The correct number of datanodes of a version was not found on iteration " + i));
                }
                mapToCheck.put(ver, (Integer)mapToCheck.get(ver) - 1);
                if ((Integer)mapToCheck.get(ver) != 0) continue;
                mapToCheck.remove(ver);
            }
            for (Map.Entry entry : mapToCheck.entrySet()) {
                LOG.info((Object)("Still in map: " + (String)entry.getKey() + " has " + entry.getValue()));
            }
            Assert.assertEquals((String)("The map of version counts returned by DatanodeManager was not what it was expected to be on iteration " + i), (long)0L, (long)mapToCheck.size());
        }
    }

    @Test(timeout=100000L)
    public void testRejectUnresolvedDatanodes() throws IOException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.reject-unresolved-dn-topology-mapping", true);
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        DatanodeManager dm = TestDatanodeManager.mockDatanodeManager(fsn, conf);
        String storageID = "someStorageID-123";
        DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
        Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)storageID);
        try {
            dm.registerDatanode(dr);
            Assert.fail((String)"Expected an UnresolvedTopologyException");
        }
        catch (UnresolvedTopologyException ute) {
            LOG.info((Object)"Expected - topology is not resolved and registration is rejected.");
        }
        catch (Exception e) {
            Assert.fail((String)"Expected an UnresolvedTopologyException");
        }
    }

    @Test
    public void testSortLocatedBlocks() throws IOException, URISyntaxException {
        this.HelperFunction(null, 0);
    }

    @Test
    public void testgoodScript() throws IOException, URISyntaxException {
        this.HelperFunction("/" + Shell.appendScriptExtension((String)"topology-script"), 0);
    }

    @Test
    public void testBadScript() throws IOException, URISyntaxException {
        this.HelperFunction("/" + Shell.appendScriptExtension((String)"topology-broken-script"), 0);
    }

    @Test
    public void testWithProvidedTypes() throws IOException, URISyntaxException {
        this.HelperFunction(null, 1);
        this.HelperFunction(null, 3);
        this.HelperFunction("/" + Shell.appendScriptExtension((String)"topology-script"), 1);
        this.HelperFunction("/" + Shell.appendScriptExtension((String)"topology-script"), 2);
    }

    public void HelperFunction(String scriptFileName, int providedStorages) throws URISyntaxException, IOException {
        int i;
        Configuration conf = new Configuration();
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        if (scriptFileName != null && !scriptFileName.isEmpty()) {
            URL shellScript = this.getClass().getResource(scriptFileName);
            Path resourcePath = Paths.get(shellScript.toURI());
            FileUtil.setExecutable((File)resourcePath.toFile(), (boolean)true);
            conf.set("net.topology.script.file.name", resourcePath.toString());
        }
        DatanodeManager dm = TestDatanodeManager.mockDatanodeManager(fsn, conf);
        int totalDNs = 5 + providedStorages;
        DatanodeInfo[] locs = new DatanodeInfo[totalDNs];
        String[] storageIDs = new String[totalDNs];
        ArrayList<StorageType> storageTypesList = new ArrayList<StorageType>(Arrays.asList(StorageType.ARCHIVE, StorageType.DEFAULT, StorageType.DISK, StorageType.RAM_DISK, StorageType.SSD));
        for (int i2 = 0; i2 < providedStorages; ++i2) {
            storageTypesList.add(StorageType.PROVIDED);
        }
        StorageType[] storageTypes = storageTypesList.toArray(new StorageType[0]);
        for (int i3 = 0; i3 < totalDNs; ++i3) {
            String uuid = "UUID-" + i3;
            String ip = "IP-" + i3;
            DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
            Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)uuid);
            Mockito.when((Object)dr.getIpAddr()).thenReturn((Object)ip);
            Mockito.when((Object)dr.getXferAddr()).thenReturn((Object)(ip + ":9000"));
            Mockito.when((Object)dr.getXferPort()).thenReturn((Object)9000);
            Mockito.when((Object)dr.getSoftwareVersion()).thenReturn((Object)"version1");
            dm.registerDatanode(dr);
            locs[i3] = dm.getDatanode(uuid);
            storageIDs[i3] = "storageID-" + i3;
        }
        locs[0].setDecommissioned();
        locs[1].setDecommissioned();
        ExtendedBlock b = new ExtendedBlock("somePoolID", 1234L);
        LocatedBlock block = new LocatedBlock(b, locs, storageIDs, storageTypes);
        ArrayList<LocatedBlock> blocks = new ArrayList<LocatedBlock>();
        blocks.add(block);
        String targetIp = locs[4].getIpAddr();
        dm.sortLocatedBlocks(targetIp, blocks);
        DatanodeInfo[] sortedLocs = block.getLocations();
        storageIDs = block.getStorageIDs();
        storageTypes = block.getStorageTypes();
        Assert.assertThat((Object)sortedLocs.length, (Matcher)Is.is((Object)totalDNs));
        Assert.assertThat((Object)storageIDs.length, (Matcher)Is.is((Object)totalDNs));
        Assert.assertThat((Object)storageTypes.length, (Matcher)Is.is((Object)totalDNs));
        for (i = 0; i < sortedLocs.length; ++i) {
            Assert.assertThat((Object)((DatanodeInfoWithStorage)sortedLocs[i]).getStorageID(), (Matcher)Is.is((Object)storageIDs[i]));
            Assert.assertThat((Object)((DatanodeInfoWithStorage)sortedLocs[i]).getStorageType(), (Matcher)Is.is((Object)storageTypes[i]));
        }
        Assert.assertThat((Object)sortedLocs[0].getIpAddr(), (Matcher)Is.is((Object)targetIp));
        Assert.assertThat((Object)sortedLocs[sortedLocs.length - 1].getAdminState(), (Matcher)Is.is((Object)DatanodeInfo.AdminStates.DECOMMISSIONED));
        Assert.assertThat((Object)sortedLocs[sortedLocs.length - 2].getAdminState(), (Matcher)Is.is((Object)DatanodeInfo.AdminStates.DECOMMISSIONED));
        for (i = 0; i < providedStorages; ++i) {
            Assert.assertThat((Object)((DatanodeInfoWithStorage)sortedLocs[sortedLocs.length - 3 - i]).getStorageType(), (Matcher)Is.is((Object)StorageType.PROVIDED));
        }
    }

    @Test
    public void testRemoveIncludedNode() throws IOException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        DatanodeManager dm = TestDatanodeManager.mockDatanodeManager(fsn, new Configuration());
        HostFileManager hm = new HostFileManager();
        HostSet noNodes = new HostSet();
        HostSet oneNode = new HostSet();
        HostSet twoNodes = new HostSet();
        DatanodeRegistration dr1 = new DatanodeRegistration(new DatanodeID("127.0.0.1", "127.0.0.1", "someStorageID-123", 12345, 12345, 12345, 12345), new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE), new ExportedBlockKeys(), "test");
        DatanodeRegistration dr2 = new DatanodeRegistration(new DatanodeID("127.0.0.1", "127.0.0.1", "someStorageID-234", 23456, 23456, 23456, 23456), new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE), new ExportedBlockKeys(), "test");
        twoNodes.add(TestDatanodeManager.entry("127.0.0.1:12345"));
        twoNodes.add(TestDatanodeManager.entry("127.0.0.1:23456"));
        oneNode.add(TestDatanodeManager.entry("127.0.0.1:23456"));
        hm.refresh(twoNodes, noNodes);
        Whitebox.setInternalState((Object)dm, (String)"hostConfigManager", (Object)hm);
        dm.registerDatanode(dr1);
        dm.registerDatanode(dr2);
        List both = dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
        Collections.sort(both);
        Assert.assertEquals((String)"Incorrect number of hosts reported", (long)2L, (long)both.size());
        Assert.assertEquals((String)"Unexpected host or host in unexpected position", (Object)"127.0.0.1:12345", (Object)((DatanodeDescriptor)both.get(0)).getInfoAddr());
        Assert.assertEquals((String)"Unexpected host or host in unexpected position", (Object)"127.0.0.1:23456", (Object)((DatanodeDescriptor)both.get(1)).getInfoAddr());
        hm.refresh(oneNode, noNodes);
        List onlyOne = dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
        Assert.assertEquals((String)"Incorrect number of hosts reported", (long)1L, (long)onlyOne.size());
        Assert.assertEquals((String)"Unexpected host reported", (Object)"127.0.0.1:23456", (Object)((DatanodeDescriptor)onlyOne.get(0)).getInfoAddr());
        hm.refresh(noNodes, noNodes);
        List bothAgain = dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
        Collections.sort(bothAgain);
        Assert.assertEquals((String)"Incorrect number of hosts reported", (long)2L, (long)bothAgain.size());
        Assert.assertEquals((String)"Unexpected host or host in unexpected position", (Object)"127.0.0.1:12345", (Object)((DatanodeDescriptor)bothAgain.get(0)).getInfoAddr());
        Assert.assertEquals((String)"Unexpected host or host in unexpected position", (Object)"127.0.0.1:23456", (Object)((DatanodeDescriptor)bothAgain.get(1)).getInfoAddr());
    }

    private void verifyPendingRecoveryTasks(int numReplicationBlocks, int numECBlocks, int maxTransfers, int numReplicationTasks, int numECTasks) throws IOException {
        BlockCommand cmd;
        List<Object> tasks;
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        Configuration conf = new Configuration();
        DatanodeManager dm = (DatanodeManager)Mockito.spy((Object)TestDatanodeManager.mockDatanodeManager(fsn, conf));
        DatanodeDescriptor nodeInfo = (DatanodeDescriptor)Mockito.mock(DatanodeDescriptor.class);
        Mockito.when((Object)nodeInfo.isRegistered()).thenReturn((Object)true);
        Mockito.when((Object)nodeInfo.getStorageInfos()).thenReturn((Object)new DatanodeStorageInfo[0]);
        if (numReplicationBlocks > 0) {
            Mockito.when((Object)nodeInfo.getNumberOfReplicateBlocks()).thenReturn((Object)numReplicationBlocks);
            tasks = Collections.nCopies(Math.min(numReplicationTasks, numReplicationBlocks), new DatanodeDescriptor.BlockTargetPair(null, null));
            Mockito.when((Object)nodeInfo.getReplicationCommand(numReplicationTasks)).thenReturn(tasks);
        }
        if (numECBlocks > 0) {
            Mockito.when((Object)nodeInfo.getNumberOfBlocksToBeErasureCoded()).thenReturn((Object)numECBlocks);
            tasks = Collections.nCopies(numECTasks, null);
            Mockito.when((Object)nodeInfo.getErasureCodeCommand(numECTasks)).thenReturn(tasks);
        }
        DatanodeRegistration dnReg = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
        Mockito.when((Object)dm.getDatanode((DatanodeID)dnReg)).thenReturn((Object)nodeInfo);
        DatanodeCommand[] cmds = dm.handleHeartbeat(dnReg, new StorageReport[1], "bp-123", 0L, 0L, 10, maxTransfers, 0, null, SlowPeerReports.EMPTY_REPORT, SlowDiskReports.EMPTY_REPORT);
        long expectedNumCmds = Arrays.stream(new int[]{numReplicationTasks, numECTasks}).filter(x -> x > 0).count();
        Assert.assertEquals((long)expectedNumCmds, (long)cmds.length);
        int idx = 0;
        if (numReplicationTasks > 0) {
            Assert.assertTrue((boolean)(cmds[idx] instanceof BlockCommand));
            cmd = (BlockCommand)cmds[0];
            Assert.assertEquals((long)numReplicationTasks, (long)cmd.getBlocks().length);
            Assert.assertEquals((long)numReplicationTasks, (long)cmd.getTargets().length);
            ++idx;
        }
        if (numECTasks > 0) {
            Assert.assertTrue((boolean)(cmds[idx] instanceof BlockECReconstructionCommand));
            cmd = (BlockECReconstructionCommand)cmds[idx];
            Assert.assertEquals((long)numECTasks, (long)cmd.getECTasks().size());
        }
        ((DatanodeDescriptor)Mockito.verify((Object)nodeInfo)).getReplicationCommand(numReplicationTasks);
        ((DatanodeDescriptor)Mockito.verify((Object)nodeInfo)).getErasureCodeCommand(numECTasks);
    }

    @Test
    public void testPendingRecoveryTasks() throws IOException {
        this.verifyPendingRecoveryTasks(20, 20, 20, 10, 10);
        this.verifyPendingRecoveryTasks(40, 10, 20, 16, 4);
        this.verifyPendingRecoveryTasks(400, 1, 20, 20, 1);
    }

    @Test
    public void testNetworkTopologyInstantiation() throws Exception {
        HdfsConfiguration conf1 = new HdfsConfiguration();
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        DatanodeManager dm1 = TestDatanodeManager.mockDatanodeManager(fsn, (Configuration)conf1);
        Assert.assertEquals(DFSNetworkTopology.class, dm1.getNetworkTopology().getClass());
        HdfsConfiguration conf2 = new HdfsConfiguration();
        conf2.setBoolean("dfs.use.dfs.network.topology", false);
        DatanodeManager dm2 = TestDatanodeManager.mockDatanodeManager(fsn, (Configuration)conf2);
        Assert.assertEquals(NetworkTopology.class, dm2.getNetworkTopology().getClass());
        HdfsConfiguration conf3 = new HdfsConfiguration();
        conf3.setClass("net.topology.impl", MockDfsNetworkTopology.class, NetworkTopology.class);
        conf3.setBoolean("dfs.use.dfs.network.topology", false);
        DatanodeManager dm3 = TestDatanodeManager.mockDatanodeManager(fsn, (Configuration)conf3);
        Assert.assertEquals(MockDfsNetworkTopology.class, dm3.getNetworkTopology().getClass());
        HdfsConfiguration conf4 = new HdfsConfiguration();
        conf4.setClass("dfs.net.topology.impl", MockDfsNetworkTopology.class, NetworkTopology.class);
        conf4.setBoolean("dfs.use.dfs.network.topology", true);
        DatanodeManager dm4 = TestDatanodeManager.mockDatanodeManager(fsn, (Configuration)conf4);
        Assert.assertEquals(MockDfsNetworkTopology.class, dm4.getNetworkTopology().getClass());
    }

    public static class MockDfsNetworkTopology
    extends DFSNetworkTopology {
    }

    public static class MyResolver
    implements DNSToSwitchMapping {
        public List<String> resolve(List<String> names) {
            return null;
        }

        public void reloadCachedMappings() {
        }

        public void reloadCachedMappings(List<String> names) {
        }
    }
}

