/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestDataNodeVolumeMetrics {
    private static final Log LOG = LogFactory.getLog(TestDataNodeVolumeMetrics.class);
    private static final int BLOCK_SIZE = 1024;
    private static final short REPL = 1;
    private static final int NUM_DATANODES = 1;
    @Rule
    public Timeout timeout = new Timeout(300000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVolumeMetrics() throws Exception {
        MiniDFSCluster cluster = this.setupClusterForVolumeMetrics();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path fileName = new Path("/test.dat");
            long fileLen = 0x80000000L;
            DFSTestUtil.createFile((FileSystem)fs, fileName, false, 1024, 0x80000000L, fs.getDefaultBlockSize(fileName), (short)1, 1L, true);
            try (FSDataOutputStream out = fs.append(fileName);){
                out.writeBytes("hello world");
                ((DFSOutputStream)out.getWrappedStream()).hsync();
            }
            this.verifyDataNodeVolumeMetrics((FileSystem)fs, cluster, fileName);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVolumeMetricsWithVolumeDepartureArrival() throws Exception {
        MiniDFSCluster cluster = this.setupClusterForVolumeMetrics();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path fileName = new Path("/test.dat");
            long fileLen = 0x80000000L;
            DFSTestUtil.createFile((FileSystem)fs, fileName, false, 1024, 0x80000000L, fs.getDefaultBlockSize(fileName), (short)1, 1L, true);
            try (FSDataOutputStream out = fs.append(fileName);){
                out.writeBytes("hello world");
                ((DFSOutputStream)out.getWrappedStream()).hsync();
            }
            ArrayList<DataNode> dns = cluster.getDataNodes();
            Assert.assertTrue((String)"DN1 should be up", (boolean)dns.get(0).isDatanodeUp());
            File dn1Vol2 = cluster.getInstanceStorageDir(0, 1);
            DataNodeTestUtils.injectDataDirFailure(dn1Vol2);
            this.verifyDataNodeVolumeMetrics((FileSystem)fs, cluster, fileName);
            DataNodeTestUtils.restoreDataDirFromFailure(dn1Vol2);
            DataNodeTestUtils.reconfigureDataNode(dns.get(0), dn1Vol2);
            this.verifyDataNodeVolumeMetrics((FileSystem)fs, cluster, fileName);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private MiniDFSCluster setupClusterForVolumeMetrics() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.fileio.profiling.sampling.percentage", 100);
        SimulatedFSDataset.setFactory((Configuration)conf);
        return new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.RAM_DISK, StorageType.DISK}).storagesPerDatanode(2).build();
    }

    private void verifyDataNodeVolumeMetrics(FileSystem fs, MiniDFSCluster cluster, Path fileName) throws IOException {
        ArrayList<DataNode> datanodes = cluster.getDataNodes();
        DataNode datanode = (DataNode)datanodes.get(0);
        ExtendedBlock block = DFSTestUtil.getFirstBlock(fs, fileName);
        FsVolumeSpi volume = datanode.getFSDataset().getVolume(block);
        DataNodeVolumeMetrics metrics = volume.getMetrics();
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)volume.getMetrics().name());
        MetricsAsserts.assertCounter((String)"TotalDataFileIos", (long)metrics.getTotalDataFileIos(), (MetricsRecordBuilder)rb);
        LOG.info((Object)("TotalMetadataOperations : " + metrics.getTotalMetadataOperations()));
        LOG.info((Object)("TotalDataFileIos : " + metrics.getTotalDataFileIos()));
        LOG.info((Object)("TotalFileIoErrors : " + metrics.getTotalFileIoErrors()));
        LOG.info((Object)("MetadataOperationSampleCount : " + metrics.getMetadataOperationSampleCount()));
        LOG.info((Object)("MetadataOperationMean : " + metrics.getMetadataOperationMean()));
        LOG.info((Object)("MetadataFileIoStdDev : " + metrics.getMetadataOperationStdDev()));
        LOG.info((Object)("DataFileIoSampleCount : " + metrics.getDataFileIoSampleCount()));
        LOG.info((Object)("DataFileIoMean : " + metrics.getDataFileIoMean()));
        LOG.info((Object)("DataFileIoStdDev : " + metrics.getDataFileIoStdDev()));
        LOG.info((Object)("flushIoSampleCount : " + metrics.getFlushIoSampleCount()));
        LOG.info((Object)("flushIoMean : " + metrics.getFlushIoMean()));
        LOG.info((Object)("flushIoStdDev : " + metrics.getFlushIoStdDev()));
        LOG.info((Object)("syncIoSampleCount : " + metrics.getSyncIoSampleCount()));
        LOG.info((Object)("syncIoMean : " + metrics.getSyncIoMean()));
        LOG.info((Object)("syncIoStdDev : " + metrics.getSyncIoStdDev()));
        LOG.info((Object)("readIoSampleCount : " + metrics.getReadIoMean()));
        LOG.info((Object)("readIoMean : " + metrics.getReadIoMean()));
        LOG.info((Object)("readIoStdDev : " + metrics.getReadIoStdDev()));
        LOG.info((Object)("writeIoSampleCount : " + metrics.getWriteIoSampleCount()));
        LOG.info((Object)("writeIoMean : " + metrics.getWriteIoMean()));
        LOG.info((Object)("writeIoStdDev : " + metrics.getWriteIoStdDev()));
        LOG.info((Object)("fileIoErrorSampleCount : " + metrics.getFileIoErrorSampleCount()));
        LOG.info((Object)("fileIoErrorMean : " + metrics.getFileIoErrorMean()));
        LOG.info((Object)("fileIoErrorStdDev : " + metrics.getFileIoErrorStdDev()));
    }
}

