/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerTestUtil;
import org.apache.hadoop.hdfs.server.diskbalancer.command.ReportCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ConnectorFactory;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.tools.DiskBalancerCLI;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestDiskBalancerCommand {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private MiniDFSCluster cluster;
    private URI clusterJson;
    private Configuration conf = new HdfsConfiguration();
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    private static final int FILE_LEN = 204800;
    private static final long CAPCACITY = 307200L;
    private static final long[] CAPACITIES = new long[]{307200L, 307200L};

    @Before
    public void setUp() throws Exception {
        this.conf.setBoolean("dfs.disk.balancer.enabled", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).storagesPerDatanode(2).build();
        this.cluster.waitActive();
        this.clusterJson = this.getClass().getResource("/diskBalancer/data-cluster-64node-3disk.json").toURI();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            for (int i = 0; i < this.cluster.getDataNodes().size(); ++i) {
                this.cluster.getDataNodes().get(i).shutdown();
            }
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSubmitPlanInNonRegularStatus() throws Exception {
        boolean numDatanodes = true;
        MiniDFSCluster miniCluster = null;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        try {
            miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800, HdfsServerConstants.StartupOption.ROLLBACK);
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            try {
                String cmdLine = String.format("hdfs diskbalancer -%s %s", "execute", planFileFullName);
                this.runCommand(cmdLine, (Configuration)hdfsConf, miniCluster);
            }
            catch (RemoteException e) {
                Assert.assertThat((Object)e.getClassName(), (Matcher)CoreMatchers.containsString((String)"DiskBalancerException"));
                Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Datanode is in special state"), (Matcher)CoreMatchers.containsString((String)"Disk balancing not permitted."))));
            }
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRunMultipleCommandsUnderOneSetup() throws Exception {
        boolean numDatanodes = true;
        MiniDFSCluster miniCluster = null;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        try {
            miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            String cmdLine = String.format("hdfs diskbalancer -%s %s", "execute", planFileFullName);
            this.runCommand(cmdLine, (Configuration)hdfsConf, miniCluster);
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testDiskBalancerExecuteOptionPlanValidityWithException() throws Exception {
        boolean numDatanodes = true;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        hdfsConf.setBoolean("dfs.disk.balancer.enabled", true);
        hdfsConf.set("dfs.disk.balancer.plan.valid.interval", "0d");
        MiniDFSCluster miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
        try {
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            String cmdLine = String.format("hdfs diskbalancer -%s %s", "execute", planFileFullName);
            LambdaTestUtils.intercept(RemoteException.class, (String)"DiskBalancerException", (String)"Plan was generated more than 0d ago", () -> this.lambda$testDiskBalancerExecuteOptionPlanValidityWithException$0(cmdLine, (Configuration)hdfsConf, miniCluster));
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testDiskBalancerExecutePlanValidityWithOutUnitException() throws Exception {
        boolean numDatanodes = true;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        hdfsConf.setBoolean("dfs.disk.balancer.enabled", true);
        hdfsConf.set("dfs.disk.balancer.plan.valid.interval", "0");
        MiniDFSCluster miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
        try {
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            String cmdLine = String.format("hdfs diskbalancer -%s %s", "execute", planFileFullName);
            LambdaTestUtils.intercept(RemoteException.class, (String)"DiskBalancerException", (String)"Plan was generated more than 0ms ago", () -> this.lambda$testDiskBalancerExecutePlanValidityWithOutUnitException$1(cmdLine, (Configuration)hdfsConf, miniCluster));
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testDiskBalancerForceExecute() throws Exception {
        boolean numDatanodes = true;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        hdfsConf.setBoolean("dfs.disk.balancer.enabled", true);
        hdfsConf.set("dfs.disk.balancer.plan.valid.interval", "0d");
        MiniDFSCluster miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
        try {
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            String cmdLine = String.format("hdfs diskbalancer -%s %s -%s", "execute", planFileFullName, "skipDateCheck");
            this.runCommand(cmdLine, (Configuration)hdfsConf, miniCluster);
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testDiskBalancerExecuteOptionPlanValidity() throws Exception {
        boolean numDatanodes = true;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        hdfsConf.setBoolean("dfs.disk.balancer.enabled", true);
        hdfsConf.set("dfs.disk.balancer.plan.valid.interval", "600s");
        MiniDFSCluster miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
        try {
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            String cmdLine = String.format("hdfs diskbalancer -%s %s", "execute", planFileFullName);
            Thread.sleep(10000L);
            this.runCommand(cmdLine, (Configuration)hdfsConf, miniCluster);
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    private String runAndVerifyPlan(MiniDFSCluster miniCluster, Configuration hdfsConf) throws Exception {
        String cmdLine = "";
        List<String> outputs = null;
        DataNode dn = miniCluster.getDataNodes().get(0);
        cmdLine = String.format("hdfs diskbalancer -%s %s", "plan", dn.getDatanodeUuid());
        outputs = this.runCommand(cmdLine, hdfsConf, miniCluster);
        String planFileName = dn.getDatanodeUuid();
        Assert.assertEquals((String)"There must be two lines: the 1st is writing plan to..., the 2nd is actual full path of plan file.", (long)2L, (long)outputs.size());
        Assert.assertThat((Object)outputs.get(1), (Matcher)CoreMatchers.containsString((String)planFileName));
        String planFileFullName = outputs.get(1);
        return planFileFullName;
    }

    @Test(timeout=60000L)
    public void testReportSimple() throws Exception {
        String cmdLine = "hdfs diskbalancer -report";
        List<String> outputs = this.runCommand("hdfs diskbalancer -report");
        Assert.assertThat((Object)outputs.get(0), (Matcher)CoreMatchers.containsString((String)"Processing report command"));
        Assert.assertThat((Object)outputs.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"No top limit specified"), (Matcher)CoreMatchers.containsString((String)"using default top value"), (Matcher)CoreMatchers.containsString((String)"100"))));
        Assert.assertThat((Object)outputs.get(2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Reporting top"), (Matcher)CoreMatchers.containsString((String)"64"), (Matcher)CoreMatchers.containsString((String)"DataNode(s) benefiting from running DiskBalancer"))));
        Assert.assertThat((Object)outputs.get(32), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"30/64 null[null:0]"), (Matcher)CoreMatchers.containsString((String)"a87654a9-54c7-4693-8dd9-c9c7021dc340"), (Matcher)CoreMatchers.containsString((String)"9 volumes with node data density 1.97"))));
    }

    @Test(timeout=60000L)
    public void testReportWithNegativeTopLimit() throws Exception {
        String cmdLine = "hdfs diskbalancer -report -top -32";
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Top limit input should be a positive numeric value");
        this.runCommand("hdfs diskbalancer -report -top -32");
    }

    @Test(timeout=60000L)
    public void testReportLessThanTotal() throws Exception {
        String cmdLine = "hdfs diskbalancer -report -top 32";
        List<String> outputs = this.runCommand("hdfs diskbalancer -report -top 32");
        Assert.assertThat((Object)outputs.get(0), (Matcher)CoreMatchers.containsString((String)"Processing report command"));
        Assert.assertThat((Object)outputs.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Reporting top"), (Matcher)CoreMatchers.containsString((String)"32"), (Matcher)CoreMatchers.containsString((String)"DataNode(s) benefiting from running DiskBalancer"))));
        Assert.assertThat((Object)outputs.get(31), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"30/32 null[null:0]"), (Matcher)CoreMatchers.containsString((String)"a87654a9-54c7-4693-8dd9-c9c7021dc340"), (Matcher)CoreMatchers.containsString((String)"9 volumes with node data density 1.97"))));
    }

    @Test(timeout=60000L)
    public void testReportWithGenericOptionFS() throws Exception {
        String topReportArg = "5";
        String reportArgs = String.format("-%s file:%s -%s -%s %s", "fs", this.clusterJson.getPath(), "report", "top", "5");
        String cmdLine = String.format("%s", reportArgs);
        List<String> outputs = this.runCommand(cmdLine);
        Assert.assertThat((Object)outputs.get(0), (Matcher)CoreMatchers.containsString((String)"Processing report command"));
        Assert.assertThat((Object)outputs.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Reporting top"), (Matcher)CoreMatchers.containsString((String)"5"), (Matcher)CoreMatchers.containsString((String)"DataNode(s) benefiting from running DiskBalancer"))));
    }

    @Test(timeout=60000L)
    public void testReportMoreThanTotal() throws Exception {
        String cmdLine = "hdfs diskbalancer -report -top 128";
        List<String> outputs = this.runCommand("hdfs diskbalancer -report -top 128");
        Assert.assertThat((Object)outputs.get(0), (Matcher)CoreMatchers.containsString((String)"Processing report command"));
        Assert.assertThat((Object)outputs.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Reporting top"), (Matcher)CoreMatchers.containsString((String)"64"), (Matcher)CoreMatchers.containsString((String)"DataNode(s) benefiting from running DiskBalancer"))));
        Assert.assertThat((Object)outputs.get(31), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"30/64 null[null:0]"), (Matcher)CoreMatchers.containsString((String)"a87654a9-54c7-4693-8dd9-c9c7021dc340"), (Matcher)CoreMatchers.containsString((String)"9 volumes with node data density 1.97"))));
    }

    @Test(timeout=60000L)
    public void testReportInvalidTopLimit() throws Exception {
        String cmdLine = "hdfs diskbalancer -report -top xx";
        List<String> outputs = this.runCommand("hdfs diskbalancer -report -top xx");
        Assert.assertThat((Object)outputs.get(0), (Matcher)CoreMatchers.containsString((String)"Processing report command"));
        Assert.assertThat((Object)outputs.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Top limit input is not numeric"), (Matcher)CoreMatchers.containsString((String)"using default top value"), (Matcher)CoreMatchers.containsString((String)"100"))));
        Assert.assertThat((Object)outputs.get(2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Reporting top"), (Matcher)CoreMatchers.containsString((String)"64"), (Matcher)CoreMatchers.containsString((String)"DataNode(s) benefiting from running DiskBalancer"))));
        Assert.assertThat((Object)outputs.get(32), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"30/64 null[null:0]"), (Matcher)CoreMatchers.containsString((String)"a87654a9-54c7-4693-8dd9-c9c7021dc340"), (Matcher)CoreMatchers.containsString((String)"9 volumes with node data density 1.97"))));
    }

    @Test(timeout=60000L)
    public void testReportNode() throws Exception {
        String cmdLine = "hdfs diskbalancer -report -node a87654a9-54c7-4693-8dd9-c9c7021dc340";
        List<String> outputs = this.runCommand("hdfs diskbalancer -report -node a87654a9-54c7-4693-8dd9-c9c7021dc340");
        Assert.assertThat((Object)outputs.get(0), (Matcher)CoreMatchers.containsString((String)"Processing report command"));
        Assert.assertThat((Object)outputs.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Reporting volume information for DataNode"), (Matcher)CoreMatchers.containsString((String)"a87654a9-54c7-4693-8dd9-c9c7021dc340"))));
        Assert.assertThat((Object)outputs.get(2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"null[null:0]"), (Matcher)CoreMatchers.containsString((String)"a87654a9-54c7-4693-8dd9-c9c7021dc340"), (Matcher)CoreMatchers.containsString((String)"9 volumes with node data density 1.97"))));
        Assert.assertThat((Object)outputs.get(3), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"DISK"), (Matcher)CoreMatchers.containsString((String)"/tmp/disk/KmHefYNURo"), (Matcher)CoreMatchers.containsString((String)"0.20 used: 39160240782/200000000000"), (Matcher)CoreMatchers.containsString((String)"0.80 free: 160839759218/200000000000"))));
        Assert.assertThat((Object)outputs.get(4), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"DISK"), (Matcher)CoreMatchers.containsString((String)"/tmp/disk/Mxfcfmb24Y"), (Matcher)CoreMatchers.containsString((String)"0.92 used: 733099315216/800000000000"), (Matcher)CoreMatchers.containsString((String)"0.08 free: 66900684784/800000000000"))));
        Assert.assertThat((Object)outputs.get(5), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"DISK"), (Matcher)CoreMatchers.containsString((String)"/tmp/disk/xx3j3ph3zd"), (Matcher)CoreMatchers.containsString((String)"0.72 used: 289544224916/400000000000"), (Matcher)CoreMatchers.containsString((String)"0.28 free: 110455775084/400000000000"))));
        Assert.assertThat((Object)outputs.get(6), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"RAM_DISK"), (Matcher)CoreMatchers.containsString((String)"/tmp/disk/BoBlQFxhfw"), (Matcher)CoreMatchers.containsString((String)"0.60 used: 477590453390/800000000000"), (Matcher)CoreMatchers.containsString((String)"0.40 free: 322409546610/800000000000"))));
        Assert.assertThat((Object)outputs.get(7), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"RAM_DISK"), (Matcher)CoreMatchers.containsString((String)"/tmp/disk/DtmAygEU6f"), (Matcher)CoreMatchers.containsString((String)"0.34 used: 134602910470/400000000000"), (Matcher)CoreMatchers.containsString((String)"0.66 free: 265397089530/400000000000"))));
        Assert.assertThat((Object)outputs.get(8), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"RAM_DISK"), (Matcher)CoreMatchers.containsString((String)"/tmp/disk/MXRyYsCz3U"), (Matcher)CoreMatchers.containsString((String)"0.55 used: 438102096853/800000000000"), (Matcher)CoreMatchers.containsString((String)"0.45 free: 361897903147/800000000000"))));
        Assert.assertThat((Object)outputs.get(9), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"SSD"), (Matcher)CoreMatchers.containsString((String)"/tmp/disk/BGe09Y77dI"), (Matcher)CoreMatchers.containsString((String)"0.89 used: 890446265501/1000000000000"), (Matcher)CoreMatchers.containsString((String)"0.11 free: 109553734499/1000000000000"))));
        Assert.assertThat((Object)outputs.get(10), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"SSD"), (Matcher)CoreMatchers.containsString((String)"/tmp/disk/JX3H8iHggM"), (Matcher)CoreMatchers.containsString((String)"0.31 used: 2782614512957/9000000000000"), (Matcher)CoreMatchers.containsString((String)"0.69 free: 6217385487043/9000000000000"))));
        Assert.assertThat((Object)outputs.get(11), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"SSD"), (Matcher)CoreMatchers.containsString((String)"/tmp/disk/uLOYmVZfWV"), (Matcher)CoreMatchers.containsString((String)"0.75 used: 1509592146007/2000000000000"), (Matcher)CoreMatchers.containsString((String)"0.25 free: 490407853993/2000000000000"))));
    }

    @Test(timeout=60000L)
    public void testReportNodeWithoutJson() throws Exception {
        String dataNodeUuid = this.cluster.getDataNodes().get(0).getDatanodeUuid();
        String planArg = String.format("-%s -%s %s", "report", "node", dataNodeUuid);
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        Assert.assertThat((Object)outputs.get(0), (Matcher)CoreMatchers.containsString((String)"Processing report command"));
        Assert.assertThat((Object)outputs.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Reporting volume information for DataNode"), (Matcher)CoreMatchers.containsString((String)dataNodeUuid))));
        Assert.assertThat((Object)outputs.get(2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)dataNodeUuid), (Matcher)CoreMatchers.containsString((String)"2 volumes with node data density 0.00"))));
        Assert.assertThat((Object)outputs.get(3), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"DISK"), (Matcher)CoreMatchers.containsString((String)new Path(this.cluster.getInstanceStorageDir(0, 0).getAbsolutePath()).toString()), (Matcher)CoreMatchers.containsString((String)"0.00"), (Matcher)CoreMatchers.containsString((String)"1.00"))));
        Assert.assertThat((Object)outputs.get(4), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"DISK"), (Matcher)CoreMatchers.containsString((String)new Path(this.cluster.getInstanceStorageDir(0, 1).getAbsolutePath()).toString()), (Matcher)CoreMatchers.containsString((String)"0.00"), (Matcher)CoreMatchers.containsString((String)"1.00"))));
    }

    @Test(timeout=60000L)
    public void testReadClusterFromJson() throws Exception {
        ClusterConnector jsonConnector = ConnectorFactory.getCluster((URI)this.clusterJson, (Configuration)this.conf);
        DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(jsonConnector);
        diskBalancerCluster.readClusterInfo();
        Assert.assertEquals((long)64L, (long)diskBalancerCluster.getNodes().size());
    }

    @Test(timeout=60000L)
    public void testPlanNode() throws Exception {
        String planArg = String.format("-%s %s", "plan", this.cluster.getDataNodes().get(0).getDatanodeUuid());
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        this.runCommand(cmdLine, this.cluster);
    }

    @Test(timeout=60000L)
    public void testPlanJsonNode() throws Exception {
        String planArg = String.format("-%s %s", "plan", "a87654a9-54c7-4693-8dd9-c9c7021dc340");
        Path testPath = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        String cmdLine = String.format("hdfs diskbalancer -out %s %s", testPath, planArg);
        this.runCommand(cmdLine);
    }

    @Test(timeout=60000L)
    public void testIllegalArgument() throws Exception {
        String planArg = String.format("-%s %s", "plan", "a87654a9-54c7-4693-8dd9-c9c7021dc340");
        String cmdLine = String.format("hdfs diskbalancer %s -report", planArg);
        this.thrown.expect(IllegalArgumentException.class);
        this.runCommand(cmdLine);
    }

    @Test(timeout=60000L)
    public void testCancelCommand() throws Exception {
        String cancelArg = String.format("-%s %s", "cancel", "nosuchplan");
        String nodeArg = String.format("-%s %s", "node", this.cluster.getDataNodes().get(0).getDatanodeUuid());
        this.thrown.expect(IllegalArgumentException.class);
        String cmdLine = String.format("hdfs diskbalancer  %s %s", cancelArg, nodeArg);
        this.runCommand(cmdLine);
    }

    @Test(timeout=60000L)
    public void testQueryCommand() throws Exception {
        String queryArg = String.format("-%s %s", "query", this.cluster.getDataNodes().get(0).getDatanodeUuid());
        this.thrown.expect(UnknownHostException.class);
        String cmdLine = String.format("hdfs diskbalancer %s", queryArg);
        this.runCommand(cmdLine);
    }

    @Test(timeout=60000L)
    public void testHelpCommand() throws Exception {
        String helpArg = String.format("-%s", "help");
        String cmdLine = String.format("hdfs diskbalancer %s", helpArg);
        this.runCommand(cmdLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrintFullPathOfPlan() throws Exception {
        String parent = GenericTestUtils.getRandomizedTempPath();
        MiniDFSCluster miniCluster = null;
        try {
            HdfsConfiguration hdfsConf = new HdfsConfiguration();
            List<String> outputs = null;
            miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
            String cmdLine = String.format("hdfs diskbalancer -%s %s -%s %s", "plan", miniCluster.getDataNodes().get(0).getDatanodeUuid(), "out", parent);
            outputs = this.runCommand(cmdLine, (Configuration)hdfsConf, miniCluster);
            String planFileFullName = new Path(parent, miniCluster.getDataNodes().get(0).getDatanodeUuid()).toString();
            Assert.assertEquals((String)"There must be two lines: the 1st is writing plan to, the 2nd is actual full path of plan file.", (long)2L, (long)outputs.size());
            Assert.assertThat((Object)outputs.get(0), (Matcher)CoreMatchers.containsString((String)"Writing plan to"));
            Assert.assertThat((Object)outputs.get(1), (Matcher)CoreMatchers.containsString((String)planFileFullName));
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    private List<String> runCommandInternal(String cmdLine, Configuration clusterConf) throws Exception {
        String[] cmds = StringUtils.split((String)cmdLine, (char)' ');
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bufOut);
        DiskBalancerCLI diskBalancerTool = new DiskBalancerCLI(clusterConf, out);
        ToolRunner.run((Configuration)clusterConf, (Tool)diskBalancerTool, (String[])cmds);
        Scanner scanner = new Scanner(bufOut.toString());
        ArrayList outputs = Lists.newArrayList();
        while (scanner.hasNextLine()) {
            outputs.add(scanner.nextLine());
        }
        return outputs;
    }

    private List<String> runCommandInternal(String cmdLine) throws Exception {
        return this.runCommandInternal(cmdLine, this.conf);
    }

    private List<String> runCommand(String cmdLine) throws Exception {
        FileSystem.setDefaultUri((Configuration)this.conf, (URI)this.clusterJson);
        return this.runCommandInternal(cmdLine);
    }

    private List<String> runCommand(String cmdLine, MiniDFSCluster miniCluster) throws Exception {
        FileSystem.setDefaultUri((Configuration)this.conf, (URI)miniCluster.getURI());
        return this.runCommandInternal(cmdLine);
    }

    private List<String> runCommand(String cmdLine, Configuration clusterConf, MiniDFSCluster miniCluster) throws Exception {
        FileSystem.setDefaultUri((Configuration)clusterConf, (URI)miniCluster.getURI());
        return this.runCommandInternal(cmdLine, clusterConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiskBalancerQueryWithoutSubmit() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.disk.balancer.enabled", true);
        int numDatanodes = 2;
        File basedir = new File(GenericTestUtils.getRandomizedTempPath());
        MiniDFSCluster miniDFSCluster = new MiniDFSCluster.Builder((Configuration)conf, basedir).numDataNodes(2).build();
        try {
            miniDFSCluster.waitActive();
            DataNode dataNode = miniDFSCluster.getDataNodes().get(0);
            String queryArg = String.format("-query localhost:%d", dataNode.getIpcPort());
            String cmdLine = String.format("hdfs diskbalancer %s", queryArg);
            this.runCommand(cmdLine);
        }
        finally {
            miniDFSCluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testGetNodeList() throws Exception {
        ClusterConnector jsonConnector = ConnectorFactory.getCluster((URI)this.clusterJson, (Configuration)this.conf);
        DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(jsonConnector);
        diskBalancerCluster.readClusterInfo();
        int nodeNum = 5;
        StringBuilder listArg = new StringBuilder();
        for (int i = 0; i < nodeNum; ++i) {
            listArg.append(((DiskBalancerDataNode)diskBalancerCluster.getNodes().get(i)).getDataNodeUUID()).append(",");
        }
        ReportCommand command = new ReportCommand(this.conf, null);
        command.setCluster(diskBalancerCluster);
        List nodeList = command.getNodes(listArg.toString());
        Assert.assertEquals((long)nodeNum, (long)nodeList.size());
    }

    @Test(timeout=60000L)
    public void testReportCommandWithMultipleNodes() throws Exception {
        String dataNodeUuid1 = this.cluster.getDataNodes().get(0).getDatanodeUuid();
        String dataNodeUuid2 = this.cluster.getDataNodes().get(1).getDatanodeUuid();
        String planArg = String.format("-%s -%s %s,%s", "report", "node", dataNodeUuid1, dataNodeUuid2);
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        this.verifyOutputsOfReportCommand(outputs, dataNodeUuid1, dataNodeUuid2, true);
    }

    private void verifyOutputsOfReportCommand(List<String> outputs, String dataNodeUuid1, String dataNodeUuid2, boolean inputNodesStr) {
        Assert.assertThat((Object)outputs.get(0), (Matcher)CoreMatchers.containsString((String)"Processing report command"));
        if (inputNodesStr) {
            Assert.assertThat((Object)outputs.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Reporting volume information for DataNode"), (Matcher)CoreMatchers.containsString((String)dataNodeUuid1), (Matcher)CoreMatchers.containsString((String)dataNodeUuid2))));
        }
        Assert.assertTrue((outputs.get(2).contains(dataNodeUuid1) || outputs.get(6).contains(dataNodeUuid1) ? 1 : 0) != 0);
        Assert.assertTrue((outputs.get(2).contains(dataNodeUuid2) || outputs.get(6).contains(dataNodeUuid2) ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testReportCommandWithInvalidNode() throws Exception {
        String dataNodeUuid1 = this.cluster.getDataNodes().get(0).getDatanodeUuid();
        String invalidNode = "invalidNode";
        String planArg = String.format("-%s -%s %s,%s", "report", "node", dataNodeUuid1, invalidNode);
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        Assert.assertThat((Object)outputs.get(0), (Matcher)CoreMatchers.containsString((String)"Processing report command"));
        Assert.assertThat((Object)outputs.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Reporting volume information for DataNode"), (Matcher)CoreMatchers.containsString((String)dataNodeUuid1), (Matcher)CoreMatchers.containsString((String)invalidNode))));
        String invalidNodeInfo = String.format("The node(s) '%s' not found. Please make sure that '%s' exists in the cluster.", invalidNode, invalidNode);
        Assert.assertTrue((boolean)outputs.get(2).contains(invalidNodeInfo));
    }

    @Test(timeout=60000L)
    public void testReportCommandWithNullNodes() throws Exception {
        String planArg = String.format("-%s -%s ,", "report", "node");
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        String invalidNodeInfo = "The number of input nodes is 0. Please input the valid nodes.";
        Assert.assertTrue((boolean)outputs.get(2).contains(invalidNodeInfo));
    }

    @Test(timeout=60000L)
    public void testReportCommandWithReadingHostFile() throws Exception {
        String testDir = GenericTestUtils.getTestDir().getAbsolutePath();
        File includeFile = new File(testDir, "diskbalancer.include");
        String filePath = testDir + "/diskbalancer.include";
        String dataNodeUuid1 = this.cluster.getDataNodes().get(0).getDatanodeUuid();
        String dataNodeUuid2 = this.cluster.getDataNodes().get(1).getDatanodeUuid();
        FileWriter fw = new FileWriter(filePath);
        fw.write("#This-is-comment\n");
        fw.write(dataNodeUuid1 + "\n");
        fw.write(dataNodeUuid2 + "\n");
        fw.close();
        String planArg = String.format("-%s -%s file://%s", "report", "node", filePath);
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        this.verifyOutputsOfReportCommand(outputs, dataNodeUuid1, dataNodeUuid2, false);
        includeFile.delete();
    }

    @Test(timeout=60000L)
    public void testReportCommandWithInvalidHostFilePath() throws Exception {
        String testDir = GenericTestUtils.getTestDir().getAbsolutePath();
        String invalidFilePath = testDir + "/diskbalancer-invalid.include";
        String planArg = String.format("-%s -%s file://%s", "report", "node", invalidFilePath);
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        String invalidNodeInfo = String.format("The input host file path 'file://%s' is not a valid path.", invalidFilePath);
        Assert.assertTrue((boolean)outputs.get(2).contains(invalidNodeInfo));
    }

    private /* synthetic */ void lambda$testDiskBalancerExecutePlanValidityWithOutUnitException$1(String cmdLine, Configuration hdfsConf, MiniDFSCluster miniCluster) throws Exception {
        this.runCommand(cmdLine, hdfsConf, miniCluster);
    }

    private /* synthetic */ void lambda$testDiskBalancerExecuteOptionPlanValidityWithException$0(String cmdLine, Configuration hdfsConf, MiniDFSCluster miniCluster) throws Exception {
        this.runCommand(cmdLine, hdfsConf, miniCluster);
    }
}

