/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class FSAclBaseTest {
    private static final UserGroupInformation BRUCE = UserGroupInformation.createUserForTesting((String)"bruce", (String[])new String[0]);
    private static final UserGroupInformation DIANA = UserGroupInformation.createUserForTesting((String)"diana", (String[])new String[0]);
    private static final UserGroupInformation SUPERGROUP_MEMBER = UserGroupInformation.createUserForTesting((String)"super", (String[])new String[]{"supergroup"});
    private static final UserGroupInformation BOB = UserGroupInformation.createUserForTesting((String)"bob", (String[])new String[]{"groupY", "groupZ"});
    protected static MiniDFSCluster cluster;
    protected static Configuration conf;
    private static int pathCount;
    private static Path path;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private FileSystem fs;
    private FileSystem fsAsBruce;
    private FileSystem fsAsDiana;
    private FileSystem fsAsSupergroupMember;
    private FileSystem fsAsBob;

    protected static void startCluster() throws IOException {
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
    }

    @AfterClass
    public static void shutdown() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        path = new Path("/p" + ++pathCount);
        this.initFileSystems();
    }

    @After
    public void destroyFileSystems() {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.fs, this.fsAsBruce, this.fsAsDiana, this.fsAsSupergroupMember});
        this.fsAsBob = null;
        this.fsAsSupergroupMember = null;
        this.fsAsDiana = null;
        this.fsAsBruce = null;
        this.fs = null;
    }

    @Test
    public void testModifyAclEntries() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Assert.assertTrue((String)(path + " should have ACLs in FileStatus!"), (boolean)this.fs.getFileStatus(path).hasAcl());
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        Assert.assertTrue((String)(path + " should have ACLs in FileStatus!"), (boolean)this.fs.getFileStatus(path).hasAcl());
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesMinimal() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_WRITE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4528);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesMinimalDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesCustomMask() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.NONE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4480);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)5096);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testModifyAclEntriesPathNotFound() throws IOException {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testModifyAclEntriesDefaultOnFile() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
    }

    @Test
    public void testRemoveAclEntries() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo")});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE)}, (Object[])returned);
        this.assertPermission((short)4592);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bar", FsAction.READ_EXECUTE)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesMinimal() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)496));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK)});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)496);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclEntriesMinimalDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK)});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)5096);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveAclEntriesPathNotFound() throws IOException {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo")});
        this.fs.removeAclEntries(path, (List)aclSpec);
    }

    @Test
    public void testRemoveDefaultAcl() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
        this.restartCluster();
        s = this.fs.getAclStatus(path);
        Object[] afterRestart = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])returned, (Object[])afterRestart);
    }

    @Test
    public void testRemoveDefaultAclOnlyAccess() throws Exception {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
        this.restartCluster();
        s = this.fs.getAclStatus(path);
        Object[] afterRestart = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])returned, (Object[])afterRestart);
    }

    @Test
    public void testRemoveDefaultAclOnlyDefault() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
        this.restartCluster();
        s = this.fs.getAclStatus(path);
        Object[] afterRestart = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])returned, (Object[])afterRestart);
    }

    @Test
    public void testRemoveDefaultAclMinimal() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
        this.restartCluster();
        s = this.fs.getAclStatus(path);
        Object[] afterRestart = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])returned, (Object[])afterRestart);
    }

    @Test
    public void testRemoveDefaultAclStickyBit() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)5112);
        FSAclBaseTest.assertAclFeature(true);
        this.restartCluster();
        s = this.fs.getAclStatus(path);
        Object[] afterRestart = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])returned, (Object[])afterRestart);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveDefaultAclPathNotFound() throws IOException {
        this.fs.removeDefaultAcl(path);
    }

    @Test
    public void testRemoveAcl() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Assert.assertTrue((String)(path + " should have ACLs in FileStatus!"), (boolean)this.fs.getFileStatus(path).hasAcl());
        Assert.assertTrue((String)(path + " should have ACLs in FileStatus#toString()!"), (boolean)this.fs.getFileStatus(path).toString().contains("hasAcl=true"));
        this.fs.removeAcl(path);
        Assert.assertFalse((String)(path + " should not have ACLs in FileStatus!"), (boolean)this.fs.getFileStatus(path).hasAcl());
        Assert.assertTrue((String)(path + " should not have ACLs in FileStatus#toString()!"), (boolean)this.fs.getFileStatus(path).toString().contains("hasAcl=false"));
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclMinimalAcl() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        this.fs.removeAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)416);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)1000);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveAclPathNotFound() throws IOException {
        this.fs.removeAcl(path);
    }

    @Test
    public void testSetAcl() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4512);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclMinimal() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)420));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)416);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testSetAclMinimalDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclCustomMask() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4536);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)5112);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSetAclPathNotFound() throws IOException {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testSetAclDefaultOnFile() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
    }

    @Test
    public void testSetPermission() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.setPermission(path, FsPermission.createImmutable((short)448));
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4544);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.setPermission(path, FsPermission.createImmutable((short)384));
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4480);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.setPermission(path, FsPermission.createImmutable((short)448));
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4544);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionCannotSetAclBit() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setPermission(path, FsPermission.createImmutable((short)448));
        this.assertPermission((short)448);
        this.fs.setPermission(path, (FsPermission)new FsPermissionExtension(FsPermission.createImmutable((short)493), true, true, true));
        INode inode = cluster.getNamesystem().getFSDirectory().getINode(path.toUri().getPath(), FSDirectory.DirOp.READ_LINK);
        Assert.assertNotNull((Object)inode);
        FsPermission perm = inode.getFsPermission();
        Assert.assertNotNull((Object)perm);
        Assert.assertEquals((long)493L, (long)perm.toShort());
        FileStatus stat = this.fs.getFileStatus(path);
        Assert.assertFalse((boolean)stat.hasAcl());
        Assert.assertFalse((boolean)stat.isEncrypted());
        Assert.assertFalse((boolean)stat.isErasureCoded());
        Assert.assertEquals((long)493L, (long)perm.toExtendedShort());
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testDefaultAclNewFile() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(filePath, (short)4528);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUMaskDefaultAclNewFile() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        String oldUMask = this.fs.getConf().get("fs.permissions.umask-mode");
        this.fs.getConf().set("fs.permissions.umask-mode", "027");
        FSDirectory fsDirectory = cluster.getNamesystem().getFSDirectory();
        boolean oldEnabled = fsDirectory.isPosixAclInheritanceEnabled();
        try {
            fsDirectory.setPosixAclInheritanceEnabled(false);
            Path filePath = new Path(path, "file1");
            this.fs.create(filePath).close();
            AclStatus s = this.fs.getAclStatus(filePath);
            Object[] returned = s.getEntries().toArray(new AclEntry[0]);
            Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE)}, (Object[])returned);
            this.assertPermission(filePath, (short)4512);
            fsDirectory.setPosixAclInheritanceEnabled(true);
            Path file2Path = new Path(path, "file2");
            this.fs.create(file2Path).close();
            AclStatus s2 = this.fs.getAclStatus(file2Path);
            Object[] returned2 = s2.getEntries().toArray(new AclEntry[0]);
            Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE)}, (Object[])returned2);
            this.assertPermission(file2Path, (short)4528);
        }
        finally {
            fsDirectory.setPosixAclInheritanceEnabled(oldEnabled);
            this.fs.getConf().set("fs.permissions.umask-mode", oldUMask);
        }
    }

    @Test
    public void testOnlyAccessAclNewFile() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission(filePath, (short)420);
        FSAclBaseTest.assertAclFeature(filePath, false);
    }

    @Test
    public void testDefaultMinimalAclNewFile() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission(filePath, (short)416);
        FSAclBaseTest.assertAclFeature(filePath, false);
    }

    @Test
    public void testDefaultAclNewDir() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Assert.assertTrue((String)(path + " should have ACLs in FileStatus!"), (boolean)this.fs.getFileStatus(path).hasAcl());
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath);
        Assert.assertTrue((String)(dirPath + " should have ACLs in FileStatus!"), (boolean)this.fs.getFileStatus(dirPath).hasAcl());
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission(dirPath, (short)4600);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUMaskDefaultAclNewDir() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        String oldUMask = this.fs.getConf().get("fs.permissions.umask-mode");
        this.fs.getConf().set("fs.permissions.umask-mode", "027");
        FSDirectory fsDirectory = cluster.getNamesystem().getFSDirectory();
        boolean oldEnabled = fsDirectory.isPosixAclInheritanceEnabled();
        try {
            fsDirectory.setPosixAclInheritanceEnabled(false);
            Path dirPath = new Path(path, "dir1");
            this.fs.mkdirs(dirPath);
            AclStatus s = this.fs.getAclStatus(dirPath);
            Object[] returned = s.getEntries().toArray(new AclEntry[0]);
            Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
            this.assertPermission(dirPath, (short)4584);
            fsDirectory.setPosixAclInheritanceEnabled(true);
            Path dir2Path = new Path(path, "dir2");
            this.fs.mkdirs(dir2Path);
            AclStatus s2 = this.fs.getAclStatus(dir2Path);
            Object[] returned2 = s2.getEntries().toArray(new AclEntry[0]);
            Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned2);
            this.assertPermission(dir2Path, (short)4600);
        }
        finally {
            fsDirectory.setPosixAclInheritanceEnabled(oldEnabled);
            this.fs.getConf().set("fs.permissions.umask-mode", oldUMask);
        }
    }

    @Test
    public void testOnlyAccessAclNewDir() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath);
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission(dirPath, (short)493);
        FSAclBaseTest.assertAclFeature(dirPath, false);
    }

    @Test
    public void testDefaultMinimalAclNewDir() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath);
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission(dirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    @Test
    public void testDefaultAclNewFileIntermediate() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path filePath = new Path(dirPath, "file1");
        this.fs.create(filePath).close();
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)};
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(dirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        s = this.fs.getAclStatus(filePath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(filePath, (short)4528);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testDefaultAclNewDirIntermediate() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path subdirPath = new Path(dirPath, "subdir1");
        this.fs.mkdirs(subdirPath);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)};
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(dirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        s = this.fs.getAclStatus(subdirPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(subdirPath, (short)4600);
        FSAclBaseTest.assertAclFeature(subdirPath, true);
    }

    @Test
    public void testDefaultAclNewSymlinkIntermediate() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        this.fs.setPermission(filePath, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path linkPath = new Path(dirPath, "link1");
        this.fs.createSymlink(filePath, linkPath, true);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)};
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(dirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        expected = new AclEntry[]{};
        s = this.fs.getAclStatus(linkPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(linkPath, (short)416);
        FSAclBaseTest.assertAclFeature(linkPath, false);
        s = this.fs.getAclStatus(filePath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(filePath, (short)416);
        FSAclBaseTest.assertAclFeature(filePath, false);
    }

    @Test
    public void testDefaultAclNewFileWithMode() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)493));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        int bufferSize = cluster.getConfiguration(0).getInt("io.file.buffer.size", 4096);
        this.fs.create(filePath, new FsPermission(480), false, bufferSize, this.fs.getDefaultReplication(filePath), this.fs.getDefaultBlockSize(path), null).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(filePath, (short)4576);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testDefaultAclNewDirWithMode() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)493));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath, new FsPermission(480));
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(dirPath, (short)4576);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    @Test
    public void testDefaultAclRenamedFile() throws Exception {
        Path dirPath = new Path(path, "dir");
        FileSystem.mkdirs((FileSystem)this.fs, (Path)dirPath, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(dirPath, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        this.fs.setPermission(filePath, FsPermission.createImmutable((short)416));
        Path renamedFilePath = new Path(dirPath, "file1");
        this.fs.rename(filePath, renamedFilePath);
        Object[] expected = new AclEntry[]{};
        AclStatus s = this.fs.getAclStatus(renamedFilePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(renamedFilePath, (short)416);
        FSAclBaseTest.assertAclFeature(renamedFilePath, false);
    }

    @Test
    public void testDefaultAclRenamedDir() throws Exception {
        Path dirPath = new Path(path, "dir");
        FileSystem.mkdirs((FileSystem)this.fs, (Path)dirPath, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(dirPath, (List)aclSpec);
        Path subdirPath = new Path(path, "subdir");
        FileSystem.mkdirs((FileSystem)this.fs, (Path)subdirPath, (FsPermission)FsPermission.createImmutable((short)488));
        Path renamedSubdirPath = new Path(dirPath, "subdir");
        this.fs.rename(subdirPath, renamedSubdirPath);
        Object[] expected = new AclEntry[]{};
        AclStatus s = this.fs.getAclStatus(renamedSubdirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(renamedSubdirPath, (short)488);
        FSAclBaseTest.assertAclFeature(renamedSubdirPath, false);
    }

    @Test
    public void testSkipAclEnforcementPermsDisabled() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        this.fsAsBruce.modifyAclEntries(bruceFile, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.NONE)}));
        AclTestHelpers.assertFilePermissionDenied(this.fsAsDiana, DIANA, bruceFile);
        try {
            conf.setBoolean("dfs.permissions.enabled", false);
            this.restartCluster();
            AclTestHelpers.assertFilePermissionGranted(this.fsAsDiana, DIANA, bruceFile);
        }
        finally {
            conf.setBoolean("dfs.permissions.enabled", true);
            this.restartCluster();
        }
    }

    @Test
    public void testSkipAclEnforcementSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        this.fsAsBruce.modifyAclEntries(bruceFile, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.NONE)}));
        AclTestHelpers.assertFilePermissionGranted(this.fs, DIANA, bruceFile);
        AclTestHelpers.assertFilePermissionGranted(this.fsAsBruce, DIANA, bruceFile);
        AclTestHelpers.assertFilePermissionDenied(this.fsAsDiana, DIANA, bruceFile);
        AclTestHelpers.assertFilePermissionGranted(this.fsAsSupergroupMember, SUPERGROUP_MEMBER, bruceFile);
    }

    @Test
    public void testModifyAclEntriesMustBeOwnerOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.ALL)});
        this.fsAsBruce.modifyAclEntries(bruceFile, (List)aclSpec);
        this.fs.modifyAclEntries(bruceFile, (List)aclSpec);
        this.fsAsSupergroupMember.modifyAclEntries(bruceFile, (List)aclSpec);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.modifyAclEntries(bruceFile, (List)aclSpec);
    }

    @Test
    public void testRemoveAclEntriesMustBeOwnerOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana")});
        this.fsAsBruce.removeAclEntries(bruceFile, (List)aclSpec);
        this.fs.removeAclEntries(bruceFile, (List)aclSpec);
        this.fsAsSupergroupMember.removeAclEntries(bruceFile, (List)aclSpec);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.removeAclEntries(bruceFile, (List)aclSpec);
    }

    @Test
    public void testRemoveDefaultAclMustBeOwnerOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        this.fsAsBruce.removeDefaultAcl(bruceFile);
        this.fs.removeDefaultAcl(bruceFile);
        this.fsAsSupergroupMember.removeDefaultAcl(bruceFile);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.removeDefaultAcl(bruceFile);
    }

    @Test
    public void testRemoveAclMustBeOwnerOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        this.fsAsBruce.removeAcl(bruceFile);
        this.fs.removeAcl(bruceFile);
        this.fsAsSupergroupMember.removeAcl(bruceFile);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.removeAcl(bruceFile);
    }

    @Test
    public void testSetAclMustBeOwnerOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)});
        this.fsAsBruce.setAcl(bruceFile, (List)aclSpec);
        this.fs.setAcl(bruceFile, (List)aclSpec);
        this.fsAsSupergroupMember.setAcl(bruceFile, (List)aclSpec);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.setAcl(bruceFile, (List)aclSpec);
    }

    @Test
    public void testGetAclStatusRequiresTraverseOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        this.fsAsBruce.setAcl(bruceDir, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)}));
        this.fsAsBruce.getAclStatus(bruceFile);
        this.fs.getAclStatus(bruceFile);
        this.fsAsSupergroupMember.getAclStatus(bruceFile);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.getAclStatus(bruceFile);
    }

    @Test
    public void testAccess() throws IOException, InterruptedException {
        Path p1 = new Path("/p1");
        this.fs.mkdirs(p1);
        this.fs.setOwner(p1, BRUCE.getShortUserName(), "groupX");
        this.fsAsBruce.setAcl(p1, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)}));
        this.fsAsBruce.access(p1, FsAction.READ);
        try {
            this.fsAsBruce.access(p1, FsAction.WRITE);
            Assert.fail((String)"The access call should have failed.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        Path badPath = new Path("/bad/bad");
        try {
            this.fsAsBruce.access(badPath, FsAction.READ);
            Assert.fail((String)"The access call should have failed");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.fsAsBruce.modifyAclEntries(p1, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "groupY", FsAction.READ)}));
        this.fsAsBob.access(p1, FsAction.READ);
        try {
            this.fsAsBob.access(p1, FsAction.WRITE);
            Assert.fail((String)"The access call should have failed.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.fsAsBruce.modifyAclEntries(p1, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "groupZ", FsAction.WRITE)}));
        this.fsAsBob.access(p1, FsAction.WRITE);
        this.fsAsBruce.modifyAclEntries(p1, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bob", FsAction.NONE)}));
        try {
            this.fsAsBob.access(p1, FsAction.READ);
            Assert.fail((String)"The access call should have failed.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Test
    public void testEffectiveAccess() throws Exception {
        Path p1 = new Path("/testEffectiveAccess");
        this.fs.mkdirs(p1);
        this.fs.setPermission(p1, FsPermission.valueOf((String)"-rwxrwxrwx"));
        AclStatus aclStatus = this.fs.getAclStatus(p1);
        Assert.assertEquals((String)"Entries should be empty", (long)0L, (long)aclStatus.getEntries().size());
        Assert.assertEquals((String)"Permission should be carried by AclStatus", (Object)this.fs.getFileStatus(p1).getPermission(), (Object)aclStatus.getPermission());
        this.fs.modifyAclEntries(p1, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "groupY", FsAction.ALL)}));
        aclStatus = this.fs.getAclStatus(p1);
        Assert.assertEquals((String)"Entries should contain owner group entry also", (long)3L, (long)aclStatus.getEntries().size());
        this.fs.setPermission(p1, FsPermission.valueOf((String)"-rwxr-----"));
        aclStatus = this.fs.getAclStatus(p1);
        List entries = aclStatus.getEntries();
        for (AclEntry aclEntry : entries) {
            if (aclEntry.getName() == null && aclEntry.getType() != AclEntryType.GROUP) continue;
            Assert.assertEquals((Object)FsAction.ALL, (Object)aclEntry.getPermission());
            Assert.assertEquals((Object)FsAction.READ, (Object)aclStatus.getEffectivePermission(aclEntry));
        }
        this.fsAsBruce.access(p1, FsAction.READ);
        try {
            this.fsAsBruce.access(p1, FsAction.WRITE);
            Assert.fail((String)"Access should not be given");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.fsAsBob.access(p1, FsAction.READ);
        try {
            this.fsAsBob.access(p1, FsAction.WRITE);
            Assert.fail((String)"Access should not be given");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Test
    public void testDeDuplication() throws Exception {
        int before;
        FSAclBaseTest.shutdown();
        AclStorage.getUniqueAclFeatures().clear();
        FSAclBaseTest.startCluster();
        this.setUp();
        int currentSize = 0;
        Path p1 = new Path("/testDeduplication");
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "testdeduplicateuser", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "testdeduplicategroup", FsAction.ALL)});
        this.fs.mkdirs(p1);
        this.fs.modifyAclEntries(p1, (List)aclSpec);
        Assert.assertEquals((String)"One more ACL feature should be unique", (long)(currentSize + 1), (long)AclStorage.getUniqueAclFeatures().getUniqueElementsSize());
        Path child1 = new Path(p1, "child1");
        this.fs.mkdirs(child1);
        Assert.assertEquals((String)"One more ACL feature should be unique", (long)(++currentSize + 1), (long)AclStorage.getUniqueAclFeatures().getUniqueElementsSize());
        AclFeature child1AclFeature = FSAclBaseTest.getAclFeature(child1, cluster);
        Assert.assertEquals((String)"Reference count should be 1", (long)1L, (long)child1AclFeature.getRefCount());
        Path child2 = new Path(p1, "child2");
        this.fs.mkdirs(child2);
        Assert.assertEquals((String)"existing AclFeature should be re-used", (long)(++currentSize), (long)AclStorage.getUniqueAclFeatures().getUniqueElementsSize());
        AclFeature child2AclFeature = FSAclBaseTest.getAclFeature(child1, cluster);
        Assert.assertSame((String)"Same Aclfeature should be re-used", (Object)child1AclFeature, (Object)child2AclFeature);
        Assert.assertEquals((String)"Reference count should be 2", (long)2L, (long)child2AclFeature.getRefCount());
        ArrayList aclSpec2 = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "user1", FsAction.ALL)});
        this.fs.modifyAclEntries(child1, (List)aclSpec2);
        AclFeature modifiedAclFeature = FSAclBaseTest.getAclFeature(child1, cluster);
        Assert.assertEquals((String)"Old Reference count should be 1", (long)1L, (long)child1AclFeature.getRefCount());
        Assert.assertEquals((String)"New Reference count should be 1", (long)1L, (long)modifiedAclFeature.getRefCount());
        AclEntry aclEntry = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setName("user1").build();
        this.fs.removeAclEntries(child1, (List)Lists.newArrayList((Object[])new AclEntry[]{aclEntry}));
        Assert.assertEquals((String)"Old Reference count should be 2 again", (long)2L, (long)child1AclFeature.getRefCount());
        Assert.assertEquals((String)"New Reference count should be 0", (long)0L, (long)modifiedAclFeature.getRefCount());
        this.fs.removeAcl(child2);
        Assert.assertEquals((String)"Reference count should be 1", (long)1L, (long)child1AclFeature.getRefCount());
        this.fs.delete(child1, true);
        Assert.assertEquals((String)"Reference count should be 0", (long)0L, (long)child1AclFeature.getRefCount());
        Path file1 = new Path(p1, "file1");
        Path file2 = new Path(p1, "file2");
        this.fs.create(file1).close();
        AclFeature fileAclFeature = FSAclBaseTest.getAclFeature(file1, cluster);
        Assert.assertEquals((String)"Reference count should be 1", (long)1L, (long)fileAclFeature.getRefCount());
        this.fs.create(file2).close();
        Assert.assertEquals((String)"Reference count should be 2", (long)2L, (long)fileAclFeature.getRefCount());
        ArrayList aclSpec3 = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "user1", FsAction.ALL)});
        this.fs.modifyAclEntries(file1, (List)aclSpec3);
        AclFeature modifiedFileAcl = FSAclBaseTest.getAclFeature(file1, cluster);
        Assert.assertEquals((String)"Old Reference count should be 1", (long)1L, (long)fileAclFeature.getRefCount());
        Assert.assertEquals((String)"New Reference count should be 1", (long)1L, (long)modifiedFileAcl.getRefCount());
        AclEntry aclEntry2 = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setName("user1").build();
        this.fs.removeAclEntries(file1, (List)Lists.newArrayList((Object[])new AclEntry[]{aclEntry2}));
        Assert.assertEquals((String)"Old Reference count should be 2", (long)2L, (long)fileAclFeature.getRefCount());
        Assert.assertEquals((String)"New Reference count should be 0", (long)0L, (long)modifiedFileAcl.getRefCount());
        this.fs.delete(file2, true);
        Assert.assertEquals((String)"Reference count should be decreased on delete of the file", (long)1L, (long)fileAclFeature.getRefCount());
        this.fs.delete(file1, true);
        Assert.assertEquals((String)"Reference count should be decreased on delete of the file", (long)0L, (long)fileAclFeature.getRefCount());
        this.fs.create(file1).close();
        AclFeature newFileAclFeature = FSAclBaseTest.getAclFeature(file1, cluster);
        Assert.assertNotSame((String)"Instance should be different on reference count 0", (Object)fileAclFeature, (Object)newFileAclFeature);
        fileAclFeature = newFileAclFeature;
        HashMap<AclFeature, Integer> restartRefCounter = new HashMap<AclFeature, Integer>();
        ImmutableList entriesBeforeRestart = AclStorage.getUniqueAclFeatures().getEntries();
        for (AclFeature aclFeature : entriesBeforeRestart) {
            restartRefCounter.put(aclFeature, aclFeature.getRefCount());
        }
        cluster.restartNameNode(true);
        ImmutableList entriesAfterRestart = AclStorage.getUniqueAclFeatures().getEntries();
        Assert.assertEquals((String)"Entries before and after should be same", (Object)entriesBeforeRestart, (Object)entriesAfterRestart);
        for (AclFeature aclFeature : entriesAfterRestart) {
            before = (Integer)restartRefCounter.get(aclFeature);
            Assert.assertEquals((String)"ReferenceCount After Restart should be doubled", (long)(before * 2), (long)aclFeature.getRefCount());
        }
        cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
        cluster.getNameNodeRpc().saveNamespace(0L, 0L);
        cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
        cluster.restartNameNode(true);
        entriesAfterRestart = AclStorage.getUniqueAclFeatures().getEntries();
        Assert.assertEquals((String)"Entries before and after should be same", (Object)entriesBeforeRestart, (Object)entriesAfterRestart);
        for (AclFeature aclFeature : entriesAfterRestart) {
            before = (Integer)restartRefCounter.get(aclFeature);
            Assert.assertEquals((String)"ReferenceCount After 2 Restarts should be tripled", (long)(before * 3), (long)aclFeature.getRefCount());
        }
    }

    protected FileSystem createFileSystem() throws Exception {
        return cluster.getFileSystem();
    }

    protected FileSystem createFileSystem(UserGroupInformation user) throws Exception {
        return DFSTestUtil.getFileSystemAs(user, cluster.getConfiguration(0));
    }

    private void initFileSystems() throws Exception {
        this.fs = this.createFileSystem();
        this.fsAsBruce = this.createFileSystem(BRUCE);
        this.fsAsDiana = this.createFileSystem(DIANA);
        this.fsAsBob = this.createFileSystem(BOB);
        this.fsAsSupergroupMember = this.createFileSystem(SUPERGROUP_MEMBER);
    }

    private void restartCluster() throws Exception {
        this.destroyFileSystems();
        FSAclBaseTest.shutdown();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(false).build();
        cluster.waitActive();
        this.initFileSystems();
    }

    private static void assertAclFeature(boolean expectAclFeature) throws IOException {
        FSAclBaseTest.assertAclFeature(path, expectAclFeature);
    }

    private static void assertAclFeature(Path pathToCheck, boolean expectAclFeature) throws IOException {
        FSAclBaseTest.assertAclFeature(cluster, pathToCheck, expectAclFeature);
    }

    public static void assertAclFeature(MiniDFSCluster miniCluster, Path pathToCheck, boolean expectAclFeature) throws IOException {
        AclFeature aclFeature = FSAclBaseTest.getAclFeature(pathToCheck, miniCluster);
        if (expectAclFeature) {
            Assert.assertNotNull((Object)aclFeature);
            ImmutableList entries = AclStorage.getEntriesFromAclFeature((AclFeature)aclFeature);
            Assert.assertFalse((boolean)entries.isEmpty());
        } else {
            Assert.assertNull((Object)aclFeature);
        }
    }

    public static AclFeature getAclFeature(Path pathToCheck, MiniDFSCluster cluster) throws IOException {
        INode inode = cluster.getNamesystem().getFSDirectory().getINode(pathToCheck.toUri().getPath(), FSDirectory.DirOp.READ_LINK);
        Assert.assertNotNull((Object)inode);
        AclFeature aclFeature = inode.getAclFeature();
        return aclFeature;
    }

    private void assertPermission(short perm) throws IOException {
        this.assertPermission(path, perm);
    }

    private void assertPermission(Path pathToCheck, short perm) throws IOException {
        AclTestHelpers.assertPermission(this.fs, pathToCheck, perm);
    }

    static {
        pathCount = 0;
    }
}

