/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirDeleteOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirRenameOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.util.Time;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestGetBlockLocations {
    private static final String FILE_NAME = "foo";
    private static final String FILE_PATH = "/foo";
    private static final long MOCK_INODE_ID = 16386L;
    private static final String RESERVED_PATH = "/.reserved/.inodes/16386";

    @Test(timeout=30000L)
    public void testResolveReservedPath() throws IOException {
        FSNamesystem fsn = TestGetBlockLocations.setupFileSystem();
        FSEditLog editlog = fsn.getEditLog();
        fsn.getBlockLocations("dummy", RESERVED_PATH, 0L, 1024L);
        ((FSEditLog)Mockito.verify((Object)editlog)).logTimes((String)Mockito.eq((Object)FILE_PATH), Mockito.anyLong(), Mockito.anyLong());
        fsn.close();
    }

    @Test(timeout=30000L)
    public void testGetBlockLocationsRacingWithDelete() throws IOException {
        FSNamesystem fsn = (FSNamesystem)Mockito.spy((Object)TestGetBlockLocations.setupFileSystem());
        final FSDirectory fsd = fsn.getFSDirectory();
        FSEditLog editlog = fsn.getEditLog();
        ((FSNamesystem)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                INodesInPath iip = fsd.getINodesInPath(TestGetBlockLocations.FILE_PATH, FSDirectory.DirOp.READ);
                FSDirDeleteOp.delete((FSDirectory)fsd, (INodesInPath)iip, (INode.BlocksMapUpdateInfo)new INode.BlocksMapUpdateInfo(), new ArrayList(), new ArrayList(), (long)Time.now());
                invocation.callRealMethod();
                return null;
            }
        }).when((Object)fsn)).writeLock();
        fsn.getBlockLocations("dummy", RESERVED_PATH, 0L, 1024L);
        ((FSEditLog)Mockito.verify((Object)editlog, (VerificationMode)Mockito.never())).logTimes(Mockito.anyString(), Mockito.anyLong(), Mockito.anyLong());
        fsn.close();
    }

    @Test(timeout=30000L)
    public void testGetBlockLocationsRacingWithRename() throws IOException {
        FSNamesystem fsn = (FSNamesystem)Mockito.spy((Object)TestGetBlockLocations.setupFileSystem());
        final FSDirectory fsd = fsn.getFSDirectory();
        FSEditLog editlog = fsn.getEditLog();
        String DST_PATH = "/bar";
        final boolean[] renamed = new boolean[1];
        ((FSNamesystem)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                invocation.callRealMethod();
                if (!renamed[0]) {
                    FSDirRenameOp.renameTo((FSDirectory)fsd, (FSPermissionChecker)fsd.getPermissionChecker(), (String)TestGetBlockLocations.FILE_PATH, (String)"/bar", (INode.BlocksMapUpdateInfo)new INode.BlocksMapUpdateInfo(), (boolean)false, (Options.Rename[])new Options.Rename[0]);
                    renamed[0] = true;
                }
                return null;
            }
        }).when((Object)fsn)).writeLock();
        fsn.getBlockLocations("dummy", RESERVED_PATH, 0L, 1024L);
        ((FSEditLog)Mockito.verify((Object)editlog)).logTimes((String)Mockito.eq((Object)"/bar"), Mockito.anyLong(), Mockito.anyLong());
        fsn.close();
    }

    private static FSNamesystem setupFileSystem() throws IOException {
        Configuration conf = new Configuration();
        conf.setLong("dfs.namenode.accesstime.precision", 1L);
        FSEditLog editlog = (FSEditLog)Mockito.mock(FSEditLog.class);
        FSImage image = (FSImage)Mockito.mock(FSImage.class);
        Mockito.when((Object)image.getEditLog()).thenReturn((Object)editlog);
        FSNamesystem fsn = new FSNamesystem(conf, image, true);
        FSDirectory fsd = fsn.getFSDirectory();
        INodesInPath iip = fsd.getINodesInPath("/", FSDirectory.DirOp.READ);
        PermissionStatus perm = new PermissionStatus("hdfs", "supergroup", FsPermission.createImmutable((short)511));
        INodeFile file = new INodeFile(16386L, FILE_NAME.getBytes(StandardCharsets.UTF_8), perm, 1L, 1L, new BlockInfo[0], 1, 0x8000000L);
        fsn.getFSDirectory().addINode(iip, (INode)file, null);
        return fsn;
    }
}

