/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraintTransformations;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTags;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManager;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class PlacementConstraintsUtil {
    private static final Log LOG = LogFactory.getLog(PlacementConstraintsUtil.class);

    private PlacementConstraintsUtil() {
    }

    private static boolean canSatisfySingleConstraintExpression(ApplicationId targetApplicationId, PlacementConstraint.SingleConstraint sc, PlacementConstraint.TargetExpression te, SchedulerNode node, AllocationTagsManager tm) throws InvalidAllocationTagsQueryException {
        boolean checkMaxCardinality;
        AllocationTags allocationTags = AllocationTags.createAllocationTags(targetApplicationId, te.getTargetKey(), te.getTargetValues());
        long minScopeCardinality = 0L;
        long maxScopeCardinality = 0L;
        int desiredMinCardinality = sc.getMinCardinality();
        int desiredMaxCardinality = sc.getMaxCardinality();
        boolean checkMinCardinality = desiredMinCardinality > 0;
        boolean bl = checkMaxCardinality = desiredMaxCardinality < Integer.MAX_VALUE;
        if (sc.getScope().equals("node")) {
            if (checkMinCardinality) {
                minScopeCardinality = tm.getNodeCardinalityByOp(node.getNodeID(), allocationTags, Long::min);
            }
            if (checkMaxCardinality) {
                maxScopeCardinality = tm.getNodeCardinalityByOp(node.getNodeID(), allocationTags, Long::max);
            }
        } else if (sc.getScope().equals("rack")) {
            if (checkMinCardinality) {
                minScopeCardinality = tm.getRackCardinalityByOp(node.getRackName(), allocationTags, Long::min);
            }
            if (checkMaxCardinality) {
                maxScopeCardinality = tm.getRackCardinalityByOp(node.getRackName(), allocationTags, Long::max);
            }
        }
        return !(desiredMinCardinality > 0 && minScopeCardinality < (long)desiredMinCardinality || desiredMaxCardinality != Integer.MAX_VALUE && maxScopeCardinality > (long)desiredMaxCardinality);
    }

    private static boolean canSatisfyNodePartitionConstraintExpresssion(PlacementConstraint.TargetExpression targetExpression, SchedulerNode schedulerNode) {
        Set values = targetExpression.getTargetValues();
        if (values == null || values.isEmpty()) {
            return schedulerNode.getPartition().equals("");
        }
        String nodePartition = (String)values.iterator().next();
        return nodePartition.equals(schedulerNode.getPartition());
    }

    private static boolean canSatisfySingleConstraint(ApplicationId applicationId, PlacementConstraint.SingleConstraint singleConstraint, SchedulerNode schedulerNode, AllocationTagsManager tagsManager) throws InvalidAllocationTagsQueryException {
        for (PlacementConstraint.TargetExpression currentExp : singleConstraint.getTargetExpressions()) {
            if (!(currentExp.getTargetType().equals((Object)PlacementConstraint.TargetExpression.TargetType.ALLOCATION_TAG) ? !PlacementConstraintsUtil.canSatisfySingleConstraintExpression(applicationId, singleConstraint, currentExp, schedulerNode, tagsManager) : currentExp.getTargetType().equals((Object)PlacementConstraint.TargetExpression.TargetType.NODE_ATTRIBUTE) && currentExp.getTargetKey().equals("yarn_node_partition/") && !PlacementConstraintsUtil.canSatisfyNodePartitionConstraintExpresssion(currentExp, schedulerNode))) continue;
            return false;
        }
        return true;
    }

    private static boolean canSatisfyAndConstraint(ApplicationId appId, PlacementConstraint.And constraint, SchedulerNode node, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        for (PlacementConstraint.AbstractConstraint child : constraint.getChildren()) {
            if (PlacementConstraintsUtil.canSatisfyConstraints(appId, child.build(), node, atm)) continue;
            return false;
        }
        return true;
    }

    private static boolean canSatisfyOrConstraint(ApplicationId appId, PlacementConstraint.Or constraint, SchedulerNode node, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        for (PlacementConstraint.AbstractConstraint child : constraint.getChildren()) {
            if (!PlacementConstraintsUtil.canSatisfyConstraints(appId, child.build(), node, atm)) continue;
            return true;
        }
        return false;
    }

    private static boolean canSatisfyConstraints(ApplicationId appId, PlacementConstraint constraint, SchedulerNode node, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        if (constraint == null) {
            return true;
        }
        PlacementConstraintTransformations.SingleConstraintTransformer singleTransformer = new PlacementConstraintTransformations.SingleConstraintTransformer(constraint);
        PlacementConstraint.AbstractConstraint sConstraintExpr = (constraint = singleTransformer.transform()).getConstraintExpr();
        if (sConstraintExpr instanceof PlacementConstraint.SingleConstraint) {
            PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
            return PlacementConstraintsUtil.canSatisfySingleConstraint(appId, single, node, atm);
        }
        if (sConstraintExpr instanceof PlacementConstraint.And) {
            PlacementConstraint.And and = (PlacementConstraint.And)sConstraintExpr;
            return PlacementConstraintsUtil.canSatisfyAndConstraint(appId, and, node, atm);
        }
        if (sConstraintExpr instanceof PlacementConstraint.Or) {
            PlacementConstraint.Or or = (PlacementConstraint.Or)sConstraintExpr;
            return PlacementConstraintsUtil.canSatisfyOrConstraint(appId, or, node, atm);
        }
        throw new InvalidAllocationTagsQueryException("Unsupported type of constraint: " + sConstraintExpr.getClass().getSimpleName());
    }

    public static boolean canSatisfyConstraints(ApplicationId applicationId, SchedulingRequest request, SchedulerNode schedulerNode, PlacementConstraintManager pcm, AllocationTagsManager atm) throws InvalidAllocationTagsQueryException {
        Set sourceTags = null;
        PlacementConstraint pc = null;
        if (request != null) {
            sourceTags = request.getAllocationTags();
            pc = request.getPlacementConstraint();
        }
        return PlacementConstraintsUtil.canSatisfyConstraints(applicationId, pcm.getMultilevelConstraint(applicationId, sourceTags, pc), schedulerNode, atm);
    }
}

