/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.exceptions.BadConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHelper {
    private static final Logger log = LoggerFactory.getLogger(ConfigHelper.class);

    public static void addConfigMap(Configuration config, Map<String, String> map, String origin) throws BadConfigException {
        ConfigHelper.addConfigMap(config, map.entrySet(), origin);
    }

    public static void addConfigMap(Configuration config, Iterable<Map.Entry<String, String>> map, String origin) throws BadConfigException {
        for (Map.Entry<String, String> mapEntry : map) {
            String key = mapEntry.getKey();
            String value = mapEntry.getValue();
            if (value == null) {
                throw new BadConfigException("Null value for property " + key);
            }
            config.set(key, value, origin);
        }
    }

    public static String toXml(Configuration conf) throws IOException {
        StringWriter writer = new StringWriter();
        conf.writeXml((Writer)writer);
        return writer.toString();
    }

    public static URL registerDefaultResource(String resource) {
        URL resURL = ConfigHelper.getResourceUrl(resource);
        if (resURL != null) {
            Configuration.addDefaultResource((String)resource);
        }
        return resURL;
    }

    public static Configuration loadFromResource(String resource) {
        Configuration conf = new Configuration(false);
        URL resURL = ConfigHelper.getResourceUrl(resource);
        if (resURL != null) {
            log.debug("loaded resources from {}", (Object)resURL);
            conf.addResource(resource);
        } else {
            log.debug("failed to find {} on the classpath", (Object)resource);
        }
        return conf;
    }

    public static URL getResourceUrl(String resource) {
        return ConfigHelper.class.getClassLoader().getResource(resource);
    }

    public static Configuration resolveConfiguration(Iterable<Map.Entry<String, String>> keysource, Configuration valuesource) {
        Configuration result = new Configuration(false);
        for (Map.Entry<String, String> entry : keysource) {
            String key = entry.getKey();
            String value = valuesource.get(key);
            Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"no reference for \"%s\" in values", (Object)key);
            result.set(key, value);
        }
        return result;
    }
}

