/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.service.utils.CoreFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderFileSystem
extends CoreFileSystem {
    Path appDir = null;
    private static final Logger LOG = LoggerFactory.getLogger(SliderFileSystem.class);

    public SliderFileSystem(FileSystem fileSystem, Configuration configuration) {
        super(fileSystem, configuration);
    }

    public SliderFileSystem(Configuration configuration) throws IOException {
        super(configuration);
    }

    public void setAppDir(Path appDir) {
        this.appDir = appDir;
    }

    public Path getAppDir() {
        return this.appDir;
    }

    public Path getComponentDir(String serviceVersion, String compName) {
        return new Path(new Path(this.getAppDir(), "components"), serviceVersion + "/" + compName);
    }

    public void deleteComponentDir(String serviceVersion, String compName) throws IOException {
        Path path = this.getComponentDir(serviceVersion, compName);
        if (this.fileSystem.exists(path)) {
            this.fileSystem.delete(path, true);
            LOG.debug("deleted dir {}", (Object)path);
        }
    }

    public void deleteComponentsVersionDirIfEmpty(String serviceVersion) throws IOException {
        Path path = new Path(new Path(this.getAppDir(), "components"), serviceVersion);
        if (this.fileSystem.exists(path) && this.fileSystem.listStatus(path).length == 0) {
            this.fileSystem.delete(path, true);
            LOG.info("deleted dir {}", (Object)path);
        }
    }
}

