/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.lib.server.ServerException;
import org.apache.hadoop.lib.service.FileSystemAccess;
import org.apache.hadoop.lib.servlet.ServerWebApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HttpFSServerWebApp
extends ServerWebApp {
    private static final Logger LOG = LoggerFactory.getLogger(HttpFSServerWebApp.class);
    public static final String NAME = "httpfs";
    public static final String CONF_ADMIN_GROUP = "admin.group";
    private static HttpFSServerWebApp SERVER;
    private String adminGroup;

    public HttpFSServerWebApp() throws IOException {
        super(NAME);
    }

    public HttpFSServerWebApp(String homeDir, String configDir, String logDir, String tempDir, Configuration config) {
        super(NAME, homeDir, configDir, logDir, tempDir, config);
    }

    public HttpFSServerWebApp(String homeDir, Configuration config) {
        super(NAME, homeDir, config);
    }

    @Override
    public void init() throws ServerException {
        if (SERVER != null) {
            throw new RuntimeException("HttpFSServer server already initialized");
        }
        SERVER = this;
        super.init();
        this.adminGroup = this.getConfig().get(this.getPrefixedName(CONF_ADMIN_GROUP), "admin");
        LOG.info("Connects to Namenode [{}]", (Object)HttpFSServerWebApp.get().get(FileSystemAccess.class).getFileSystemConfiguration().get("fs.defaultFS"));
    }

    @Override
    public void destroy() {
        SERVER = null;
        super.destroy();
    }

    public static HttpFSServerWebApp get() {
        return SERVER;
    }

    public String getAdminGroup() {
        return this.adminGroup;
    }
}

